/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.user.AmityMembershipType;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.google.common.base.Objects;
import com.google.gson.Gson;

public class ChannelDidBanListener
extends SocketEventListener {
    private final Gson gson = EkoGson.get();
    private final EkoMessageDao messageDao = UserDatabase.get().messageDao();
    private final EkoChannelMembershipDao membershipDao = UserDatabase.get().channelMembershipDao();

    @Override
    @NonNull
    public String getEvent() {
        return "v3.channel.didBan";
    }

    @Override
    protected void onEvent(@NonNull String event, Object ... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        ChannelEvent eventData = (ChannelEvent)this.gson.fromJson(json, ChannelEvent.class);
        if (eventData.getChannelDtoList() != null && !eventData.getChannelDtoList().isEmpty() && eventData.getChannelMembershipDtoList() != null && !eventData.getChannelMembershipDtoList().isEmpty()) {
            EkoChannelDto channelEvent = eventData.getChannelDtoList().get(0);
            EkoChannelMembershipDto membershipEvent = eventData.getChannelMembershipDtoList().get(0);
            this.membershipDao.updateMembership(channelEvent.getChannelId(), membershipEvent.getUserId(), AmityMembershipType.BANNED.getApiKey());
            if (Objects.equal((Object)AmityCoreClient.INSTANCE.getUserId(), (Object)membershipEvent.getUserId())) {
                this.messageDao.softDeleteAllFromChannel(channelEvent.getChannelId());
            } else {
                this.messageDao.softDeleteFromChannelByUserId(channelEvent.getChannelId(), membershipEvent.getUserId());
            }
        }
    }
}

