/*
 * Decompiled with CFR 0.152.
 */
package co.amity.rxupload.internal.datastore;

import android.util.Log;
import co.amity.rxupload.FileProperties;
import co.amity.rxupload.internal.datastore.FileRemoteDataStore;
import co.amity.rxupload.internal.datastore.FileWritingListener;
import co.amity.rxupload.service.MultipartUploadService;
import co.amity.rxupload.service.api.MultipartUploadApi;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.io.File;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J`\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\nJ\u001d\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lco/amity/rxupload/internal/datastore/FileRemoteDataStore;", "", "()V", "upload", "Lio/reactivex/rxjava3/core/Flowable;", "Lco/amity/rxupload/FileProperties;", "file", "Ljava/io/File;", "fileProperties", "path", "", "headers", "", "params", "id", "multipartDataKey", "appendQuotedString", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "key", "appendQuotedString$amity_rxupload_release", "Companion", "amity-rxupload_release"})
@SourceDebugExtension(value={"SMAP\nFileRemoteDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileRemoteDataStore.kt\nco/amity/rxupload/internal/datastore/FileRemoteDataStore\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n442#2:188\n392#2:189\n1238#3,4:190\n*S KotlinDebug\n*F\n+ 1 FileRemoteDataStore.kt\nco/amity/rxupload/internal/datastore/FileRemoteDataStore\n*L\n109#1:188\n109#1:189\n109#1:190,4\n*E\n"})
public final class FileRemoteDataStore {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Flowable<FileProperties> upload(@NotNull File file, @NotNull FileProperties fileProperties, @NotNull String path, @NotNull Map<String, ? extends Object> headers, @NotNull Map<String, ? extends Object> params, @Nullable String id, @NotNull String multipartDataKey) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileProperties, (String)"fileProperties");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)multipartDataKey, (String)"multipartDataKey");
        Flowable flowable = Flowable.fromPublisher(arg_0 -> FileRemoteDataStore.upload$lambda$2(fileProperties, file, path, headers, params, id, this, multipartDataKey, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"fromPublisher<FileProper\u2026\n            })\n        }");
        return flowable;
    }

    public static /* synthetic */ Flowable upload$default(FileRemoteDataStore fileRemoteDataStore, File file, FileProperties fileProperties, String string, Map map, Map map2, String string2, String string3, int n, Object object) {
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        return fileRemoteDataStore.upload(file, fileProperties, string, map, map2, string2, string3);
    }

    public final void appendQuotedString$amity_rxupload_release(@NotNull StringBuilder $this$appendQuotedString, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$appendQuotedString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        $this$appendQuotedString.append('\"');
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            char ch = key.charAt(i);
            if (ch == '\n') {
                $this$appendQuotedString.append("%0A");
                continue;
            }
            if (ch == '\r') {
                $this$appendQuotedString.append("%0D");
                continue;
            }
            if (ch == '\"') {
                $this$appendQuotedString.append("%22");
                continue;
            }
            $this$appendQuotedString.append(ch);
        }
        $this$appendQuotedString.append('\"');
    }

    /*
     * WARNING - void declaration
     */
    private static final void upload$lambda$2(FileProperties $fileProperties, File $file, String $path, Map $headers, Map $params, String $id, FileRemoteDataStore this$0, String $multipartDataKey, Subscriber it) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$fileProperties, (String)"$fileProperties");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$headers, (String)"$headers");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$multipartDataKey, (String)"$multipartDataKey");
        MediaType mediaType = MediaType.Companion.get($fileProperties.getMimeType());
        RequestBody requestBody2 = Companion.asProgressRequestBody(RequestBody.Companion.create($file, mediaType), new FileWritingListener((Subscriber<? super FileProperties>)it, $fileProperties, $id){
            final /* synthetic */ Subscriber<? super FileProperties> $it;
            final /* synthetic */ FileProperties $fileProperties;
            final /* synthetic */ String $id;
            {
                this.$it = $it;
                this.$fileProperties = $fileProperties;
                this.$id = $id;
            }

            /*
             * WARNING - void declaration
             */
            public void onWrite(long bytesWritten, long contentLength) {
                block0: {
                    void $this$onWrite_u24lambda_u241;
                    void $this$onWrite_u24lambda_u240;
                    FileProperties fileProperties;
                    int progress = Math.min((int)Math.floor((double)bytesWritten / (double)contentLength * 100.0), 99);
                    FileProperties fileProperties2 = fileProperties = this.$fileProperties;
                    Subscriber<? super FileProperties> subscriber = this.$it;
                    boolean $i$a$-apply-FileRemoteDataStore$upload$1$requestBody$1$onWrite$32 = false;
                    $this$onWrite_u24lambda_u240.setBytesWritten(bytesWritten);
                    $this$onWrite_u24lambda_u240.setContentLength(contentLength);
                    $this$onWrite_u24lambda_u240.setProgress(progress);
                    subscriber.onNext((Object)fileProperties);
                    PublishSubject<FileProperties> publishSubject = MultipartUploadService.Companion.properties(this.$id);
                    if (publishSubject == null) break block0;
                    FileProperties $i$a$-apply-FileRemoteDataStore$upload$1$requestBody$1$onWrite$32 = fileProperties2 = this.$fileProperties;
                    subscriber = publishSubject;
                    boolean bl = false;
                    $this$onWrite_u24lambda_u241.setBytesWritten(bytesWritten);
                    $this$onWrite_u24lambda_u241.setContentLength(contentLength);
                    $this$onWrite_u24lambda_u241.setProgress(progress);
                    subscriber.onNext((Object)fileProperties2);
                }
            }
        });
        String filename = $fileProperties.getFileName();
        Log.e((String)"FileRemoteDataStore", (String)("upload: " + filename));
        StringBuilder $this$upload_u24lambda_u242_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$upload_u24lambda_u242_u24lambda_u240.append("form-data; name=");
        this$0.appendQuotedString$amity_rxupload_release($this$upload_u24lambda_u242_u24lambda_u240, $multipartDataKey);
        $this$upload_u24lambda_u242_u24lambda_u240.append("; filename=");
        this$0.appendQuotedString$amity_rxupload_release($this$upload_u24lambda_u242_u24lambda_u240, filename);
        $this$upload_u24lambda_u242_u24lambda_u240.append("; filename*=");
        $this$upload_u24lambda_u242_u24lambda_u240.append("UTF-8");
        $this$upload_u24lambda_u242_u24lambda_u240.append('\'');
        $this$upload_u24lambda_u242_u24lambda_u240.append('\'');
        $this$upload_u24lambda_u242_u24lambda_u240.append(URLEncoder.encode(filename, "UTF-8"));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String disposition = string;
        Log.e((String)"FileRemoteDataStore", (String)("disposition: " + disposition));
        Headers partHeaders = new Headers.Builder().addUnsafeNonAscii("Content-Disposition", disposition).build();
        MultipartBody.Part multipartBody = MultipartBody.Part.Companion.create(partHeaders, requestBody2);
        MultipartUploadApi multipartUploadApi = MultipartUploadService.Companion.getUploadApi();
        Map map2 = $params;
        MultipartBody.Part part = multipartBody;
        Map map3 = $headers;
        String string2 = $path;
        MultipartUploadApi multipartUploadApi2 = multipartUploadApi;
        boolean $i$f$mapValues = false;
        void var19_23 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void param;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl3 = false;
            RequestBody requestBody3 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (String)param.getValue().toString(), null, (int)1, null);
            map.put(k, requestBody3);
        }
        map = destination$iv$iv;
        Call<ResponseBody> call = multipartUploadApi2.upload(string2, map3, part, map);
        MultipartUploadService.Companion.onRequest(call, $id);
        call.enqueue((Callback)new Callback<ResponseBody>((Subscriber<? super FileProperties>)it, $id, $fileProperties){
            final /* synthetic */ Subscriber<? super FileProperties> $it;
            final /* synthetic */ String $id;
            final /* synthetic */ FileProperties $fileProperties;
            {
                this.$it = $it;
                this.$id = $id;
                this.$fileProperties = $fileProperties;
            }

            public void onFailure(@NotNull Call<ResponseBody> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$it.onError(t);
                this.$it.onComplete();
                MultipartUploadService.Companion.onFailure(this.$id);
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull Call<ResponseBody> call, @NotNull Response<ResponseBody> response) {
                Unit unit;
                Object $this$onResponse_u24lambda_u241_u24lambda_u240;
                Object object;
                Object object2;
                Subscriber<? super FileProperties> subscriber;
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                Subscriber<? super FileProperties> subscriber2 = response.errorBody();
                if (subscriber2 != null) {
                    subscriber = subscriber2;
                    object2 = this.$it;
                    Subscriber<? super FileProperties> error = subscriber;
                    boolean bl = false;
                    Object object3 = object = new Object();
                    Subscriber<? super FileProperties> subscriber3 = object2;
                    boolean bl2 = false;
                    $this$onResponse_u24lambda_u241_u24lambda_u240.addProperty("errorCode", (Number)response.code());
                    $this$onResponse_u24lambda_u241_u24lambda_u240.addProperty("errorBody", error.string());
                    String string = object.toString();
                    subscriber3.onError((Throwable)new Exception(string));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    void $this$onResponse_u24lambda_u244_u24lambda_u243;
                    upload.1.1 var3_12 = this;
                    subscriber = this.$it;
                    object2 = this.$fileProperties;
                    upload.1.1 $this$onResponse_u24lambda_u244 = var3_12;
                    boolean bl = false;
                    $this$onResponse_u24lambda_u241_u24lambda_u240 = object = object2;
                    Subscriber<? super FileProperties> subscriber4 = subscriber;
                    boolean bl3 = false;
                    ResponseBody responseBody = (ResponseBody)response.body();
                    String jsonString = responseBody != null ? responseBody.string() : null;
                    boolean bl4 = false;
                    JsonElement jsonElement = JsonParser.parseString((String)jsonString);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseString(jsonString)");
                    $this$onResponse_u24lambda_u244_u24lambda_u243.setResponseBody(jsonElement);
                    $this$onResponse_u24lambda_u244_u24lambda_u243.setProgress(100);
                    subscriber4.onNext(object);
                }
                this.$it.onComplete();
                MultipartUploadService.Companion.onResponse(this.$id);
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lco/amity/rxupload/internal/datastore/FileRemoteDataStore$Companion;", "", "()V", "asProgressRequestBody", "Lokhttp3/RequestBody;", "listener", "Lco/amity/rxupload/internal/datastore/FileWritingListener;", "amity-rxupload_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RequestBody asProgressRequestBody(@NotNull RequestBody $this$asProgressRequestBody, @NotNull FileWritingListener listener) {
            Intrinsics.checkNotNullParameter((Object)$this$asProgressRequestBody, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Ref.LongRef bytesWritten = new Ref.LongRef();
            return new RequestBody($this$asProgressRequestBody, bytesWritten, listener){
                final /* synthetic */ RequestBody $this_asProgressRequestBody;
                final /* synthetic */ Ref.LongRef $bytesWritten;
                final /* synthetic */ FileWritingListener $listener;
                {
                    this.$this_asProgressRequestBody = $receiver;
                    this.$bytesWritten = $bytesWritten;
                    this.$listener = $listener;
                }

                @Nullable
                public MediaType contentType() {
                    return this.$this_asProgressRequestBody.contentType();
                }

                public long contentLength() {
                    return this.$this_asProgressRequestBody.contentLength();
                }

                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    BufferedSink forwardingSink2 = Okio.buffer((Sink)((Sink)new ForwardingSink(sink, this.$bytesWritten, this.$listener, this){
                        final /* synthetic */ Ref.LongRef $bytesWritten;
                        final /* synthetic */ FileWritingListener $listener;
                        final /* synthetic */ asProgressRequestBody.1 this$0;
                        {
                            this.$bytesWritten = $bytesWritten;
                            this.$listener = $listener;
                            this.this$0 = $receiver;
                            super((Sink)$sink);
                        }

                        public void write(@NotNull Buffer source, long byteCount) {
                            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                            super.write(source, byteCount);
                            this.$bytesWritten.element += byteCount;
                            this.$listener.onWrite(this.$bytesWritten.element, this.this$0.contentLength());
                        }
                    }));
                    this.$this_asProgressRequestBody.writeTo(forwardingSink2);
                    forwardingSink2.flush();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

