/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundMovePlayerRotPacket
implements MinecraftPacket {
    private final boolean onGround;
    private final float yaw;
    private final float pitch;

    public ServerboundMovePlayerRotPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
        this.onGround = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
        out.writeBoolean(this.onGround);
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMovePlayerRotPacket)) {
            return false;
        }
        ServerboundMovePlayerRotPacket other = (ServerboundMovePlayerRotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        return Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundMovePlayerRotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundMovePlayerRotPacket(onGround=" + this.isOnGround() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public @NonNull ServerboundMovePlayerRotPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerboundMovePlayerRotPacket(onGround, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerRotPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerboundMovePlayerRotPacket(this.onGround, yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerRotPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerboundMovePlayerRotPacket(this.onGround, this.yaw, pitch);
    }

    public ServerboundMovePlayerRotPacket(boolean onGround, float yaw, float pitch) {
        this.onGround = onGround;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

