/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundPickItemPacket
implements MinecraftPacket {
    private final int slot;

    public ServerboundPickItemPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.slot = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.slot);
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPickItemPacket)) {
            return false;
        }
        ServerboundPickItemPacket other = (ServerboundPickItemPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSlot() == other.getSlot();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPickItemPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPickItemPacket(slot=" + this.getSlot() + ")";
    }

    public @NonNull ServerboundPickItemPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundPickItemPacket(slot);
    }

    public ServerboundPickItemPacket(int slot) {
        this.slot = slot;
    }
}

