/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundContainerButtonClickPacket
implements MinecraftPacket {
    private final int containerId;
    private final int buttonId;

    public ServerboundContainerButtonClickPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.containerId = helper.readVarInt(in);
        this.buttonId = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.containerId);
        helper.writeVarInt(out, this.buttonId);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getButtonId() {
        return this.buttonId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundContainerButtonClickPacket)) {
            return false;
        }
        ServerboundContainerButtonClickPacket other = (ServerboundContainerButtonClickPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        return this.getButtonId() == other.getButtonId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundContainerButtonClickPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getButtonId();
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundContainerButtonClickPacket(containerId=" + this.getContainerId() + ", buttonId=" + this.getButtonId() + ")";
    }

    public @NonNull ServerboundContainerButtonClickPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ServerboundContainerButtonClickPacket(containerId, this.buttonId);
    }

    public @NonNull ServerboundContainerButtonClickPacket withButtonId(int buttonId) {
        return this.buttonId == buttonId ? this : new ServerboundContainerButtonClickPacket(this.containerId, buttonId);
    }

    public ServerboundContainerButtonClickPacket(int containerId, int buttonId) {
        this.containerId = containerId;
        this.buttonId = buttonId;
    }
}

