/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.SessionService;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.SecretKey;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.event.session.ConnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.DisconnectingEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionAdapter;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.ServerLoginHandler;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;
import org.geysermc.mcprotocollib.protocol.data.status.PlayerInfo;
import org.geysermc.mcprotocollib.protocol.data.status.ServerStatusInfo;
import org.geysermc.mcprotocollib.protocol.data.status.VersionInfo;
import org.geysermc.mcprotocollib.protocol.data.status.handler.ServerInfoBuilder;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundRegistryDataPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundConfigurationAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundGameProfilePacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginCompressionPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundKeyPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundLoginAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.status.clientbound.ClientboundPongResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.status.clientbound.ClientboundStatusResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.status.serverbound.ServerboundPingRequestPacket;
import org.geysermc.mcprotocollib.protocol.packet.status.serverbound.ServerboundStatusRequestPacket;

public class ServerListener
extends SessionAdapter {
    private static final int DEFAULT_COMPRESSION_THRESHOLD = 256;
    private static final String SERVER_ID = "";
    private static final KeyPair KEY_PAIR;
    private final NbtMap networkCodec;
    private final byte[] challenge = new byte[4];
    private String username = "";
    private boolean keepAlivePending;
    private long keepAliveChallenge;
    private long keepAliveTime;
    private boolean isTransfer = false;

    public ServerListener(NbtMap networkCodec) {
        this.networkCodec = networkCodec;
        ThreadLocalRandom.current().nextBytes(this.challenge);
    }

    @Override
    public void connected(ConnectedEvent event) {
        event.getSession().setFlag(MinecraftConstants.PING_KEY, 0L);
    }

    @Override
    public void packetReceived(Session session, Packet packet) {
        MinecraftProtocol protocol = (MinecraftProtocol)session.getPacketProtocol();
        if (protocol.getInboundState() == ProtocolState.HANDSHAKE) {
            if (packet instanceof ClientIntentionPacket) {
                ClientIntentionPacket intentionPacket = (ClientIntentionPacket)packet;
                switch (intentionPacket.getIntent()) {
                    case STATUS: {
                        session.switchOutboundProtocol(() -> protocol.setOutboundState(ProtocolState.STATUS));
                        session.switchInboundProtocol(() -> protocol.setInboundState(ProtocolState.STATUS));
                        break;
                    }
                    case TRANSFER: {
                        if (session.getFlag(MinecraftConstants.ACCEPT_TRANSFERS_KEY, false).booleanValue()) {
                            this.beginLogin(session, protocol, intentionPacket, true);
                            break;
                        }
                        session.switchOutboundProtocol(() -> protocol.setOutboundState(ProtocolState.LOGIN));
                        session.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.transfers_disabled"));
                        break;
                    }
                    case LOGIN: {
                        this.beginLogin(session, protocol, intentionPacket, false);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Invalid client intent: " + intentionPacket.getIntent());
                    }
                }
            }
        } else if (protocol.getInboundState() == ProtocolState.LOGIN) {
            if (packet instanceof ServerboundHelloPacket) {
                ServerboundHelloPacket helloPacket = (ServerboundHelloPacket)packet;
                this.username = helloPacket.getUsername();
                if (session.getFlag(MinecraftConstants.VERIFY_USERS_KEY, true).booleanValue()) {
                    session.send(new ClientboundHelloPacket(SERVER_ID, KEY_PAIR.getPublic(), this.challenge, true));
                } else {
                    new Thread(() -> this.authenticate(session, null)).start();
                }
            } else if (packet instanceof ServerboundKeyPacket) {
                ServerboundKeyPacket keyPacket = (ServerboundKeyPacket)packet;
                PrivateKey privateKey = KEY_PAIR.getPrivate();
                if (!Arrays.equals(this.challenge, keyPacket.getDecryptedChallenge(privateKey))) {
                    throw new IllegalStateException("Protocol error");
                }
                SecretKey key = keyPacket.getSecretKey(privateKey);
                session.enableEncryption(protocol.enableEncryption(key));
                new Thread(() -> this.authenticate(session, key)).start();
            } else if (packet instanceof ServerboundLoginAcknowledgedPacket) {
                session.switchOutboundProtocol(() -> protocol.setOutboundState(ProtocolState.CONFIGURATION));
                session.switchInboundProtocol(() -> protocol.setInboundState(ProtocolState.CONFIGURATION));
                for (Map.Entry entry : this.networkCodec.entrySet()) {
                    NbtMap entryTag = (NbtMap)entry.getValue();
                    Key typeTag = Key.key((String)entryTag.getString("type"));
                    List valueTag = entryTag.getList("value", NbtType.COMPOUND);
                    ArrayList<RegistryEntry> entries = new ArrayList<RegistryEntry>();
                    for (NbtMap compoundTag : valueTag) {
                        Key nameTag = Key.key((String)compoundTag.getString("name"));
                        int id = compoundTag.getInt("id");
                        entries.add(id, new RegistryEntry(nameTag, compoundTag.getCompound("element")));
                    }
                    session.send(new ClientboundRegistryDataPacket(typeTag, entries));
                }
                session.send(new ClientboundFinishConfigurationPacket());
            }
        } else if (protocol.getInboundState() == ProtocolState.STATUS) {
            if (packet instanceof ServerboundStatusRequestPacket) {
                ServerInfoBuilder builder = session.getFlag(MinecraftConstants.SERVER_INFO_BUILDER_KEY);
                if (builder == null) {
                    builder = $ -> new ServerStatusInfo(new VersionInfo(protocol.getCodec().getMinecraftVersion(), protocol.getCodec().getProtocolVersion()), new PlayerInfo(0, 20, new ArrayList<GameProfile>()), (Component)Component.text((String)"A Minecraft Server"), null, false);
                }
                ServerStatusInfo info = builder.buildInfo(session);
                session.send(new ClientboundStatusResponsePacket(info));
            } else if (packet instanceof ServerboundPingRequestPacket) {
                ServerboundPingRequestPacket pingRequestPacket = (ServerboundPingRequestPacket)packet;
                session.send(new ClientboundPongResponsePacket(pingRequestPacket.getPingTime()));
                session.disconnect((Component)Component.translatable((String)"multiplayer.status.request_handled"));
            }
        } else if (protocol.getInboundState() == ProtocolState.GAME) {
            if (packet instanceof ServerboundKeepAlivePacket) {
                ServerboundKeepAlivePacket keepAlivePacket = (ServerboundKeepAlivePacket)packet;
                if (this.keepAlivePending && keepAlivePacket.getPingId() == this.keepAliveChallenge) {
                    this.keepAlivePending = false;
                    session.setFlag(MinecraftConstants.PING_KEY, System.currentTimeMillis() - this.keepAliveTime);
                } else {
                    session.disconnect((Component)Component.translatable((String)"disconnect.timeout"));
                }
            } else if (packet instanceof ServerboundConfigurationAcknowledgedPacket) {
                session.switchInboundProtocol(() -> protocol.setInboundState(ProtocolState.CONFIGURATION));
            } else if (packet instanceof ServerboundPingRequestPacket) {
                ServerboundPingRequestPacket pingRequestPacket = (ServerboundPingRequestPacket)packet;
                session.send(new ClientboundPongResponsePacket(pingRequestPacket.getPingTime()));
            }
        } else if (protocol.getInboundState() == ProtocolState.CONFIGURATION && packet instanceof ServerboundFinishConfigurationPacket) {
            session.switchOutboundProtocol(() -> protocol.setOutboundState(ProtocolState.GAME));
            ServerLoginHandler handler = session.getFlag(MinecraftConstants.SERVER_LOGIN_HANDLER_KEY);
            if (handler != null) {
                handler.loggedIn(session);
            }
            if (session.getFlag(MinecraftConstants.AUTOMATIC_KEEP_ALIVE_MANAGEMENT, true).booleanValue()) {
                new Thread(() -> this.keepAlive(session)).start();
            }
        }
    }

    private void beginLogin(Session session, MinecraftProtocol protocol, ClientIntentionPacket packet, boolean transferred) {
        this.isTransfer = transferred;
        session.switchOutboundProtocol(() -> protocol.setOutboundState(ProtocolState.LOGIN));
        if (packet.getProtocolVersion() > protocol.getCodec().getProtocolVersion()) {
            session.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (ComponentLike[])new ComponentLike[]{Component.text((String)protocol.getCodec().getMinecraftVersion())}));
        } else if (packet.getProtocolVersion() < protocol.getCodec().getProtocolVersion()) {
            session.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.outdated_client", (ComponentLike[])new ComponentLike[]{Component.text((String)protocol.getCodec().getMinecraftVersion())}));
        } else {
            session.switchInboundProtocol(() -> protocol.setInboundState(ProtocolState.LOGIN));
        }
    }

    @Override
    public void disconnecting(DisconnectingEvent event) {
        Session session = event.getSession();
        MinecraftProtocol protocol = (MinecraftProtocol)session.getPacketProtocol();
        if (protocol.getOutboundState() == ProtocolState.LOGIN) {
            session.send(new ClientboundLoginDisconnectPacket(event.getReason()));
        } else if (protocol.getOutboundState() == ProtocolState.GAME) {
            session.send(new ClientboundDisconnectPacket(event.getReason()));
        }
    }

    private void authenticate(Session session, SecretKey key) {
        GameProfile profile;
        if (key != null) {
            SessionService sessionService = session.getFlag(MinecraftConstants.SESSION_SERVICE_KEY, new SessionService());
            try {
                profile = sessionService.getProfileByServer(this.username, sessionService.getServerId(SERVER_ID, KEY_PAIR.getPublic(), key));
            }
            catch (RequestException e) {
                session.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.authservers_down"), e);
                return;
            }
            if (profile == null) {
                session.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.unverified_username"));
            }
        } else {
            profile = new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.username).getBytes(StandardCharsets.UTF_8)), this.username);
        }
        session.setFlag(MinecraftConstants.PROFILE_KEY, profile);
        int threshold = session.getFlag(MinecraftConstants.SERVER_COMPRESSION_THRESHOLD, 256);
        if (threshold >= 0) {
            session.send(new ClientboundLoginCompressionPacket(threshold), () -> session.setCompressionThreshold(threshold, true));
        }
        session.send(new ClientboundGameProfilePacket(session.getFlag(MinecraftConstants.PROFILE_KEY), true));
    }

    private void keepAlive(Session session) {
        while (session.isConnected()) {
            if (this.keepAlivePending) {
                session.disconnect((Component)Component.translatable((String)"disconnect.timeout"));
                break;
            }
            long time = System.currentTimeMillis();
            this.keepAlivePending = true;
            this.keepAliveChallenge = time;
            this.keepAliveTime = time;
            session.send(new ClientboundKeepAlivePacket(this.keepAliveChallenge));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public boolean isTransfer() {
        return this.isTransfer;
    }

    static {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(1024);
            KEY_PAIR = gen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate server key pair.", e);
        }
    }
}

