/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.core;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.allenliu.versionchecklib.core.AVersionService;
import com.allenliu.versionchecklib.core.MyService;
import com.allenliu.versionchecklib.core.VersionDialogActivity;
import com.allenliu.versionchecklib.core.http.HttpHeaders;
import com.allenliu.versionchecklib.core.http.HttpParams;
import com.allenliu.versionchecklib.core.http.HttpRequestMethod;
import com.allenliu.versionchecklib.utils.FileHelper;
import java.io.Serializable;

@Deprecated
public class VersionParams
implements Parcelable {
    private String requestUrl;
    private String downloadAPKPath;
    private HttpHeaders httpHeaders;
    private long pauseRequestTime;
    private HttpRequestMethod requestMethod;
    private HttpParams requestParams;
    private Class<? extends VersionDialogActivity> customDownloadActivityClass;
    public boolean isForceRedownload;
    public boolean isSilentDownload;
    private Class<? extends AVersionService> service;
    private boolean onlyDownload;
    private String title;
    private String downloadUrl;
    private String updateMsg;
    private Bundle paramBundle;
    private boolean isShowDownloadingDialog;
    private boolean isShowNotification;
    private boolean isShowDownloadFailDialog;
    public static final Parcelable.Creator<VersionParams> CREATOR = new Parcelable.Creator<VersionParams>(){

        public VersionParams createFromParcel(Parcel source) {
            return new VersionParams(source);
        }

        public VersionParams[] newArray(int size) {
            return new VersionParams[size];
        }
    };

    public boolean isShowDownloadingDialog() {
        return this.isShowDownloadingDialog;
    }

    public boolean isShowDownloadFailDialog() {
        return this.isShowDownloadFailDialog;
    }

    public boolean isShowNotification() {
        return this.isShowNotification;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getUpdateMsg() {
        return this.updateMsg;
    }

    public Bundle getParamBundle() {
        return this.paramBundle;
    }

    private VersionParams() {
    }

    public VersionParams(String requestUrl, String downloadAPKPath, HttpHeaders httpHeaders, long pauseRequestTime, HttpRequestMethod requestMethod, HttpParams requestParams, Class<? extends VersionDialogActivity> customDownloadActivityClass, boolean isForceRedownload, boolean isSilentDownload, Class<? extends AVersionService> service, boolean onlyDownload, String title, String downloadUrl, String updateMsg, Bundle paramBundle) {
        this.requestUrl = requestUrl;
        this.downloadAPKPath = downloadAPKPath;
        this.httpHeaders = httpHeaders;
        this.pauseRequestTime = pauseRequestTime;
        this.requestMethod = requestMethod;
        this.requestParams = requestParams;
        this.customDownloadActivityClass = customDownloadActivityClass;
        this.isForceRedownload = isForceRedownload;
        this.isSilentDownload = isSilentDownload;
        this.service = service;
        this.onlyDownload = onlyDownload;
        this.title = title;
        this.downloadUrl = downloadUrl;
        this.updateMsg = updateMsg;
        this.paramBundle = paramBundle;
        if (this.service == null) {
            throw new RuntimeException("you must define your service which extends AVService.");
        }
        if (requestUrl == null) {
            throw new RuntimeException("requestUrl is needed.");
        }
    }

    public Class<? extends AVersionService> getService() {
        return this.service;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getDownloadAPKPath() {
        return this.downloadAPKPath;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public long getPauseRequestTime() {
        return this.pauseRequestTime;
    }

    public HttpRequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public HttpParams getRequestParams() {
        return this.requestParams;
    }

    public Class getCustomDownloadActivityClass() {
        return this.customDownloadActivityClass;
    }

    public boolean isForceRedownload() {
        return this.isForceRedownload;
    }

    public boolean isSilentDownload() {
        return this.isSilentDownload;
    }

    public boolean isOnlyDownload() {
        return this.onlyDownload;
    }

    public void setParamBundle(Bundle paramBundle) {
        this.paramBundle = paramBundle;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.requestUrl);
        dest.writeString(this.downloadAPKPath);
        dest.writeSerializable((Serializable)this.httpHeaders);
        dest.writeLong(this.pauseRequestTime);
        dest.writeInt(this.requestMethod == null ? -1 : this.requestMethod.ordinal());
        dest.writeSerializable((Serializable)this.requestParams);
        dest.writeSerializable(this.customDownloadActivityClass);
        dest.writeByte(this.isForceRedownload ? (byte)1 : 0);
        dest.writeByte(this.isSilentDownload ? (byte)1 : 0);
        dest.writeSerializable(this.service);
        dest.writeByte(this.onlyDownload ? (byte)1 : 0);
        dest.writeString(this.title);
        dest.writeString(this.downloadUrl);
        dest.writeString(this.updateMsg);
        dest.writeBundle(this.paramBundle);
        dest.writeByte(this.isShowDownloadingDialog ? (byte)1 : 0);
        dest.writeByte(this.isShowNotification ? (byte)1 : 0);
        dest.writeByte(this.isShowDownloadFailDialog ? (byte)1 : 0);
    }

    protected VersionParams(Parcel in) {
        this.requestUrl = in.readString();
        this.downloadAPKPath = in.readString();
        this.httpHeaders = (HttpHeaders)in.readSerializable();
        this.pauseRequestTime = in.readLong();
        int tmpRequestMethod = in.readInt();
        this.requestMethod = tmpRequestMethod == -1 ? null : HttpRequestMethod.values()[tmpRequestMethod];
        this.requestParams = (HttpParams)in.readSerializable();
        this.customDownloadActivityClass = (Class)in.readSerializable();
        this.isForceRedownload = in.readByte() != 0;
        this.isSilentDownload = in.readByte() != 0;
        this.service = (Class)in.readSerializable();
        this.onlyDownload = in.readByte() != 0;
        this.title = in.readString();
        this.downloadUrl = in.readString();
        this.updateMsg = in.readString();
        this.paramBundle = in.readBundle();
        this.isShowDownloadingDialog = in.readByte() != 0;
        this.isShowNotification = in.readByte() != 0;
        this.isShowDownloadFailDialog = in.readByte() != 0;
    }

    public static class Builder {
        VersionParams params = new VersionParams();

        public Builder() {
            this.params.downloadAPKPath = FileHelper.getDownloadApkCachePath();
            this.params.pauseRequestTime = 30000L;
            this.params.requestMethod = HttpRequestMethod.GET;
            this.params.customDownloadActivityClass = VersionDialogActivity.class;
            this.params.isForceRedownload = false;
            this.params.isSilentDownload = false;
            this.params.onlyDownload = false;
            this.params.isShowDownloadFailDialog = true;
            this.params.service = MyService.class;
            this.params.isShowNotification = true;
            this.params.isShowDownloadingDialog = true;
        }

        public Builder setParamBundle(Bundle paramBundle) {
            this.params.paramBundle = paramBundle;
            return this;
        }

        public Builder setDownloadUrl(String downloadUrl) {
            this.params.downloadUrl = downloadUrl;
            return this;
        }

        public Builder setTitle(String title) {
            this.params.title = title;
            return this;
        }

        public Builder setUpdateMsg(String updateMsg) {
            this.params.updateMsg = updateMsg;
            return this;
        }

        public Builder setOnlyDownload(boolean onlyDownload) {
            this.params.onlyDownload = onlyDownload;
            return this;
        }

        public Builder setRequestUrl(String requestUrl) {
            this.params.requestUrl = requestUrl;
            return this;
        }

        public Builder setDownloadAPKPath(String downloadAPKPath) {
            this.params.downloadAPKPath = downloadAPKPath;
            return this;
        }

        public Builder setHttpHeaders(HttpHeaders httpHeaders) {
            this.params.httpHeaders = httpHeaders;
            return this;
        }

        public Builder setPauseRequestTime(long pauseRequestTime) {
            this.params.pauseRequestTime = pauseRequestTime;
            return this;
        }

        public Builder setRequestMethod(HttpRequestMethod requestMethod) {
            this.params.requestMethod = requestMethod;
            return this;
        }

        public Builder setRequestParams(HttpParams requestParams) {
            this.params.requestParams = requestParams;
            return this;
        }

        public Builder setCustomDownloadActivityClass(Class customDownloadActivityClass) {
            this.params.customDownloadActivityClass = customDownloadActivityClass;
            return this;
        }

        public Builder setForceRedownload(boolean forceRedownload) {
            this.params.isForceRedownload = forceRedownload;
            return this;
        }

        public Builder setSilentDownload(boolean silentDownload) {
            this.params.isSilentDownload = silentDownload;
            return this;
        }

        public Builder setService(Class<? extends AVersionService> service) {
            this.params.service = service;
            return this;
        }

        public Builder setShowDownloadingDialog(boolean showDownloadingDialog2) {
            this.params.isShowDownloadingDialog = showDownloadingDialog2;
            return this;
        }

        public Builder setShowNotification(boolean showNotification2) {
            this.params.isShowNotification = showNotification2;
            return this;
        }

        public Builder setShowDownLoadFailDialog(boolean showDownLoadFailDialog) {
            this.params.isShowDownloadFailDialog = showDownLoadFailDialog;
            return this;
        }

        public VersionParams build() {
            return this.params;
        }
    }
}

