/*
 * Decompiled with CFR 0.152.
 */
package com.visa;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Vibrator;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.RelativeLayout;
import com.visa.AnimUtils;
import com.visa.ColorUtils;
import com.visa.R;
import com.visa.SensoryBrandingCompletionHandler;
import com.visa.Trapezoid;

public class SensoryBrandingView
extends RelativeLayout {
    private View mTopFlag;
    private View mTopFlagConstrained;
    private View mTopFlagSmall;
    private View mBottomFlag;
    private View mBottomFlagConstrained;
    private View mBottomFlagSmall;
    private View mHideMask;
    private AppCompatImageView mVisaLogo;
    private AppCompatImageView mIvConfirmationImg;
    private Trapezoid mLeftOverlay;
    private Trapezoid mRightOverlay;
    private RelativeLayout mContainer;
    private Context mContext;
    private AttributeSet mAttrs;
    private boolean isAnimating = false;
    private static final String ERR_MSG_ANIMATION_IN_PROGRESS = "Previous animation still in progress, cannot start a new animation.";
    private static final String ERR_MSG_INVALID_COLOR = "Invalid background color selected, contrast levels are below 3:1 against #FFFFFF and #1A1F71";
    private static final long FLAG_REVEAL_DELAY = 75L;
    private static final long FLAG_SCALE_DURATION = 85L;
    private static final long FLAG_SLIDE_DURATION = 451L;
    private static final long LOGO_REVEAL_DURATION = 206L;
    private static final long LOGO_EXIT_DELAY = 695L;
    private static final long LOGO_EXIT_DURATION = 245L;
    private static final long CHECK_MARK_ROTATION_DELAY = 808L;
    private static final long CHECK_MARK_ROTATION_DURATION = 395L;
    private static final long CHECK_MARK_ALPHA_DELAY = 714L;
    private static final long CHECK_MARK_ALPHA_DURATION = 489L;
    private static final long CHECK_MARK_EXIT_DELAY = 1636L;
    private static final long CHECK_MARK_EXIT_DURATION = 244L;
    private static int ANIMATION_LOGO_WIDTH;
    private static final double LOGO_REVEAL_TILT_ANGLE = 68.0;
    private static final int VIBRATE_PULSE_DURATION_1 = 300;
    private static final int VIBRATE_PULSE_DURATION_2 = 250;
    private int mBackdropColor = this.getResources().getColor(R.color.visa_blue);
    private boolean mConstrainedFlags = false;
    private boolean mIsSoundEnabled = true;
    private boolean mCheckMarkShown = true;

    public SensoryBrandingView(Context context) {
        this(context, null);
    }

    public SensoryBrandingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SensoryBrandingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mAttrs = attrs;
        this.setupUI();
    }

    public void setBackdropColor(int backdropColor) {
        this.mBackdropColor = backdropColor;
        this.setBackgroundColor(this.mBackdropColor);
        this.mHideMask.setBackgroundColor(this.mBackdropColor);
        this.mVisaLogo.setVisibility(4);
        this.mLeftOverlay.setColor(this.mBackdropColor);
        this.mRightOverlay.setColor(this.mBackdropColor);
        if (this.hasConstrainedFlags()) {
            this.mTopFlagConstrained.setVisibility(4);
            this.mBottomFlagConstrained.setVisibility(4);
            this.mTopFlagSmall.setVisibility(4);
            this.mBottomFlagSmall.setVisibility(4);
        }
        if (this.isAnimating) {
            this.clearAnimations();
        }
    }

    public int getBackdropColor() {
        return this.mBackdropColor;
    }

    public void setConstrainedFlags(boolean constrainedFlags) {
        this.mConstrainedFlags = constrainedFlags;
        if (this.isAnimating) {
            this.clearAnimations();
        }
    }

    public boolean hasConstrainedFlags() {
        return this.mConstrainedFlags;
    }

    public void setSoundEnabled(boolean soundEnabled) {
        this.mIsSoundEnabled = soundEnabled;
    }

    public boolean isSoundEnabled() {
        return this.mIsSoundEnabled;
    }

    public void setCheckMarkShown(boolean checkMarkShown) {
        this.mCheckMarkShown = checkMarkShown;
        if (this.isAnimating) {
            this.clearAnimations();
        }
    }

    public boolean isCheckMarkShown() {
        return this.mCheckMarkShown;
    }

    public ViewPropertyAnimator animate() {
        if (!this.isAnimating) {
            this.startSensoryBrandingAnimation(null);
        }
        return null;
    }

    public void animate(SensoryBrandingCompletionHandler handler) {
        if (!this.isAnimating) {
            this.startSensoryBrandingAnimation(handler);
        } else {
            handler.onComplete(new Error(ERR_MSG_ANIMATION_IN_PROGRESS));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredAnimationHeight;
        int desiredLogoWidth;
        int desiredAnimationWidth;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        double screenWidth = this.getScreenWidth();
        int minWidth = (int)(this.mConstrainedFlags ? screenWidth * 0.2 : screenWidth * 0.35);
        int maxWidth = (int)(screenWidth * 0.4);
        if (widthMode == 0) {
            desiredAnimationWidth = minWidth;
            desiredLogoWidth = minWidth;
        } else if (widthSize < minWidth) {
            desiredAnimationWidth = minWidth;
            desiredLogoWidth = minWidth;
        } else if (widthSize > maxWidth) {
            desiredAnimationWidth = widthSize;
            desiredLogoWidth = maxWidth;
        } else {
            desiredAnimationWidth = widthSize;
            desiredLogoWidth = widthSize;
        }
        int minHeight = (int)((double)desiredLogoWidth * 0.75);
        switch (heightMode) {
            case 0x40000000: {
                if (heightSize < minHeight) {
                    desiredAnimationHeight = minHeight;
                    break;
                }
                desiredAnimationHeight = heightSize;
                break;
            }
            case -2147483648: {
                if (heightSize < minHeight) {
                    desiredAnimationHeight = minHeight;
                    break;
                }
                desiredAnimationHeight = heightSize;
                break;
            }
            case 0: {
                desiredAnimationHeight = minHeight;
                break;
            }
            default: {
                desiredAnimationHeight = minHeight;
            }
        }
        ANIMATION_LOGO_WIDTH = desiredLogoWidth;
        this.setMeasuredDimension(desiredAnimationWidth, desiredAnimationHeight);
        int wspec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() / this.getChildCount()), (int)0x40000000);
        int hspec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            view.measure(wspec, hspec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            view.layout(l, t, r, b);
        }
        this.mContainer.setTop(0);
    }

    private void setupUI() {
        this.inflate();
        this.setViewProperties();
        this.setConfigurableProperties();
        this.setAnimationLayoutParams();
    }

    private void inflate() {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        if (inflater != null) {
            inflater.inflate(R.layout.sensory_branding, (ViewGroup)this, true);
        }
    }

    private void setViewProperties() {
        this.mTopFlagConstrained = this.findViewById(R.id.top_flag_constrained);
        this.mTopFlagSmall = this.findViewById(R.id.top_flag_constrained_small);
        this.mBottomFlagConstrained = this.findViewById(R.id.bottom_flag_constrained);
        this.mBottomFlagSmall = this.findViewById(R.id.bottom_flag_constrained_small);
        this.mTopFlag = this.findViewById(R.id.top_flag);
        this.mBottomFlag = this.findViewById(R.id.bottom_flag);
        this.mVisaLogo = (AppCompatImageView)this.findViewById(R.id.visa_logo);
        this.mRightOverlay = (Trapezoid)this.findViewById(R.id.right_overlay);
        this.mLeftOverlay = (Trapezoid)this.findViewById(R.id.left_overlay);
        this.mContainer = (RelativeLayout)this.findViewById(R.id.container);
        this.mHideMask = this.findViewById(R.id.hide_mask);
        this.mIvConfirmationImg = (AppCompatImageView)this.findViewById(R.id.checkmark);
        this.mRightOverlay.setAngle(68.0);
        this.mLeftOverlay.setAngle(68.0);
    }

    private void setConfigurableProperties() {
        if (this.mAttrs != null) {
            TypedArray attributesArray = this.mContext.getTheme().obtainStyledAttributes(this.mAttrs, R.styleable.SensoryBrandingView, 0, 0);
            try {
                this.mIsSoundEnabled = attributesArray.getBoolean(R.styleable.SensoryBrandingView_soundEnabled, false);
                this.mBackdropColor = attributesArray.getInteger(R.styleable.SensoryBrandingView_backdropColor, this.getBackdropColor());
                this.setBackgroundColor(this.mBackdropColor);
                this.mConstrainedFlags = attributesArray.getBoolean(R.styleable.SensoryBrandingView_constrainedFlags, false);
            }
            finally {
                attributesArray.recycle();
            }
        }
    }

    private void setAnimationLayoutParams() {
        int flagWidth = this.getFlagWidth();
        RelativeLayout.LayoutParams mTopFlagParams = (RelativeLayout.LayoutParams)this.mTopFlag.getLayoutParams();
        mTopFlagParams.width = flagWidth;
        mTopFlagParams.height = this.getFlagHeight();
        this.mTopFlag.setLayoutParams((ViewGroup.LayoutParams)mTopFlagParams);
        RelativeLayout.LayoutParams mBottomFlagParams = (RelativeLayout.LayoutParams)this.mBottomFlag.getLayoutParams();
        mBottomFlagParams.width = flagWidth;
        mBottomFlagParams.height = this.getFlagHeight();
        this.mBottomFlag.setLayoutParams((ViewGroup.LayoutParams)mBottomFlagParams);
        RelativeLayout.LayoutParams mTopSmallFlagParam = (RelativeLayout.LayoutParams)this.mTopFlagSmall.getLayoutParams();
        mTopSmallFlagParam.height = this.getFlagHeight();
        this.mTopFlagSmall.setLayoutParams((ViewGroup.LayoutParams)mTopSmallFlagParam);
        RelativeLayout.LayoutParams mBottomSmallFlagParam = (RelativeLayout.LayoutParams)this.mBottomFlagSmall.getLayoutParams();
        mBottomSmallFlagParam.height = this.getFlagHeight();
        this.mBottomFlagSmall.setLayoutParams((ViewGroup.LayoutParams)mBottomSmallFlagParam);
        RelativeLayout.LayoutParams mTopConstrainedFlagParam = (RelativeLayout.LayoutParams)this.mTopFlagConstrained.getLayoutParams();
        mTopConstrainedFlagParam.width = flagWidth;
        mTopConstrainedFlagParam.height = this.getFlagHeight();
        this.mTopFlagConstrained.setLayoutParams((ViewGroup.LayoutParams)mTopConstrainedFlagParam);
        RelativeLayout.LayoutParams mBottomConstrainedFlagParam = (RelativeLayout.LayoutParams)this.mBottomFlagConstrained.getLayoutParams();
        mBottomConstrainedFlagParam.width = flagWidth;
        mBottomConstrainedFlagParam.height = this.getFlagHeight();
        this.mBottomFlagConstrained.setLayoutParams((ViewGroup.LayoutParams)mBottomConstrainedFlagParam);
        RelativeLayout.LayoutParams mLogoParams = (RelativeLayout.LayoutParams)this.mVisaLogo.getLayoutParams();
        mLogoParams.width = this.getLogoWidth();
        mLogoParams.height = this.getLogoHeight();
        mLogoParams.topMargin = this.getFlagHeight();
        mLogoParams.bottomMargin = this.getFlagHeight();
        this.mVisaLogo.setLayoutParams((ViewGroup.LayoutParams)mLogoParams);
        RelativeLayout.LayoutParams mHideMaskParams = (RelativeLayout.LayoutParams)this.mHideMask.getLayoutParams();
        mHideMaskParams.width = this.getHideMaskParamsWidth();
        mHideMaskParams.height = this.getHideMaskParamsHeight();
        this.mHideMask.setLayoutParams((ViewGroup.LayoutParams)mHideMaskParams);
        RelativeLayout.LayoutParams mRightOverlayParams = (RelativeLayout.LayoutParams)this.mRightOverlay.getLayoutParams();
        mRightOverlayParams.width = this.getOverlayWidth();
        mRightOverlayParams.height = this.getOverlayHeight();
        this.mRightOverlay.setLayoutParams((ViewGroup.LayoutParams)mRightOverlayParams);
        RelativeLayout.LayoutParams mLeftOverlayParams = (RelativeLayout.LayoutParams)this.mLeftOverlay.getLayoutParams();
        mLeftOverlayParams.width = this.getOverlayWidth();
        mLeftOverlayParams.height = this.getOverlayHeight();
        this.mLeftOverlay.setLayoutParams((ViewGroup.LayoutParams)mLeftOverlayParams);
        this.mIvConfirmationImg.getLayoutParams().width = this.getConfirmationImgWidth();
        this.mIvConfirmationImg.getLayoutParams().height = this.getConfirmationImgHeight();
    }

    private void startSensoryBrandingAnimation(SensoryBrandingCompletionHandler handler) {
        if (!ColorUtils.isValidColorRatio(this.getContext(), this.mBackdropColor)) {
            if (handler != null) {
                handler.onComplete(new Error(ERR_MSG_INVALID_COLOR));
            }
            return;
        }
        this.isAnimating = true;
        this.applyColors();
        this.setAnimationLayoutParams();
        this.scaleContainer(handler);
        this.animateLogoReveal();
        this.animateFlags();
        this.animateLogoExit();
        if (this.isCheckMarkShown()) {
            this.animateCheckMark();
        }
        if (this.isSoundEnabled()) {
            this.playAudio();
        }
        if (this.isHapticFeedbackEnabled()) {
            this.vibrate();
        }
    }

    private void animateFlags() {
        this.setFlagsVisibility();
        this.animateTopFlag();
        this.animateBottomFlag();
    }

    private void setFlagsVisibility() {
        if (this.mConstrainedFlags) {
            this.mTopFlag.setVisibility(4);
            this.mBottomFlag.setVisibility(4);
            this.mTopFlagConstrained.setVisibility(0);
            this.mBottomFlagConstrained.setVisibility(0);
            this.mTopFlagSmall.setVisibility(0);
            this.mBottomFlagSmall.setVisibility(0);
        } else {
            this.mTopFlag.setVisibility(0);
            this.mBottomFlag.setVisibility(0);
            this.mTopFlagConstrained.setVisibility(4);
            this.mBottomFlagConstrained.setVisibility(4);
            this.mTopFlagSmall.setVisibility(4);
            this.mBottomFlagSmall.setVisibility(4);
        }
    }

    private GradientDrawable getGradientForTopConstrainedFlag() {
        GradientDrawable gd = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{this.getBackdropColor(), this.getResources().getColor(17170445)});
        gd.setCornerRadius(0.0f);
        return gd;
    }

    private GradientDrawable getGradientForBottomConstrainedFlag() {
        GradientDrawable gd = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, new int[]{this.getBackdropColor(), this.getResources().getColor(17170445)});
        gd.setCornerRadius(0.0f);
        return gd;
    }

    private void applyColors() {
        this.mRightOverlay.setColor(this.getBackdropColor());
        this.mLeftOverlay.setColor(this.getBackdropColor());
        if (this.hasConstrainedFlags()) {
            this.mTopFlagConstrained.setBackgroundColor(this.mBackdropColor);
            this.mBottomFlagConstrained.setBackgroundColor(this.mBackdropColor);
            this.mTopFlagSmall.setBackground((Drawable)this.getGradientForTopConstrainedFlag());
            this.mBottomFlagSmall.setBackground((Drawable)this.getGradientForBottomConstrainedFlag());
        }
        int visaBlue = this.getResources().getColor(R.color.visa_blue);
        int white = this.getResources().getColor(R.color.white);
        int darkBlue = this.getResources().getColor(R.color.dark_blue);
        if (this.mBackdropColor == visaBlue) {
            this.mBottomFlag.setBackground(this.getResources().getDrawable(R.drawable.gradient_orange));
            this.mTopFlag.setBackground(this.getResources().getDrawable(R.drawable.gradient_blue));
            this.mVisaLogo.setImageResource(R.drawable.visa_logo_white);
            this.mIvConfirmationImg.setImageResource(R.drawable.animated_check_mark_white);
        } else if (this.mBackdropColor == white) {
            int gold = this.getResources().getColor(R.color.visa_gold);
            this.mBottomFlag.setBackgroundColor(gold);
            this.mTopFlag.setBackgroundColor(darkBlue);
            this.mVisaLogo.setImageResource(R.drawable.visa_logo_dark_blue);
            this.mIvConfirmationImg.setImageResource(R.drawable.animated_check_mark_dark_blue);
        } else {
            int suggestedLogoColor = ColorUtils.contrastColorForBackgroundColor(this.getContext(), this.mBackdropColor);
            if (suggestedLogoColor == darkBlue) {
                this.mBottomFlag.setBackgroundColor(darkBlue);
                this.mTopFlag.setBackgroundColor(darkBlue);
                this.mVisaLogo.setImageResource(R.drawable.visa_logo_dark_blue);
                this.mIvConfirmationImg.setImageResource(R.drawable.animated_check_mark_dark_blue);
            } else {
                this.mBottomFlag.setBackgroundColor(white);
                this.mTopFlag.setBackgroundColor(white);
                this.mVisaLogo.setImageResource(R.drawable.visa_logo_white);
                this.mIvConfirmationImg.setImageResource(R.drawable.animated_check_mark_white);
            }
        }
    }

    private int getLogoWidth() {
        return ANIMATION_LOGO_WIDTH;
    }

    private int getLogoHeight() {
        return (int)((double)this.getLogoWidth() * 0.32);
    }

    private int getFlagWidth() {
        return this.getLogoWidth();
    }

    private int getFlagHeight() {
        return (int)((double)this.getFlagWidth() * 0.09);
    }

    private int getConfirmationImgWidth() {
        return this.getLogoHeight();
    }

    private int getConfirmationImgHeight() {
        return this.getConfirmationImgWidth();
    }

    private int getHideMaskParamsWidth() {
        int width = this.getLogoWidth();
        int height = this.getLogoHeight();
        return (int)Math.sqrt(width * width + height * height);
    }

    private int getHideMaskParamsHeight() {
        return this.getHideMaskParamsWidth();
    }

    private int getOverlayWidth() {
        return this.getLogoWidth() / 2;
    }

    private int getOverlayHeight() {
        return this.getLogoWidth();
    }

    private int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    private void clearAnimations() {
        this.mContainer.clearAnimation();
        for (int i = 0; i < this.mContainer.getChildCount(); ++i) {
            View view = this.mContainer.getChildAt(i);
            view.clearAnimation();
        }
    }

    private void playAudio() {
        final MediaPlayer mediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)R.raw.visa_sound);
        Handler mHandler = new Handler();
        mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                mediaPlayer.start();
            }
        }, 220L);
    }

    private void vibrate() {
        Vibrator vibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        if (vibrator != null) {
            long[] pattern = new long[]{0L, 300L, 395L, 250L};
            vibrator.vibrate(pattern, -1);
        }
    }

    private void scaleContainer(final SensoryBrandingCompletionHandler handler) {
        Animation scaleUp = AnimUtils.scaleAnimation(0.8764242f, 1.0f, 0.8764242f, 1.0f, 1, 0.5f, 1, 0.5f, 1880L);
        this.mContainer.startAnimation(scaleUp);
        scaleUp.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                SensoryBrandingView.this.isAnimating = false;
                if (handler != null) {
                    handler.onComplete(null);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void animateLogoReveal() {
        this.mVisaLogo.setVisibility(0);
        this.mLeftOverlay.setRotation(180.0f);
        Animation rightMaskTranslation = AnimUtils.translateAnimation(1, 0.0f, 1, 1.0f, 0, 0.0f, 0, 0.0f, 206L);
        this.mRightOverlay.startAnimation(rightMaskTranslation);
        Animation leftMaskTranslation = AnimUtils.translateAnimation(1, 0.0f, 1, -1.0f, 0, 0.0f, 0, 0.0f, 206L);
        this.mLeftOverlay.startAnimation(leftMaskTranslation);
    }

    private void animateTopFlag() {
        this.animateFlag(this.mTopFlag, true);
    }

    private void animateBottomFlag() {
        this.animateFlag(this.mBottomFlag, false);
    }

    private void animateFlag(final View flag, boolean isTopFlag) {
        int slideToXValue;
        boolean scalePivotXValue;
        if (isTopFlag) {
            scalePivotXValue = true;
            slideToXValue = -2;
        } else {
            scalePivotXValue = false;
            slideToXValue = 2;
        }
        AnimationSet animations = new AnimationSet(true);
        Animation scaleAnim = AnimUtils.scaleAnimation(0.0f, 1.0f, 1.0f, 1.0f, 1, (float)scalePivotXValue, 1, 1.0f, 85L);
        Animation slideAnim = AnimUtils.translateAnimation(1, 0.0f, 1, slideToXValue, 0, 0.0f, 0, 0.0f, 366L);
        slideAnim.setStartOffset(85L);
        animations.addAnimation(scaleAnim);
        animations.addAnimation(slideAnim);
        animations.setStartOffset(75L);
        animations.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                flag.setVisibility(4);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        flag.startAnimation((Animation)animations);
    }

    private void animateLogoExit() {
        this.mHideMask.setVisibility(0);
        this.mHideMask.setBackgroundColor(this.getBackdropColor());
        Animation rotate = AnimUtils.rotateAnimation(0.0f, 22.0f, 1, 0.5f, 1, 0.5f, 0L);
        Animation scale = AnimUtils.scaleAnimation(0.0f, 1.0f, 1.0f, 1.0f, 1, 0.5f, 1, 0.5f, 245L);
        AnimationSet animations = new AnimationSet(true);
        animations.addAnimation(scale);
        animations.addAnimation(rotate);
        animations.setStartOffset(695L);
        this.mHideMask.startAnimation((Animation)animations);
    }

    private void animateCheckMark() {
        Animation mCheckMarkAlphaAnim = AnimUtils.alphaAnimation(0.0f, 1.0f, 489L);
        mCheckMarkAlphaAnim.setStartOffset(714L);
        Animation mCheckMarkSpinAnim = AnimUtils.rotateAnimation(80.0f, 0.0f, 1, 0.5f, 1, 0.5f, 395L);
        mCheckMarkSpinAnim.setStartOffset(808L);
        AlphaAnimation fadeOut = new AlphaAnimation(1.0f, 0.0f);
        fadeOut.setStartOffset(1636L);
        fadeOut.setDuration(244L);
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation(mCheckMarkAlphaAnim);
        animationSet.addAnimation(mCheckMarkSpinAnim);
        animationSet.addAnimation((Animation)fadeOut);
        animationSet.setFillAfter(false);
        ((Animatable)this.mIvConfirmationImg.getDrawable()).start();
        this.mIvConfirmationImg.startAnimation((Animation)animationSet);
    }
}

