/*
 * Decompiled with CFR 0.152.
 */
package com.app.adprogressbarlib;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.app.adprogressbarlib.R;
import com.app.adprogressbarlib.Utils;

public class AdCircleProgress
extends View {
    private Paint finishedPaint;
    private Paint unfinishedPaint;
    private Paint innerCirclePaint;
    protected Paint textPaint;
    protected Paint innerBottomTextPaint;
    private RectF finishedOuterRect = new RectF();
    private RectF unfinishedOuterRect = new RectF();
    private int attributeResourceId = 0;
    private boolean showText;
    private float textSize;
    private int textColor;
    private int innerBottomTextColor;
    private float progress = 0.0f;
    private int max;
    private int finishedStrokeColor;
    private int gradientColorOne = 0;
    private int gradientColorTwo = 0;
    private int unfinishedStrokeColor = -1;
    private int startingDegree;
    private float finishedStrokeWidth;
    private float unfinishedStrokeWidth;
    private int innerBackgroundColor;
    private String prefixText = "";
    private String suffixText = "%";
    private String text = null;
    private float innerBottomTextSize;
    private String innerBottomText;
    private float innerBottomTextHeight;
    private final float default_stroke_width;
    private final int default_finished_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_unfinished_color = Color.rgb((int)204, (int)204, (int)204);
    private final int default_text_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_inner_bottom_text_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_inner_background_color = Color.parseColor((String)"#71130a0d");
    private final int default_max = 100;
    private final int default_startingDegree = -90;
    private final float default_text_size = Utils.sp2px(this.getResources(), 15.0f);
    private final float default_inner_bottom_text_size;
    private final int min_size = (int)Utils.dp2px(this.getResources(), 100.0f);
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_TEXT = "text";
    private static final String INSTANCE_INNER_BOTTOM_TEXT_SIZE = "inner_bottom_text_size";
    private static final String INSTANCE_INNER_BOTTOM_TEXT = "inner_bottom_text";
    private static final String INSTANCE_INNER_BOTTOM_TEXT_COLOR = "inner_bottom_text_color";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_GRADIENT_COLOR_ONE = "gradientColorOne";
    private static final String INSTANCE_GRADIENT_COLOR_TWO = "gradientColorTwo";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_SUFFIX = "suffix";
    private static final String INSTANCE_PREFIX = "prefix";
    private static final String INSTANCE_FINISHED_STROKE_WIDTH = "finished_stroke_width";
    private static final String INSTANCE_UNFINISHED_STROKE_WIDTH = "unfinished_stroke_width";
    private static final String INSTANCE_BACKGROUND_COLOR = "inner_background_color";
    private static final String INSTANCE_STARTING_DEGREE = "starting_degree";
    private static final String INSTANCE_INNER_DRAWABLE = "inner_drawable";

    public AdCircleProgress(Context context) {
        this(context, null);
    }

    public AdCircleProgress(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AdCircleProgress(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.default_stroke_width = Utils.dp2px(this.getResources(), 10.0f);
        this.default_inner_bottom_text_size = Utils.sp2px(this.getResources(), 18.0f);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AdCircleProgress, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    protected void initPainters() {
        if (this.showText) {
            this.textPaint = new TextPaint();
            this.textPaint.setColor(this.textColor);
            this.textPaint.setTextSize(this.textSize);
            this.textPaint.setAntiAlias(true);
            this.innerBottomTextPaint = new TextPaint();
            this.innerBottomTextPaint.setColor(this.innerBottomTextColor);
            this.innerBottomTextPaint.setTextSize(this.innerBottomTextSize);
            this.innerBottomTextPaint.setAntiAlias(true);
        }
        this.finishedPaint = new Paint();
        if (this.gradientColorOne != 0 && this.gradientColorTwo != 0) {
            this.finishedPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getHeight(), this.gradientColorOne, this.gradientColorTwo, Shader.TileMode.MIRROR));
        } else {
            this.finishedPaint.setColor(this.finishedStrokeColor);
        }
        this.finishedPaint.setStyle(Paint.Style.STROKE);
        this.finishedPaint.setAntiAlias(true);
        this.finishedPaint.setStrokeWidth(this.finishedStrokeWidth);
        this.unfinishedPaint = new Paint();
        this.unfinishedPaint.setColor(this.unfinishedStrokeColor);
        this.unfinishedPaint.setStyle(Paint.Style.STROKE);
        this.unfinishedPaint.setAntiAlias(true);
        this.unfinishedPaint.setStrokeWidth(this.unfinishedStrokeWidth);
        this.innerCirclePaint = new Paint();
        this.innerCirclePaint.setColor(this.innerBackgroundColor);
        this.innerCirclePaint.setAntiAlias(true);
    }

    protected void initByAttributes(TypedArray attributes) {
        this.gradientColorOne = attributes.getColor(R.styleable.AdCircleProgress_adpgb_gradient_color_one, 0);
        this.gradientColorTwo = attributes.getColor(R.styleable.AdCircleProgress_adpgb_gradient_color_two, 0);
        this.finishedStrokeColor = attributes.getColor(R.styleable.AdCircleProgress_adpgb_finished_color, this.default_finished_color);
        this.unfinishedStrokeColor = attributes.getColor(R.styleable.AdCircleProgress_adpgb_unfinished_color, this.default_unfinished_color);
        this.showText = attributes.getBoolean(R.styleable.AdCircleProgress_adpgb_show_text, true);
        this.attributeResourceId = attributes.getResourceId(R.styleable.AdCircleProgress_adpgb_inner_drawable, 0);
        this.setMax(attributes.getInt(R.styleable.AdCircleProgress_adpgb_max, 100));
        this.setProgress(attributes.getFloat(R.styleable.AdCircleProgress_adpgb_progress, 0.0f));
        this.finishedStrokeWidth = attributes.getDimension(R.styleable.AdCircleProgress_adpgb_finished_stroke_width, this.default_stroke_width);
        this.unfinishedStrokeWidth = attributes.getDimension(R.styleable.AdCircleProgress_adpgb_unfinished_stroke_width, this.default_stroke_width);
        if (this.showText) {
            if (attributes.getString(R.styleable.AdCircleProgress_adpgb_prefix_text) != null) {
                this.prefixText = attributes.getString(R.styleable.AdCircleProgress_adpgb_prefix_text);
            }
            if (attributes.getString(R.styleable.AdCircleProgress_adpgb_suffix_text) != null) {
                this.suffixText = attributes.getString(R.styleable.AdCircleProgress_adpgb_suffix_text);
            }
            if (attributes.getString(R.styleable.AdCircleProgress_adpgb_text) != null) {
                this.text = attributes.getString(R.styleable.AdCircleProgress_adpgb_text);
            }
            this.textColor = attributes.getColor(R.styleable.AdCircleProgress_adpgb_text_color, this.default_text_color);
            this.textSize = attributes.getDimension(R.styleable.AdCircleProgress_adpgb_text_size, this.default_text_size);
            this.innerBottomTextSize = attributes.getDimension(R.styleable.AdCircleProgress_adpgb_inner_bottom_text_size, this.default_inner_bottom_text_size);
            this.innerBottomTextColor = attributes.getColor(R.styleable.AdCircleProgress_adpgb_inner_bottom_text_color, this.default_inner_bottom_text_color);
            this.innerBottomText = attributes.getString(R.styleable.AdCircleProgress_adpgb_inner_bottom_text);
        }
        this.innerBottomTextSize = attributes.getDimension(R.styleable.AdCircleProgress_adpgb_inner_bottom_text_size, this.default_inner_bottom_text_size);
        this.innerBottomTextColor = attributes.getColor(R.styleable.AdCircleProgress_adpgb_inner_bottom_text_color, this.default_inner_bottom_text_color);
        this.innerBottomText = attributes.getString(R.styleable.AdCircleProgress_adpgb_inner_bottom_text);
        this.startingDegree = attributes.getInt(R.styleable.AdCircleProgress_adpgb_circle_starting_degree, -90);
        this.innerBackgroundColor = attributes.getColor(R.styleable.AdCircleProgress_adpgb_background_color, this.default_inner_background_color);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }

    public float getFinishedStrokeWidth() {
        return this.finishedStrokeWidth;
    }

    public void setFinishedStrokeWidth(float finishedStrokeWidth) {
        this.finishedStrokeWidth = finishedStrokeWidth;
        this.invalidate();
    }

    public float getUnfinishedStrokeWidth() {
        return this.unfinishedStrokeWidth;
    }

    public void setUnfinishedStrokeWidth(float unfinishedStrokeWidth) {
        this.unfinishedStrokeWidth = unfinishedStrokeWidth;
        this.invalidate();
    }

    private float getProgressAngle() {
        return this.getProgress() / (float)this.max * 360.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        if (this.progress > (float)this.getMax()) {
            this.progress %= (float)this.getMax();
        }
        this.invalidate();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public int getFinishedStrokeColor() {
        return this.finishedStrokeColor;
    }

    public int getGradientColorOne() {
        return this.gradientColorOne;
    }

    public void setGradientColorOne(int gradientColorOne) {
        this.gradientColorOne = gradientColorOne;
        this.invalidate();
    }

    public int getGradientColorTwo() {
        return this.gradientColorTwo;
    }

    public void setGradientColorTwo(int gradientColorTwo) {
        this.gradientColorTwo = gradientColorTwo;
        this.invalidate();
    }

    public void setFinishedStrokeColor(int finishedStrokeColor) {
        this.finishedStrokeColor = finishedStrokeColor;
        this.invalidate();
    }

    public int getUnfinishedStrokeColor() {
        return this.unfinishedStrokeColor;
    }

    public void setUnfinishedStrokeColor(int unfinishedStrokeColor) {
        this.unfinishedStrokeColor = unfinishedStrokeColor;
        this.invalidate();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public String getSuffixText() {
        return this.suffixText;
    }

    public void setSuffixText(String suffixText) {
        this.suffixText = suffixText;
        this.invalidate();
    }

    public String getPrefixText() {
        return this.prefixText;
    }

    public void setPrefixText(String prefixText) {
        this.prefixText = prefixText;
        this.invalidate();
    }

    public int getInnerBackgroundColor() {
        return this.innerBackgroundColor;
    }

    public void setInnerBackgroundColor(int innerBackgroundColor) {
        this.innerBackgroundColor = innerBackgroundColor;
        this.invalidate();
    }

    public String getInnerBottomText() {
        return this.innerBottomText;
    }

    public void setInnerBottomText(String innerBottomText) {
        this.innerBottomText = innerBottomText;
        this.invalidate();
    }

    public float getInnerBottomTextSize() {
        return this.innerBottomTextSize;
    }

    public void setInnerBottomTextSize(float innerBottomTextSize) {
        this.innerBottomTextSize = innerBottomTextSize;
        this.invalidate();
    }

    public int getInnerBottomTextColor() {
        return this.innerBottomTextColor;
    }

    public void setInnerBottomTextColor(int innerBottomTextColor) {
        this.innerBottomTextColor = innerBottomTextColor;
        this.invalidate();
    }

    public int getStartingDegree() {
        return this.startingDegree;
    }

    public void setStartingDegree(int startingDegree) {
        this.startingDegree = startingDegree;
        this.invalidate();
    }

    public int getAttributeResourceId() {
        return this.attributeResourceId;
    }

    public void setAttributeResourceId(int attributeResourceId) {
        this.attributeResourceId = attributeResourceId;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measure(widthMeasureSpec), this.measure(heightMeasureSpec));
        this.innerBottomTextHeight = this.getHeight() - this.getHeight() * 3 / 4;
    }

    private int measure(int measureSpec) {
        int result;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            result = size;
        } else {
            result = this.min_size;
            if (mode == Integer.MIN_VALUE) {
                result = Math.min(result, size);
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float delta = Math.max(this.finishedStrokeWidth, this.unfinishedStrokeWidth);
        this.finishedOuterRect.set(delta, delta, (float)this.getWidth() - delta, (float)this.getHeight() - delta);
        this.unfinishedOuterRect.set(delta, delta, (float)this.getWidth() - delta, (float)this.getHeight() - delta);
        float innerCircleRadius = ((float)this.getWidth() - Math.min(this.finishedStrokeWidth, this.unfinishedStrokeWidth) + Math.abs(this.finishedStrokeWidth - this.unfinishedStrokeWidth)) / 2.0f;
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, innerCircleRadius, this.innerCirclePaint);
        canvas.drawArc(this.finishedOuterRect, (float)this.getStartingDegree(), this.getProgressAngle(), false, this.finishedPaint);
        canvas.drawArc(this.unfinishedOuterRect, (float)this.getStartingDegree() + this.getProgressAngle(), 360.0f - this.getProgressAngle(), false, this.unfinishedPaint);
        if (this.showText) {
            String text;
            String string = text = this.text != null ? this.text : this.prefixText + this.progress + this.suffixText;
            if (!TextUtils.isEmpty((CharSequence)text)) {
                float textHeight = this.textPaint.descent() + this.textPaint.ascent() - 10.0f;
                canvas.drawText(text, ((float)this.getWidth() - this.textPaint.measureText(text)) / 2.0f, ((float)this.getWidth() - textHeight) / 2.0f, this.textPaint);
            }
            if (!TextUtils.isEmpty((CharSequence)this.getInnerBottomText())) {
                this.innerBottomTextPaint.setTextSize(this.innerBottomTextSize);
                float bottomTextBaseline = (float)this.getHeight() - this.innerBottomTextHeight - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f;
                canvas.drawText(this.getInnerBottomText(), ((float)this.getWidth() - this.innerBottomTextPaint.measureText(this.getInnerBottomText())) / 2.0f, bottomTextBaseline, this.innerBottomTextPaint);
            }
        }
        if (this.attributeResourceId != 0) {
            Bitmap bitmap = null;
            bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.attributeResourceId);
            if (bitmap == null) {
                bitmap = AdCircleProgress.getBitmapFromVectorDrawable(this.getContext(), this.attributeResourceId);
            }
            if (bitmap != null) {
                canvas.drawBitmap(bitmap, (float)(this.getWidth() - bitmap.getWidth()) / 2.0f, (float)(this.getHeight() - bitmap.getHeight()) / 2.0f, null);
            }
        }
    }

    public static Bitmap getBitmapFromVectorDrawable(Context context, int drawableId) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        if (Build.VERSION.SDK_INT < 21) {
            drawable = DrawableCompat.wrap((Drawable)drawable).mutate();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putFloat(INSTANCE_INNER_BOTTOM_TEXT_SIZE, this.getInnerBottomTextSize());
        bundle.putFloat(INSTANCE_INNER_BOTTOM_TEXT_COLOR, (float)this.getInnerBottomTextColor());
        bundle.putString(INSTANCE_INNER_BOTTOM_TEXT, this.getInnerBottomText());
        bundle.putInt(INSTANCE_INNER_BOTTOM_TEXT_COLOR, this.getInnerBottomTextColor());
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedStrokeColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedStrokeColor());
        bundle.putInt(INSTANCE_GRADIENT_COLOR_ONE, this.getGradientColorOne());
        bundle.putInt(INSTANCE_GRADIENT_COLOR_TWO, this.getGradientColorTwo());
        bundle.putInt(INSTANCE_MAX, this.getMax());
        bundle.putInt(INSTANCE_STARTING_DEGREE, this.getStartingDegree());
        bundle.putFloat(INSTANCE_PROGRESS, this.getProgress());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffixText());
        bundle.putString(INSTANCE_PREFIX, this.getPrefixText());
        bundle.putString(INSTANCE_TEXT, this.getText());
        bundle.putFloat(INSTANCE_FINISHED_STROKE_WIDTH, this.getFinishedStrokeWidth());
        bundle.putFloat(INSTANCE_UNFINISHED_STROKE_WIDTH, this.getUnfinishedStrokeWidth());
        bundle.putInt(INSTANCE_BACKGROUND_COLOR, this.getInnerBackgroundColor());
        bundle.putInt(INSTANCE_INNER_DRAWABLE, this.getAttributeResourceId());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.textColor = bundle.getInt(INSTANCE_TEXT_COLOR);
            this.textSize = bundle.getFloat(INSTANCE_TEXT_SIZE);
            this.innerBottomTextSize = bundle.getFloat(INSTANCE_INNER_BOTTOM_TEXT_SIZE);
            this.innerBottomText = bundle.getString(INSTANCE_INNER_BOTTOM_TEXT);
            this.innerBottomTextColor = bundle.getInt(INSTANCE_INNER_BOTTOM_TEXT_COLOR);
            this.finishedStrokeColor = bundle.getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedStrokeColor = bundle.getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.gradientColorOne = bundle.getInt(INSTANCE_GRADIENT_COLOR_ONE);
            this.gradientColorTwo = bundle.getInt(INSTANCE_GRADIENT_COLOR_TWO);
            this.finishedStrokeWidth = bundle.getFloat(INSTANCE_FINISHED_STROKE_WIDTH);
            this.unfinishedStrokeWidth = bundle.getFloat(INSTANCE_UNFINISHED_STROKE_WIDTH);
            this.innerBackgroundColor = bundle.getInt(INSTANCE_BACKGROUND_COLOR);
            this.attributeResourceId = bundle.getInt(INSTANCE_INNER_DRAWABLE);
            this.initPainters();
            this.setMax(bundle.getInt(INSTANCE_MAX));
            this.setStartingDegree(bundle.getInt(INSTANCE_STARTING_DEGREE));
            this.setProgress(bundle.getFloat(INSTANCE_PROGRESS));
            this.prefixText = bundle.getString(INSTANCE_PREFIX);
            this.suffixText = bundle.getString(INSTANCE_SUFFIX);
            this.text = bundle.getString(INSTANCE_TEXT);
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setAdProgress(int percent) {
        if (percent >= 0) {
            this.setProgress(percent);
        }
    }
}

