/*
 * Decompiled with CFR 0.152.
 */
package apijson.router;

import apijson.JSON;
import apijson.JSONResponse;
import apijson.Log;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONVerifier;
import apijson.orm.JSONRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.rmi.ServerException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class APIJSONRouterVerifier<T>
extends APIJSONVerifier<T> {
    public static final String TAG = "APIJSONRouterVerifier";
    public static Map<String, SortedMap<Integer, JSONObject>> DOCUMENT_MAP = new HashMap<String, SortedMap<Integer, JSONObject>>();

    public static JSONObject init() throws ServerException {
        return APIJSONRouterVerifier.init(false);
    }

    public static JSONObject init(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONRouterVerifier.init(shutdownWhenServerError, null);
    }

    public static <T> JSONObject init(APIJSONCreator<T> creator) throws ServerException {
        return APIJSONRouterVerifier.init(false, creator);
    }

    public static <T> JSONObject init(boolean shutdownWhenServerError, APIJSONCreator<T> creator) throws ServerException {
        JSONObject result = APIJSONVerifier.init((boolean)shutdownWhenServerError, creator);
        result.put(APIJSONConstant.DOCUMENT_, (Object)APIJSONRouterVerifier.initDocument(shutdownWhenServerError, creator));
        return result;
    }

    public static JSONObject initDocument() throws ServerException {
        return APIJSONRouterVerifier.initDocument(false);
    }

    public static JSONObject initDocument(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONRouterVerifier.initDocument(shutdownWhenServerError, null);
    }

    public static <T> JSONObject initDocument(APIJSONCreator<T> creator) throws ServerException {
        return APIJSONRouterVerifier.initDocument(false, creator);
    }

    public static <T> JSONObject initDocument(boolean shutdownWhenServerError, APIJSONCreator<T> creator) throws ServerException {
        return APIJSONRouterVerifier.initDocument(shutdownWhenServerError, creator, null);
    }

    public static <T> JSONObject initDocument(boolean shutdownWhenServerError, APIJSONCreator<T> creator, JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        JSONObject document;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        Object object = document = isAll ? new JSONRequest().puts("apijson{}", (Object)"length(apijson)>0").setOrder("version-,id+") : table;
        if (!Log.DEBUG) {
            document.put(APIJSONConstant.KEY_DEBUG, (Object)0);
        }
        JSONRequest requestItem = new JSONRequest();
        requestItem.put(APIJSONConstant.DOCUMENT_, (Object)document);
        JSONRequest request = new JSONRequest();
        request.putAll((Map)requestItem.toArray(0, 0, APIJSONConstant.DOCUMENT_));
        JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(false).parseResponse((JSONObject)request);
        if (!JSONResponse.isSuccess((JSONObject)response)) {
            Log.e((String)TAG, (String)("\n\n\n\n\n !!!! \u67e5\u8be2\u8bf7\u6c42\u6620\u5c04\u914d\u7f6e\u5f02\u5e38 !!!\n" + response.getString(JSONResponse.KEY_MSG) + "\n\n\n\n\n"));
            APIJSONRouterVerifier.onServerError("\u67e5\u8be2\u8bf7\u6c42\u6620\u5c04\u914d\u7f6e\u5f02\u5e38 !", shutdownWhenServerError);
        }
        int n = size = (list = response.getJSONArray(APIJSONConstant.DOCUMENT_ + "[]")) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"initDocument isAll && size <= 0\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u8bf7\u6c42\u6620\u5c04\u914d\u7f6e");
            return response;
        }
        Log.d((String)TAG, (String)("initDocument < for DOCUMENT_MAP.size() = " + DOCUMENT_MAP.size() + " <<<<<<<<<<<<<<<<<<<<<<<<"));
        LinkedHashMap<String, SortedMap<Integer, JSONObject>> newMap = new LinkedHashMap<String, SortedMap<Integer, JSONObject>>();
        for (int i = 0; i < size; ++i) {
            String cacheKey;
            TreeMap<Integer, JSONObject> versionedMap;
            String url;
            int index;
            JSONObject item = list.getJSONObject(i);
            if (item == null) continue;
            String version = item.getString("version");
            if (StringUtil.isEmpty((String)version, (boolean)true)) {
                APIJSONRouterVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cDocument \u8868\u4e2d\u7684 id=" + item.getString("id") + ", name=" + item.getString("name") + " \u5bf9\u5e94 version \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            int n2 = index = (url = item.getString("url")) == null ? -1 : url.indexOf("/");
            if (index != 0) {
                APIJSONRouterVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cDocument \u8868\u4e2d\u7684 id=" + item.getString("id") + ", name=" + item.getString("name") + ", url=" + url + " \u5bf9\u5e94 url \u503c\u9519\u8bef\uff0c\u5fc5\u987b\u4ee5 / \u5f00\u5934\uff01", shutdownWhenServerError);
            }
            String requestStr = item.getString("request");
            String apijson = item.getString("apijson");
            if (StringUtil.isEmpty((String)apijson)) {
                if (StringUtil.isBranchUrl((String)url)) continue;
                APIJSONRouterVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cDocument \u8868\u4e2d\u7684 id=" + item.getString("id") + ", name=" + item.getString("name") + ", url=" + url + " \u5bf9\u5e94 url \u503c\u9519\u8bef\uff01\u53ea\u5141\u8bb8\u5408\u6cd5\u7684 URL \u683c\u5f0f\uff01", shutdownWhenServerError);
                continue;
            }
            if (StringUtil.isNotEmpty((String)requestStr)) {
                try {
                    JSON.parseObject((String)requestStr);
                }
                catch (Exception e) {
                    APIJSONRouterVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cDocument \u8868\u4e2d\u7684 id=" + item.getString("id") + ", name=" + item.getString("name") + ", url=" + url + " \u5bf9\u5e94 request \u503c " + requestStr + " \u9519\u8bef\uff01\u53ea\u5141\u8bb8\u5408\u6cd5\u7684 JSONObject \u683c\u5f0f\uff01" + e.getMessage(), shutdownWhenServerError);
                }
            }
            try {
                JSON.parseObject((String)apijson);
            }
            catch (Exception e) {
                APIJSONRouterVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cDocument \u8868\u4e2d\u7684 id=" + item.getString("id") + ", name=" + item.getString("name") + ", url=" + url + " \u5bf9\u5e94 apijson \u503c " + apijson + " \u9519\u8bef\uff01\u53ea\u5141\u8bb8\u5408\u6cd5\u7684 JSONObject \u683c\u5f0f\uff01" + e.getMessage(), shutdownWhenServerError);
            }
            index = url.lastIndexOf("/");
            String method = index < 0 ? null : url.substring(0, index);
            String tag = index < 0 ? null : url.substring(index + 1);
            index = method == null ? -1 : method.lastIndexOf("/");
            String string = method = index < 0 ? method : method.substring(index + 1);
            if (!APIJSONConstant.METHODS.contains(method)) {
                APIJSONRouterVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cDocument \u8868\u4e2d\u7684 id=" + item.getString("id") + ", name=" + item.getString("name") + ", url=" + url + " \u5bf9\u5e94\u8def\u5f84 /{method}/{tag} \u4e2d method \u503c " + method + " \u9519\u8bef\uff01apijson \u5b57\u6bb5\u4e0d\u4e3a\u7a7a\u65f6\u53ea\u5141\u8bb8 " + APIJSONConstant.METHODS + " \u4e2d\u7684\u4e00\u4e2a\uff01", shutdownWhenServerError);
            }
            if (!StringUtil.isName((String)tag)) {
                APIJSONRouterVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cDocument \u8868\u4e2d\u7684 id=" + item.getString("id") + ", name=" + item.getString("name") + ", url=" + url + " \u5bf9\u5e94\u8def\u5f84 /{method}/{tag} \u4e2d tag \u503c " + tag + " \u9519\u8bef\uff01apijson \u5b57\u6bb5\u4e0d\u4e3a\u7a7a\u65f6\u53ea\u5141\u8bb8\u53d8\u91cf\u547d\u540d\u683c\u5f0f\uff01", shutdownWhenServerError);
            }
            if ((versionedMap = (TreeMap<Integer, JSONObject>)newMap.get(cacheKey = APIJSONRouterVerifier.getCacheKeyForRequest((String)method, (String)tag))) == null) {
                versionedMap = new TreeMap<Integer, JSONObject>(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o2 == null ? -1 : o2.compareTo(o1);
                    }
                });
            }
            versionedMap.put(Integer.valueOf(version), item);
            newMap.put(cacheKey, versionedMap);
        }
        if (isAll) {
            DOCUMENT_MAP = newMap;
        } else {
            DOCUMENT_MAP.putAll(newMap);
        }
        Log.d((String)TAG, (String)("initDocument  for /> DOCUMENT_MAP.size() = " + DOCUMENT_MAP.size() + " >>>>>>>>>>>>>>>>>>>>>>>"));
        return response;
    }

    protected static void onServerError(String msg, boolean shutdown) throws ServerException {
        Log.e((String)TAG, (String)("\n\u63a5\u53e3\u6620\u5c04\u914d\u7f6e\u6d4b\u8bd5\u672a\u901a\u8fc7\uff01\n\u8bf7\u4fee\u6539 Document \u8868\u91cc\u7684\u8bb0\u5f55\uff01\n\u4fdd\u8bc1\u524d\u7aef\u770b\u5230\u7684\u63a5\u53e3\u6620\u5c04\u914d\u7f6e\u6587\u6863\u662f\u6b63\u786e\u7684\u5e76\u4e14\u80fd\u6b63\u5e38\u4f7f\u7528\uff01\uff01\uff01\n\n\u539f\u56e0\uff1a\n" + msg));
        if (!shutdown) {
            throw new ServerException(msg);
        }
        System.exit(1);
    }
}

