/*
 * Decompiled with CFR 0.152.
 */
package com.chaitin.xray.form;

import com.chaitin.xray.form.AdvanceConfigForm;
import com.chaitin.xray.form.AllPoCForm;
import com.chaitin.xray.form.EncodeUtilForm;
import com.chaitin.xray.form.HttpUtilForm;
import com.chaitin.xray.form.ListenUtilForm;
import com.chaitin.xray.form.LookupConfigForm;
import com.chaitin.xray.model.Const;
import com.chaitin.xray.model.Poc;
import com.chaitin.xray.model.XrayCmd;
import com.chaitin.xray.utils.ExecUtil;
import com.chaitin.xray.utils.IOUtil;
import com.chaitin.xray.utils.OSUtil;
import com.chaitin.xray.utils.StringUtil;
import com.chaitin.xray.utils.XrayUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class MainForm {
    private static final Logger logger = LogManager.getLogger(MainForm.class);
    public static MainForm instance;
    private XrayCmd xrayCmd;
    public static String configStr;
    public static String configTemplate;
    public static String configPath;
    public static Map<String, Object> configObj;
    private static ArrayList<JCheckBox> checkBoxList;
    private static boolean pluginAll;
    private static String outputFilePath;
    private JButton choseDirButton;
    private JPanel SuperXray;
    private JPanel showPathPanel;
    private JPanel pathButtonPanel;
    private JLabel xrayPathLabel;
    private JTextField xrayPathTextField;
    private JLabel noteLabel;
    private JPanel configPanel;
    private JPanel bottomPanel;
    private JLabel authorLabel;
    private JPanel leftConfigPanel;
    private JPanel rightConfigPanel;
    private JPanel catConfigPanel;
    private JLabel catConfigLabel;
    private JLabel choseXrayLabel;
    private JPanel loadXrayPanel;
    private JCheckBox bruteForceCheckBox;
    private JCheckBox baselineCheckBox;
    private JCheckBox cmdInjectionCheckBox;
    private JCheckBox crlfInjectionCheckBox;
    private JCheckBox dirscanCheckBox;
    private JCheckBox fastjsonCheckBox;
    private JCheckBox jsonpCheckBox;
    private JCheckBox pathTraversalCheckBox;
    private JCheckBox phantasmCheckBox;
    private JCheckBox redirectCheckBox;
    private JCheckBox shiroCheckBox;
    private JCheckBox sqldetCheckBox;
    private JCheckBox ssrfCheckBox;
    private JCheckBox strutsCheckBox;
    private JCheckBox thinkphpCheckBox;
    private JCheckBox uploadCheckBox;
    private JCheckBox xxeCheckBox;
    private JCheckBox xssCheckBox;
    private JButton enableAllButton;
    private JButton advanceButton;
    private JButton reverseConfigButton;
    private JButton pocButton;
    private JButton activeScanButton;
    private JButton mitmScanButton;
    private JButton outputConfigButton;
    private JButton proxyConfigButton;
    private JPanel outputConfigPanel;
    private JScrollPane outputPanel;
    private JTextArea outputTextArea;
    private JPanel scanOutConfigPanel;
    private JRadioButton htmlRadioButton;
    private JRadioButton cliRadioButton;
    private JRadioButton jsonRadioButton;
    private JButton urlFileButton;
    private JTextField urlFileField;
    private JTextField rawFileField;
    private JButton rawFileButton;
    private JTextField urlField;
    private JButton urlButton;
    private JButton lookupConfigButton;
    private JButton lookupCmdButton;
    private JButton confirmPluginButton;
    private JPanel pocPanel;
    private JButton allPoCButton;
    private JTextField usePoCText;
    private JPanel scanTargetPanel;
    private JPanel proxyConfigPanel;
    private JPanel reverseConfigPanel;
    private JPanel startScanPanel;
    private JPanel otherPanel;
    private JPanel midConfigPanel;
    private JLabel pocNumLabel;
    private JTextField portText;
    private JLabel portLabel;
    private JPanel mitmPanel;
    private JTextField proxyText;
    private JLabel proxyLabel;
    private JPanel proxyPanel;
    private JTextField dnsText;
    private JTextField httpReverseText;
    private JPanel reverseUrlPanel;
    private JLabel httpReverseLabel;
    private JLabel dnsReverseLabel;
    private JButton stopButton;
    private JButton resetConfigButton;
    private JButton openResultButton;
    private JLabel stopLabel;
    private JLabel openResultLabel;
    private JLabel resetConfigLabel;
    private JPanel resetPanel;
    private JPanel openResultPanel;
    private JPanel stopPanel;
    private JPanel otherButton;
    private JPanel utilPanel;
    private JButton httpUtilButton;
    private JButton encodeUtilButton;
    private JButton listenUtilButton;
    private JButton updatePocButton;
    private volatile boolean stop = false;
    private static boolean mitmRunning;

    public void init() {
        logger.info("init main form");
        checkBoxList = new ArrayList();
        this.xrayCmd = new XrayCmd();
        this.reloadConfig(true);
        logger.info("init look up config button");
        this.lookupConfigButton.addActionListener(e -> {
            JFrame frame = new JFrame("\u67e5\u770b\u914d\u7f6e\u6587\u4ef6");
            frame.setContentPane(new LookupConfigForm().lookupConfigPanel);
            frame.pack();
            frame.setVisible(true);
        });
        logger.info("init look up cmd button");
        this.lookupCmdButton.addActionListener(e -> JOptionPane.showMessageDialog(null, this.xrayCmd.buildCmd()));
    }

    public void reloadConfig(boolean init) {
        if (init) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("config.yaml");
            configTemplate = configStr = IOUtil.readStringFromIs(is);
        }
        Yaml yaml = new Yaml();
        configObj = (Map)yaml.load(configStr);
        try {
            if (StringUtil.notEmpty(configPath)) {
                Files.write(Paths.get(configPath, new String[0]), configStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (Exception ex) {
            logger.error(ex);
        }
        for (Map.Entry<String, Object> entry : configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            for (Map.Entry plugin : plugins.entrySet()) {
                Map items;
                if (((String)plugin.getKey()).equals("baseline")) {
                    items = (Map)plugin.getValue();
                    this.baselineCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("brute-force")) {
                    items = (Map)plugin.getValue();
                    this.bruteForceCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("cmd-injection")) {
                    items = (Map)plugin.getValue();
                    this.cmdInjectionCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("crlf-injection")) {
                    items = (Map)plugin.getValue();
                    this.crlfInjectionCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("dirscan")) {
                    items = (Map)plugin.getValue();
                    this.dirscanCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("fastjson")) {
                    items = (Map)plugin.getValue();
                    this.fastjsonCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("jsonp")) {
                    items = (Map)plugin.getValue();
                    this.jsonpCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("path-traversal")) {
                    items = (Map)plugin.getValue();
                    this.pathTraversalCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("phantasm")) {
                    items = (Map)plugin.getValue();
                    this.phantasmCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("redirect")) {
                    items = (Map)plugin.getValue();
                    this.redirectCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("shiro")) {
                    items = (Map)plugin.getValue();
                    this.shiroCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("sqldet")) {
                    items = (Map)plugin.getValue();
                    this.sqldetCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("ssrf")) {
                    items = (Map)plugin.getValue();
                    this.ssrfCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("struts")) {
                    items = (Map)plugin.getValue();
                    this.strutsCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("thinkphp")) {
                    items = (Map)plugin.getValue();
                    this.thinkphpCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("upload")) {
                    items = (Map)plugin.getValue();
                    this.uploadCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (((String)plugin.getKey()).equals("xss")) {
                    items = (Map)plugin.getValue();
                    this.xssCheckBox.setSelected((Boolean)items.get("enabled"));
                }
                if (!((String)plugin.getKey()).equals("xxe")) continue;
                items = (Map)plugin.getValue();
                this.xxeCheckBox.setSelected((Boolean)items.get("enabled"));
            }
        }
    }

    private void execAndFresh(String[] finalCmd) {
        this.outputTextArea.setText(null);
        Thread thread = new Thread(() -> {
            try {
                String thisLine;
                BufferedReader isReader;
                Process process = ExecUtil.exec(finalCmd);
                if (process == null) {
                    return;
                }
                InputStream inputStream = process.getInputStream();
                if (inputStream == null) {
                    return;
                }
                if (OSUtil.isWindows()) {
                    InputStreamReader isr = new InputStreamReader(inputStream, "GBK");
                    isReader = new BufferedReader(isr);
                } else {
                    isReader = new BufferedReader(new InputStreamReader(inputStream));
                }
                new Thread(() -> {
                    while (!this.stop) {
                    }
                    logger.info(String.format("stop pid: %d", process.pid()));
                    try {
                        if (!OSUtil.isWindows()) {
                            new ProcessBuilder("kill", "-9", Long.toString(process.pid())).start();
                        } else {
                            new ProcessBuilder("cmd.exe", "/c", String.format("taskkill /f /pid %d", process.pid()), Long.toString(process.pid())).start();
                        }
                        return;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).start();
                while (!this.stop && (thisLine = isReader.readLine()) != null) {
                    this.outputTextArea.append(thisLine);
                    this.outputTextArea.append("\n");
                    this.outputTextArea.setCaretPosition(this.outputTextArea.getText().length());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        thread.start();
    }

    public void initLoadXray() {
        logger.info("init load xray module");
        this.choseDirButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            int option = fileChooser.showOpenDialog(new JFrame());
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                String absPath = file.getAbsolutePath();
                logger.info(String.format("user chose file: %s", absPath));
                String targetDir = Paths.get(absPath, new String[0]).toFile().getParent() + File.separator;
                XrayUtil.rmAllConfig(targetDir);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> XrayUtil.rmAllConfig(targetDir)));
                this.xrayPathTextField.setText(absPath);
                if (!OSUtil.isWindows()) {
                    ExecUtil.chmod(absPath);
                }
                String[] cmd = new String[]{absPath};
                Thread t = new Thread(() -> ExecUtil.execCmdNoRet(cmd));
                t.start();
                if (OSUtil.isMacOS()) {
                    JOptionPane.showMessageDialog(null, "Mac OS \u8bf7\u8bbe\u7f6e \u7cfb\u7edf\u504f\u597d\u8bbe\u7f6e->\u5b89\u5168\u6027\u4e0e\u9690\u79c1->\u901a\u7528->\u4ecd\u8981\u6253\u5f00");
                }
                JOptionPane.showMessageDialog(null, "\u8bf7\u7b49\u5f85\u521d\u59cb\u5316");
                try {
                    Thread.sleep(1000L);
                    t.interrupt();
                }
                catch (Exception ex) {
                    logger.error(ex);
                }
                XrayUtil.cpAllConfig(targetDir);
                try {
                    Path configPathPath = Paths.get(targetDir + Const.ConfigYaml, new String[0]);
                    configPath = configPathPath.toFile().getAbsolutePath();
                    Files.write(configPathPath, configStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (Exception ex) {
                    logger.error(ex);
                }
                this.xrayCmd.setXray(absPath);
                this.stop = false;
                this.execAndFresh(cmd);
            } else {
                this.xrayPathTextField.setText("\u4f60\u53d6\u6d88\u4e86\u9009\u62e9");
            }
        });
    }

    public void initPluginCheckBox() {
        logger.info("init all plugins");
        pluginAll = true;
        checkBoxList.add(this.bruteForceCheckBox);
        checkBoxList.add(this.baselineCheckBox);
        checkBoxList.add(this.cmdInjectionCheckBox);
        checkBoxList.add(this.jsonpCheckBox);
        checkBoxList.add(this.phantasmCheckBox);
        checkBoxList.add(this.shiroCheckBox);
        checkBoxList.add(this.ssrfCheckBox);
        checkBoxList.add(this.thinkphpCheckBox);
        checkBoxList.add(this.xssCheckBox);
        checkBoxList.add(this.crlfInjectionCheckBox);
        checkBoxList.add(this.dirscanCheckBox);
        checkBoxList.add(this.fastjsonCheckBox);
        checkBoxList.add(this.pathTraversalCheckBox);
        checkBoxList.add(this.redirectCheckBox);
        checkBoxList.add(this.sqldetCheckBox);
        checkBoxList.add(this.strutsCheckBox);
        checkBoxList.add(this.uploadCheckBox);
        checkBoxList.add(this.xxeCheckBox);
        this.enableAllButton.addActionListener(e -> {
            if (!pluginAll) {
                for (JCheckBox checkBox : checkBoxList) {
                    checkBox.setSelected(true);
                }
                pluginAll = true;
            } else {
                for (JCheckBox checkBox : checkBoxList) {
                    checkBox.setSelected(false);
                }
                pluginAll = false;
            }
        });
    }

    public void initPluginSave() {
        this.confirmPluginButton.addActionListener(e -> {
            for (Map.Entry<String, Object> entry : configObj.entrySet()) {
                if (!entry.getKey().equals("plugins")) continue;
                Map plugins = (Map)entry.getValue();
                for (Map.Entry plugin : plugins.entrySet()) {
                    Map items;
                    if (((String)plugin.getKey()).equals("baseline")) {
                        items = (Map)plugin.getValue();
                        if (this.baselineCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("brute-force")) {
                        items = (Map)plugin.getValue();
                        if (this.bruteForceCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("cmd-injection")) {
                        items = (Map)plugin.getValue();
                        if (this.cmdInjectionCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("crlf-injection")) {
                        items = (Map)plugin.getValue();
                        if (this.crlfInjectionCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("dirscan")) {
                        items = (Map)plugin.getValue();
                        if (this.dirscanCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("fastjson")) {
                        items = (Map)plugin.getValue();
                        if (this.fastjsonCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("jsonp")) {
                        items = (Map)plugin.getValue();
                        if (this.jsonpCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("path-traversal")) {
                        items = (Map)plugin.getValue();
                        if (this.pathTraversalCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("phantasm")) {
                        items = (Map)plugin.getValue();
                        if (this.phantasmCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("redirect")) {
                        items = (Map)plugin.getValue();
                        if (this.redirectCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("shiro")) {
                        items = (Map)plugin.getValue();
                        if (this.shiroCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("sqldet")) {
                        items = (Map)plugin.getValue();
                        if (this.sqldetCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("ssrf")) {
                        items = (Map)plugin.getValue();
                        if (this.ssrfCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("struts")) {
                        items = (Map)plugin.getValue();
                        if (this.strutsCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("thinkphp")) {
                        items = (Map)plugin.getValue();
                        if (this.thinkphpCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("upload")) {
                        items = (Map)plugin.getValue();
                        if (this.uploadCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (((String)plugin.getKey()).equals("xss")) {
                        items = (Map)plugin.getValue();
                        if (this.xssCheckBox.isSelected()) {
                            items.put("enabled", true);
                        } else {
                            items.put("enabled", false);
                        }
                    }
                    if (!((String)plugin.getKey()).equals("xxe")) continue;
                    items = (Map)plugin.getValue();
                    if (this.xxeCheckBox.isSelected()) {
                        items.put("enabled", true);
                        continue;
                    }
                    items.put("enabled", false);
                }
            }
            this.refreshConfig();
            this.xrayCmd.setPoc(null);
            JOptionPane.showMessageDialog(null, "\u8bbe\u7f6e\u5b8c\u6210");
        });
    }

    public void refreshConfig() {
        Yaml yaml = new Yaml();
        StringWriter writer = new StringWriter();
        yaml.dump(configObj, writer);
        configStr = writer.toString();
        try {
            Files.write(Paths.get(configPath, new String[0]), configStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex);
        }
    }

    public void initAdvanceConfig() {
        logger.info("init advance config button");
        this.advanceButton.addActionListener(e -> {
            JFrame frame = new JFrame("\u9ad8\u7ea7\u914d\u7f6e");
            frame.setContentPane(new AdvanceConfigForm().advanceConfigPanel);
            frame.setResizable(false);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public void initOutputConfig() {
        logger.info("init output config module");
        this.htmlRadioButton.setSelected(true);
        this.jsonRadioButton.setSelected(false);
        this.cliRadioButton.setSelected(false);
        this.outputConfigButton.addActionListener(e -> {
            this.refreshOutput();
            JOptionPane.showMessageDialog(null, "\u8bbe\u7f6e\u8f93\u51fa\u6210\u529f");
        });
    }

    public void refreshOutput() {
        String uuid = UUID.randomUUID().toString();
        if (this.htmlRadioButton.isSelected()) {
            outputFilePath = Paths.get(String.format("./xray-%s.html", uuid), new String[0]).toFile().getAbsolutePath();
            this.xrayCmd.setOutputPrefix("--html-output");
            this.xrayCmd.setOutput(outputFilePath);
        }
        if (this.jsonRadioButton.isSelected()) {
            outputFilePath = Paths.get(String.format("./xray-%s.txt", uuid), new String[0]).toFile().getAbsolutePath();
            this.xrayCmd.setOutputPrefix("--json-output");
            this.xrayCmd.setOutput(outputFilePath);
        }
        if (this.cliRadioButton.isSelected()) {
            this.xrayCmd.setOutput(null);
        }
    }

    public void initTargetUrlConfig() {
        this.urlButton.addActionListener(e -> {
            this.urlFileField.setText(null);
            this.rawFileField.setText(null);
            String url = this.urlField.getText();
            logger.info(String.format("target url: %s", url));
            this.xrayCmd.setInputPrefix("--url");
            this.xrayCmd.setInput(url);
            JOptionPane.showMessageDialog(null, "\u8bbe\u7f6eURL\u6210\u529f");
        });
    }

    public void initUrlFileConfig() {
        logger.info("init url file module");
        this.urlFileButton.addActionListener(e -> {
            this.urlField.setText(null);
            this.rawFileField.setText(null);
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            int option = fileChooser.showOpenDialog(new JFrame());
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                String absPath = file.getAbsolutePath();
                this.urlFileField.setText(absPath);
                this.xrayCmd.setInputPrefix("--url-file");
                this.xrayCmd.setInput(String.format("%s", absPath));
            } else {
                this.rawFileField.setText("\u4f60\u53d6\u6d88\u4e86\u9009\u62e9");
            }
        });
    }

    public void initRawScanConfig() {
        logger.info("init raw scan module");
        this.rawFileButton.addActionListener(e -> {
            this.urlField.setText(null);
            this.urlFileField.setText(null);
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            int option = fileChooser.showOpenDialog(new JFrame());
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                String absPath = file.getAbsolutePath();
                this.rawFileField.setText(absPath);
                this.xrayCmd.setInputPrefix("--raw-request");
                this.xrayCmd.setInput(String.format("%s", absPath));
            } else {
                this.rawFileField.setText("\u4f60\u53d6\u6d88\u4e86\u9009\u62e9");
            }
        });
    }

    public void initActiveScan() {
        logger.info("init active scan module");
        this.activeScanButton.addActionListener(e -> {
            try {
                this.refreshOutput();
                this.xrayCmd.setModule("webscan");
                this.xrayCmd.setConfig(String.format("%s", configPath));
                this.xrayCmd.setOthers(null);
                String[] finalCmd = this.xrayCmd.buildCmd();
                this.outputTextArea.setText(null);
                this.stop = false;
                this.execAndFresh(finalCmd);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public void initAllPoC() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("poc.list");
        String allPocStr = IOUtil.readStringFromIs(is);
        assert (allPocStr != null);
        String[] temp = allPocStr.split("\n");
        Poc.addPoc(temp);
        this.pocNumLabel.setText(String.format("\u5f53\u524d\u5171\u6709: %s \u4e2aPoC", Poc.getPocList().size()));
        this.allPoCButton.addActionListener(e -> {
            JFrame frame = new JFrame("\u67e5\u770b\u6240\u6709PoC");
            frame.setContentPane(new AllPoCForm().searchPoC);
            frame.setResizable(false);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public void initTargetPoC() {
        this.updatePocButton.addActionListener(e -> {
            String[] temp;
            String[] cmd = new String[]{this.xrayCmd.getXray(), "ws", "--list"};
            InputStream is = Objects.requireNonNull(ExecUtil.exec(cmd)).getInputStream();
            this.stop = false;
            this.execAndFresh(cmd);
            ArrayList<String> poc = new ArrayList<String>();
            String data = IOUtil.readStringFromIs(is);
            assert (data != null);
            for (String s : temp = data.split("\n")) {
                if ((s = s.trim()).endsWith("\r")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.contains(":") || s.contains("test") || !s.contains("poc")) continue;
                s = s.substring(2);
                poc.add(s.trim());
            }
            Poc.clear();
            Poc.addAll(poc);
            this.pocNumLabel.setText(String.format("\u5f53\u524d\u5171\u6709: %s \u4e2aPoC", Poc.getPocList().size()));
        });
        this.pocButton.addActionListener(e -> {
            String poc = this.usePoCText.getText();
            logger.info(poc);
            if (!Poc.getPocList().contains(poc.trim())) {
                JOptionPane.showMessageDialog(null, "PoC\u4e0d\u5b58\u5728");
                return;
            }
            this.xrayCmd.setPoc(String.format("%s", poc));
            for (JCheckBox jCheckBox : checkBoxList) {
                jCheckBox.setSelected(false);
            }
            this.phantasmCheckBox.setSelected(true);
            for (Map.Entry entry : configObj.entrySet()) {
                if (!((String)entry.getKey()).equals("plugins")) continue;
                Map plugins = (Map)entry.getValue();
                for (Map.Entry plugin : plugins.entrySet()) {
                    Map items = (Map)plugin.getValue();
                    if (((String)plugin.getKey()).equals("phantasm")) {
                        items.put("enabled", true);
                        continue;
                    }
                    items.put("enabled", false);
                }
            }
            this.refreshConfig();
            JOptionPane.showMessageDialog(null, "\u8bbe\u7f6ePoC\u6210\u529f");
        });
    }

    public void initMitmScan() {
        this.mitmScanButton.addActionListener(e -> {
            if (!mitmRunning) {
                String port = this.portText.getText();
                this.xrayCmd.setModule("webscan");
                this.xrayCmd.setConfig(String.format("%s", configPath));
                this.xrayCmd.setInput(null);
                this.xrayCmd.setOthersPrefix("--listen");
                this.xrayCmd.setOthers("127.0.0.1:" + port);
                String[] cmd = this.xrayCmd.buildCmd();
                this.stop = false;
                this.execAndFresh(cmd);
                this.mitmScanButton.setText("\u5173\u95ed\u88ab\u52a8\u76d1\u542c");
                this.portText.setEnabled(false);
                mitmRunning = true;
            } else {
                this.stop = true;
                this.portText.setEnabled(true);
                this.mitmScanButton.setText("\u5f00\u542f\u88ab\u52a8\u626b\u63cf");
                mitmRunning = false;
                this.outputTextArea.setText(null);
            }
        });
    }

    public void initHttpProxy() {
        this.proxyConfigButton.addActionListener(e -> {
            String httpProxy = this.proxyText.getText();
            for (Map.Entry<String, Object> entry : configObj.entrySet()) {
                if (!entry.getKey().equals("http")) continue;
                Map httpModule = (Map)entry.getValue();
                httpModule.put("proxy", httpProxy);
            }
            this.refreshConfig();
            JOptionPane.showMessageDialog(null, "\u8bbe\u7f6e\u4ee3\u7406\u6210\u529f");
        });
    }

    public void initReverse() {
        this.reverseConfigButton.addActionListener(e -> {
            String http = this.httpReverseText.getText();
            String dns = this.dnsText.getText();
            for (Map.Entry<String, Object> entry : configObj.entrySet()) {
                if (!entry.getKey().equals("reverse")) continue;
                Map reverse = (Map)entry.getValue();
                Map client = (Map)reverse.get("client");
                client.put("reverse_server", true);
                client.put("http_base_url", http);
                client.put("dns_server_ip", dns);
            }
            this.refreshConfig();
            JOptionPane.showMessageDialog(null, "\u8bbe\u7f6e\u53cd\u8fde\u6210\u529f");
        });
    }

    public void initForcedStop() {
        this.stopButton.addActionListener(e -> {
            this.stop = true;
            this.outputTextArea.setText(null);
            JOptionPane.showMessageDialog(null, "\u5df2\u5f3a\u5236\u505c\u6b62");
        });
    }

    public void initOpenOutput() {
        this.openResultButton.addActionListener(e -> {
            if (StringUtil.notEmpty(outputFilePath.trim())) {
                if (Files.exists(Paths.get(outputFilePath, new String[0]), new LinkOption[0])) {
                    ExecUtil.execOpen(outputFilePath);
                } else {
                    logger.info("output file not exist");
                }
            } else {
                logger.warn("output file is none");
            }
        });
    }

    public void initReset() {
        this.resetConfigButton.addActionListener(e -> {
            this.reloadConfig(true);
            JOptionPane.showMessageDialog(null, "\u5df2\u6062\u590d");
        });
    }

    private void initHttpUtil() {
        this.httpUtilButton.addActionListener(e -> {
            JFrame frame = new JFrame("Http\u5de5\u5177");
            frame.setContentPane(new HttpUtilForm().httpUtilPanel);
            frame.setResizable(false);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public void initListenUtil() {
        this.listenUtilButton.addActionListener(e -> {
            JFrame frame = new JFrame("\u76d1\u542c\u7aef\u53e3\u5de5\u5177");
            frame.setContentPane(new ListenUtilForm().listenUtilPanel);
            frame.setResizable(false);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public void initEncodeUtil() {
        this.encodeUtilButton.addActionListener(e -> {
            JFrame frame = new JFrame("\u7f16\u7801\u5de5\u5177");
            frame.setContentPane(new EncodeUtilForm().encodeUtilPanel);
            frame.setResizable(false);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public MainForm() {
        this.$$$setupUI$$$();
        this.init();
        this.initLoadXray();
        this.initPluginCheckBox();
        this.initPluginSave();
        this.initAdvanceConfig();
        this.initOutputConfig();
        this.initRawScanConfig();
        this.initUrlFileConfig();
        this.initTargetUrlConfig();
        this.initAllPoC();
        this.initHttpProxy();
        this.initTargetPoC();
        this.initActiveScan();
        this.initMitmScan();
        this.initReverse();
        this.initForcedStop();
        this.initOpenOutput();
        this.initReset();
        this.initHttpUtil();
        this.initListenUtil();
        this.initEncodeUtil();
    }

    public static void startMainForm() {
        JFrame frame = new JFrame("SuperXray");
        instance = new MainForm();
        frame.setContentPane(MainForm.instance.SuperXray);
        frame.setDefaultCloseOperation(3);
        frame.setResizable(false);
        frame.pack();
        frame.setVisible(true);
    }

    private void $$$setupUI$$$() {
        this.SuperXray = new JPanel();
        this.SuperXray.setLayout(new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.SuperXray.setBackground(new Color(-725535));
        this.loadXrayPanel = new JPanel();
        this.loadXrayPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.loadXrayPanel.setBackground(new Color(-725535));
        this.SuperXray.add((Component)this.loadXrayPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.loadXrayPanel.setBorder(BorderFactory.createTitledBorder(null, "Super Xray", 0, 0, null, null));
        this.choseXrayLabel = new JLabel();
        this.choseXrayLabel.setText("\u9009\u62e9\u4f60\u7684xray\u6587\u4ef6");
        this.loadXrayPanel.add((Component)this.choseXrayLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.showPathPanel = new JPanel();
        this.showPathPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.showPathPanel.setBackground(new Color(-725535));
        this.loadXrayPanel.add((Component)this.showPathPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.xrayPathLabel = new JLabel();
        this.xrayPathLabel.setText("\u4f60\u9009\u62e9\u7684xray\u6587\u4ef6\u662f\uff1a");
        this.showPathPanel.add((Component)this.xrayPathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.xrayPathTextField = new JTextField();
        this.xrayPathTextField.setEditable(false);
        this.xrayPathTextField.setEnabled(false);
        this.showPathPanel.add((Component)this.xrayPathTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(500, -1), null, 0, false));
        this.pathButtonPanel = new JPanel();
        this.pathButtonPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.pathButtonPanel.setBackground(new Color(-725535));
        this.loadXrayPanel.add((Component)this.pathButtonPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.choseDirButton = new JButton();
        this.choseDirButton.setText("\u70b9\u51fb\u6309\u94ae\u9009\u62e9");
        this.pathButtonPanel.add((Component)this.choseDirButton, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null, 0, false));
        this.noteLabel = new JLabel();
        this.noteLabel.setText("\u6ce8\u610f\uff1a\u5728 Mac OS \u4e2d\u8bf7\u7528 control+c/v \u590d\u5236/\u7c98\u8d34\uff08\u4e0d\u662f command \u952e\uff09");
        this.pathButtonPanel.add((Component)this.noteLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, new Dimension(300, -1), null, null, 0, false));
        this.configPanel = new JPanel();
        this.configPanel.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.configPanel.setBackground(new Color(-725535));
        this.SuperXray.add((Component)this.configPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.leftConfigPanel = new JPanel();
        this.leftConfigPanel.setLayout(new GridLayoutManager(11, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.leftConfigPanel.setBackground(new Color(-725535));
        this.leftConfigPanel.setEnabled(true);
        this.leftConfigPanel.setForeground(new Color(-4540485));
        this.leftConfigPanel.setToolTipText("");
        this.configPanel.add((Component)this.leftConfigPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.leftConfigPanel.setBorder(BorderFactory.createTitledBorder(null, "\u626b\u63cf\u63d2\u4ef6\u914d\u7f6e", 0, 0, null, null));
        this.catConfigPanel = new JPanel();
        this.catConfigPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.catConfigPanel.setBackground(new Color(-725535));
        this.leftConfigPanel.add((Component)this.catConfigPanel, new GridConstraints(0, 0, 1, 4, 0, 3, 1, 1, null, null, null, 0, false));
        this.catConfigLabel = new JLabel();
        this.catConfigLabel.setText("<html>\n\u4f7f\u7528\u7684\u63d2\u4ef6\uff1a\n<br>\n<b>\u8bf7\u914d\u7f6e\u5b8c\u6210\u540e\u70b9\u51fb->\u786e\u8ba4\u63d2\u4ef6</b>\n<p>(\u90e8\u5206\u63d2\u4ef6\u4ec5\u9ad8\u7ea7\u7248\u652f\u6301)</p>\n</html>");
        this.catConfigPanel.add((Component)this.catConfigLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.confirmPluginButton = new JButton();
        this.confirmPluginButton.setText("\u786e\u8ba4\u63d2\u4ef6");
        this.catConfigPanel.add((Component)this.confirmPluginButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.bruteForceCheckBox = new JCheckBox();
        this.bruteForceCheckBox.setText("bruteforce\uff08\u66b4\u529b\u7834\u89e3\uff09");
        this.leftConfigPanel.add((Component)this.bruteForceCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.baselineCheckBox = new JCheckBox();
        this.baselineCheckBox.setText("baseline\uff08\u57fa\u7ebf\u68c0\u67e5\uff09");
        this.leftConfigPanel.add((Component)this.baselineCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.cmdInjectionCheckBox = new JCheckBox();
        this.cmdInjectionCheckBox.setText("cmd-injection");
        this.leftConfigPanel.add((Component)this.cmdInjectionCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.crlfInjectionCheckBox = new JCheckBox();
        this.crlfInjectionCheckBox.setText("crlf-injection");
        this.leftConfigPanel.add((Component)this.crlfInjectionCheckBox, new GridConstraints(1, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.dirscanCheckBox = new JCheckBox();
        this.dirscanCheckBox.setText("dirscan");
        this.leftConfigPanel.add((Component)this.dirscanCheckBox, new GridConstraints(2, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.fastjsonCheckBox = new JCheckBox();
        this.fastjsonCheckBox.setText("fastjson");
        this.leftConfigPanel.add((Component)this.fastjsonCheckBox, new GridConstraints(3, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.jsonpCheckBox = new JCheckBox();
        this.jsonpCheckBox.setText("jsonp");
        this.leftConfigPanel.add((Component)this.jsonpCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.pathTraversalCheckBox = new JCheckBox();
        this.pathTraversalCheckBox.setText("path-traversal");
        this.leftConfigPanel.add((Component)this.pathTraversalCheckBox, new GridConstraints(4, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.phantasmCheckBox = new JCheckBox();
        this.phantasmCheckBox.setText("phantasm\uff08PoC\u5408\u96c6\uff09");
        this.leftConfigPanel.add((Component)this.phantasmCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.redirectCheckBox = new JCheckBox();
        this.redirectCheckBox.setText("redirect");
        this.leftConfigPanel.add((Component)this.redirectCheckBox, new GridConstraints(5, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.shiroCheckBox = new JCheckBox();
        this.shiroCheckBox.setText("shiro");
        this.leftConfigPanel.add((Component)this.shiroCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.sqldetCheckBox = new JCheckBox();
        this.sqldetCheckBox.setText("sqldet\uff08sql\u6ce8\u5165\uff09");
        this.leftConfigPanel.add((Component)this.sqldetCheckBox, new GridConstraints(6, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.ssrfCheckBox = new JCheckBox();
        this.ssrfCheckBox.setText("ssrf");
        this.leftConfigPanel.add((Component)this.ssrfCheckBox, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.strutsCheckBox = new JCheckBox();
        this.strutsCheckBox.setText("struts");
        this.leftConfigPanel.add((Component)this.strutsCheckBox, new GridConstraints(7, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.thinkphpCheckBox = new JCheckBox();
        this.thinkphpCheckBox.setText("thinkphp");
        this.leftConfigPanel.add((Component)this.thinkphpCheckBox, new GridConstraints(8, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.uploadCheckBox = new JCheckBox();
        this.uploadCheckBox.setText("upload");
        this.leftConfigPanel.add((Component)this.uploadCheckBox, new GridConstraints(8, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.xxeCheckBox = new JCheckBox();
        this.xxeCheckBox.setText("xxe");
        this.leftConfigPanel.add((Component)this.xxeCheckBox, new GridConstraints(9, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.xssCheckBox = new JCheckBox();
        this.xssCheckBox.setText("xss");
        this.leftConfigPanel.add((Component)this.xssCheckBox, new GridConstraints(9, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.enableAllButton = new JButton();
        this.enableAllButton.setText("\u5168\u9009 / \u53d6\u6d88\u5168\u9009");
        this.leftConfigPanel.add((Component)this.enableAllButton, new GridConstraints(10, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.advanceButton = new JButton();
        this.advanceButton.setText("\u9ad8\u7ea7\u914d\u7f6e");
        this.leftConfigPanel.add((Component)this.advanceButton, new GridConstraints(10, 3, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.rightConfigPanel = new JPanel();
        this.rightConfigPanel.setLayout(new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.rightConfigPanel.setBackground(new Color(-725535));
        this.rightConfigPanel.setEnabled(true);
        this.configPanel.add((Component)this.rightConfigPanel, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.proxyConfigPanel = new JPanel();
        this.proxyConfigPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.proxyConfigPanel.setBackground(new Color(-725535));
        this.rightConfigPanel.add((Component)this.proxyConfigPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.proxyConfigPanel.setBorder(BorderFactory.createTitledBorder(null, "\u4ee3\u7406\u914d\u7f6e", 0, 0, null, null));
        this.proxyPanel = new JPanel();
        this.proxyPanel.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.proxyPanel.setBackground(new Color(-725535));
        this.proxyConfigPanel.add((Component)this.proxyPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.proxyConfigButton = new JButton();
        this.proxyConfigButton.setText("\u786e\u8ba4");
        this.proxyPanel.add((Component)this.proxyConfigButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.proxyLabel = new JLabel();
        this.proxyLabel.setText("\u8f93\u5165HTTP\u4ee3\u7406URL");
        this.proxyPanel.add((Component)this.proxyLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.proxyText = new JTextField();
        this.proxyPanel.add((Component)this.proxyText, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.reverseConfigPanel = new JPanel();
        this.reverseConfigPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.reverseConfigPanel.setBackground(new Color(-725535));
        this.rightConfigPanel.add((Component)this.reverseConfigPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.reverseConfigPanel.setBorder(BorderFactory.createTitledBorder(null, "\u53cd\u8fde\u5e73\u53f0", 0, 0, null, null));
        this.reverseUrlPanel = new JPanel();
        this.reverseUrlPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.reverseUrlPanel.setBackground(new Color(-725535));
        this.reverseConfigPanel.add((Component)this.reverseUrlPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.httpReverseLabel = new JLabel();
        this.httpReverseLabel.setText("\u8bf7\u8f93\u5165HTTP URL\uff08IP\u5f62\u5f0f\uff09");
        this.reverseUrlPanel.add((Component)this.httpReverseLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.httpReverseText = new JTextField();
        this.reverseUrlPanel.add((Component)this.httpReverseText, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.dnsReverseLabel = new JLabel();
        this.dnsReverseLabel.setText("DNS IP\uff08IP\u5f62\u5f0f\uff09");
        this.reverseUrlPanel.add((Component)this.dnsReverseLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.dnsText = new JTextField();
        this.reverseUrlPanel.add((Component)this.dnsText, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.reverseConfigButton = new JButton();
        this.reverseConfigButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.reverseConfigPanel.add((Component)this.reverseConfigButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.startScanPanel = new JPanel();
        this.startScanPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.startScanPanel.setBackground(new Color(-725535));
        this.rightConfigPanel.add((Component)this.startScanPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.startScanPanel.setBorder(BorderFactory.createTitledBorder(null, "\u542f\u52a8", 0, 0, null, null));
        this.activeScanButton = new JButton();
        this.activeScanButton.setText("\u5f00\u542f\u4e3b\u52a8\u626b\u63cf");
        this.startScanPanel.add((Component)this.activeScanButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.mitmPanel = new JPanel();
        this.mitmPanel.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mitmPanel.setBackground(new Color(-725535));
        this.startScanPanel.add((Component)this.mitmPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.mitmScanButton = new JButton();
        this.mitmScanButton.setText("\u5f00\u542f\u88ab\u52a8\u626b\u63cf");
        this.mitmPanel.add((Component)this.mitmScanButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.portText = new JTextField();
        this.portText.setText("");
        this.mitmPanel.add((Component)this.portText, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.portLabel = new JLabel();
        this.portLabel.setText("\u88ab\u52a8\u76d1\u542c\u7aef\u53e3:");
        this.mitmPanel.add((Component)this.portLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.otherPanel = new JPanel();
        this.otherPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.otherPanel.setBackground(new Color(-725535));
        this.rightConfigPanel.add((Component)this.otherPanel, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.otherPanel.setBorder(BorderFactory.createTitledBorder(null, "\u5176\u4ed6", 0, 0, null, null));
        this.lookupCmdButton = new JButton();
        this.lookupCmdButton.setText("\u67e5\u770b\u5f53\u524d\u547d\u4ee4");
        this.otherPanel.add((Component)this.lookupCmdButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.lookupConfigButton = new JButton();
        this.lookupConfigButton.setText("\u67e5\u770b\u5f53\u524d\u914d\u7f6e\u6587\u4ef6");
        this.otherPanel.add((Component)this.lookupConfigButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.midConfigPanel = new JPanel();
        this.midConfigPanel.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.midConfigPanel.setBackground(new Color(-725535));
        this.configPanel.add((Component)this.midConfigPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.pocPanel = new JPanel();
        this.pocPanel.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.pocPanel.setBackground(new Color(-725535));
        this.midConfigPanel.add((Component)this.pocPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 1, null, null, null, 0, false));
        this.pocPanel.setBorder(BorderFactory.createTitledBorder(null, "PoC\u6a21\u5757", 0, 0, null, null));
        this.pocButton = new JButton();
        this.pocButton.setText("\u6307\u5b9aPoC");
        this.pocPanel.add((Component)this.pocButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.allPoCButton = new JButton();
        this.allPoCButton.setText("\u67e5\u770b\u6240\u6709PoC");
        this.pocPanel.add((Component)this.allPoCButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.usePoCText = new JTextField();
        this.pocPanel.add((Component)this.usePoCText, new GridConstraints(1, 0, 1, 2, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.pocNumLabel = new JLabel();
        this.pocNumLabel.setText("\u5f53\u524dxray\u7684PoC\u6570\u91cf\uff1a");
        this.pocPanel.add((Component)this.pocNumLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.updatePocButton = new JButton();
        this.updatePocButton.setText("\u540c\u6b65PoC\u6570\u636e\u5e93");
        this.pocPanel.add((Component)this.updatePocButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.scanTargetPanel = new JPanel();
        this.scanTargetPanel.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.scanTargetPanel.setBackground(new Color(-725535));
        this.midConfigPanel.add((Component)this.scanTargetPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.scanTargetPanel.setBorder(BorderFactory.createTitledBorder(null, " \u626b\u63cf\u76ee\u6807\u8bbe\u7f6e", 0, 0, null, null));
        this.rawFileField = new JTextField();
        this.rawFileField.setEditable(false);
        this.rawFileField.setEnabled(false);
        this.scanTargetPanel.add((Component)this.rawFileField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.rawFileButton = new JButton();
        this.rawFileButton.setText("\u6307\u5b9arequest\u6587\u4ef6");
        this.scanTargetPanel.add((Component)this.rawFileButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.urlField = new JTextField();
        this.urlField.setEditable(true);
        this.scanTargetPanel.add((Component)this.urlField, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.urlButton = new JButton();
        this.urlButton.setText("\u6307\u5b9aurl");
        this.scanTargetPanel.add((Component)this.urlButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.urlFileField = new JTextField();
        this.urlFileField.setEditable(false);
        this.urlFileField.setEnabled(false);
        this.scanTargetPanel.add((Component)this.urlFileField, new GridConstraints(2, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.urlFileButton = new JButton();
        this.urlFileButton.setText("\u6307\u5b9aurl\u5217\u8868\u6587\u4ef6");
        this.scanTargetPanel.add((Component)this.urlFileButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.outputConfigPanel = new JPanel();
        this.outputConfigPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.outputConfigPanel.setBackground(new Color(-725535));
        this.midConfigPanel.add((Component)this.outputConfigPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.outputConfigPanel.setBorder(BorderFactory.createTitledBorder(null, "\u8f93\u51fa\u6a21\u5757", 0, 0, null, null));
        this.outputConfigButton = new JButton();
        this.outputConfigButton.setText("\u70b9\u51fb\u786e\u8ba4\u8f93\u51fa\u914d\u7f6e");
        this.outputConfigPanel.add((Component)this.outputConfigButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.scanOutConfigPanel = new JPanel();
        this.scanOutConfigPanel.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.scanOutConfigPanel.setBackground(new Color(-725535));
        this.outputConfigPanel.add((Component)this.scanOutConfigPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.htmlRadioButton = new JRadioButton();
        this.htmlRadioButton.setText("html");
        this.scanOutConfigPanel.add((Component)this.htmlRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.cliRadioButton = new JRadioButton();
        this.cliRadioButton.setText("cli");
        this.scanOutConfigPanel.add((Component)this.cliRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.jsonRadioButton = new JRadioButton();
        this.jsonRadioButton.setText("json");
        this.scanOutConfigPanel.add((Component)this.jsonRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.utilPanel = new JPanel();
        this.utilPanel.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.utilPanel.setBackground(new Color(-725535));
        this.midConfigPanel.add((Component)this.utilPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.utilPanel.setBorder(BorderFactory.createTitledBorder(null, "\u5c0f\u5de5\u5177", 0, 0, null, null));
        this.httpUtilButton = new JButton();
        this.httpUtilButton.setText("http \u8bf7\u6c42\u6d4b\u8bd5");
        this.utilPanel.add((Component)this.httpUtilButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.encodeUtilButton = new JButton();
        this.encodeUtilButton.setText("\u7f16\u7801\u5de5\u5177");
        this.utilPanel.add((Component)this.encodeUtilButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.listenUtilButton = new JButton();
        this.listenUtilButton.setText("\u76d1\u542c\u7aef\u53e3");
        this.utilPanel.add((Component)this.listenUtilButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.bottomPanel.setBackground(new Color(-725535));
        this.SuperXray.add((Component)this.bottomPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.authorLabel = new JLabel();
        this.authorLabel.setHorizontalAlignment(0);
        this.authorLabel.setHorizontalTextPosition(0);
        this.authorLabel.setText("<html> <p>Author: 4ra1n (https://github.com/4ra1n) from Chaitin Tech</p> </html>");
        this.bottomPanel.add((Component)this.authorLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.bottomPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 20), null, null, 0, false));
        this.outputPanel = new JScrollPane();
        this.outputPanel.setBackground(new Color(-725535));
        this.outputPanel.setForeground(new Color(-725535));
        this.SuperXray.add((Component)this.outputPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 5, 5, new Dimension(-1, 300), null, null, 0, false));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder(null, "\u547d\u4ee4\u884c\u8f93\u51fa\u7ed3\u679c\uff1a", 0, 0, null, null));
        this.outputTextArea = new JTextArea();
        this.outputTextArea.setBackground(new Color(-12828863));
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setForeground(new Color(-16711895));
        this.outputTextArea.setLineWrap(true);
        this.outputPanel.setViewportView(this.outputTextArea);
        this.otherButton = new JPanel();
        this.otherButton.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.otherButton.setBackground(new Color(-725535));
        this.SuperXray.add((Component)this.otherButton, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.resetPanel = new JPanel();
        this.resetPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.resetPanel.setBackground(new Color(-725535));
        this.otherButton.add((Component)this.resetPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.resetConfigLabel = new JLabel();
        this.resetConfigLabel.setText("\u6062\u590d\u9ed8\u8ba4\u914d\u7f6e\uff1a");
        this.resetPanel.add((Component)this.resetConfigLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.resetConfigButton = new JButton();
        this.resetConfigButton.setText("\u70b9\u51fb\u6309\u94ae\u6062\u590d");
        this.resetPanel.add((Component)this.resetConfigButton, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 0, null, null, new Dimension(100, -1), 0, false));
        this.openResultPanel = new JPanel();
        this.openResultPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.openResultPanel.setBackground(new Color(-725535));
        this.otherButton.add((Component)this.openResultPanel, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null, 1, false));
        this.openResultLabel = new JLabel();
        this.openResultLabel.setText(" \u6253\u5f00\u626b\u63cf\u7ed3\u679c\uff1a\uff08\u5982\u679c\u5b58\u5728\uff09");
        this.openResultPanel.add((Component)this.openResultLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.openResultButton = new JButton();
        this.openResultButton.setText("\u70b9\u51fb\u6253\u5f00\u626b\u63cf\u7ed3\u679c");
        this.openResultPanel.add((Component)this.openResultButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.stopPanel = new JPanel();
        this.stopPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.stopPanel.setBackground(new Color(-725535));
        this.otherButton.add((Component)this.stopPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.stopLabel = new JLabel();
        this.stopLabel.setText("  \u5982\u679c\u610f\u5916\u5730\u8fd0\u884c\u4e86\u5371\u9669\u7684\u7a0b\u5e8f\u53ef\u4ee5\u70b9\u51fb\uff1a");
        this.stopPanel.add((Component)this.stopLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.stopButton = new JButton();
        this.stopButton.setText("\u5f3a\u5236\u505c\u6b62");
        this.stopPanel.add((Component)this.stopButton, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.htmlRadioButton);
        buttonGroup.add(this.cliRadioButton);
        buttonGroup.add(this.jsonRadioButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.SuperXray;
    }

    static {
        pluginAll = false;
        mitmRunning = false;
    }
}

