/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.idcardphoto.camera;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import java.util.Calendar;

public class SensorControler
implements SensorEventListener {
    public static final String TAG = "SensorControler";
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private int mX;
    private int mY;
    private int mZ;
    private long lastStaticStamp = 0L;
    Calendar mCalendar;
    public static final int DELEY_DURATION = 500;
    private static SensorControler mInstance;
    private int foucsing = 1;
    boolean isFocusing = false;
    boolean canFocusIn = false;
    boolean canFocus = false;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_STATIC = 1;
    public static final int STATUS_MOVE = 2;
    private int STATUE = 0;
    private CameraFocusListener mCameraFocusListener;

    private SensorControler(Context context) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
    }

    public static SensorControler getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new SensorControler(context);
        }
        return mInstance;
    }

    public void onStart() {
        this.restParams();
        this.canFocus = true;
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
    }

    public void onStop() {
        this.mSensorManager.unregisterListener((SensorEventListener)this, this.mSensor);
        this.canFocus = false;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        if (this.isFocusing) {
            this.restParams();
            return;
        }
        if (event.sensor.getType() == 1) {
            int x = (int)event.values[0];
            int y = (int)event.values[1];
            int z = (int)event.values[2];
            this.mCalendar = Calendar.getInstance();
            long stamp = this.mCalendar.getTimeInMillis();
            int second = this.mCalendar.get(13);
            if (this.STATUE != 0) {
                int pz;
                int py;
                int px = Math.abs(this.mX - x);
                double value = Math.sqrt(px * px + (py = Math.abs(this.mY - y)) * py + (pz = Math.abs(this.mZ - z)) * pz);
                if (value > 1.4) {
                    this.STATUE = 2;
                } else {
                    if (this.STATUE == 2) {
                        this.lastStaticStamp = stamp;
                        this.canFocusIn = true;
                    }
                    if (this.canFocusIn && stamp - this.lastStaticStamp > 500L && !this.isFocusing) {
                        this.canFocusIn = false;
                        if (this.mCameraFocusListener != null) {
                            this.mCameraFocusListener.onFocus();
                        }
                    }
                    this.STATUE = 1;
                }
            } else {
                this.lastStaticStamp = stamp;
                this.STATUE = 1;
            }
            this.mX = x;
            this.mY = y;
            this.mZ = z;
        }
    }

    private void restParams() {
        this.STATUE = 0;
        this.canFocusIn = false;
        this.mX = 0;
        this.mY = 0;
        this.mZ = 0;
    }

    public boolean isFocusLocked() {
        if (this.canFocus) {
            return this.foucsing <= 0;
        }
        return false;
    }

    public void lockFocus() {
        this.isFocusing = true;
        --this.foucsing;
        Log.i((String)TAG, (String)"lockFocus");
    }

    public void unlockFocus() {
        this.isFocusing = false;
        ++this.foucsing;
        Log.i((String)TAG, (String)"unlockFocus");
    }

    public void restFoucs() {
        this.foucsing = 1;
    }

    public void setCameraFocusListener(CameraFocusListener mCameraFocusListener) {
        this.mCameraFocusListener = mCameraFocusListener;
    }

    public static interface CameraFocusListener {
        public void onFocus();
    }
}

