/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.idcardphoto.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import cn.mrlong.idcardphoto.camera.CameraUtils;
import cn.mrlong.idcardphoto.camera.SensorControler;
import java.io.IOException;
import java.util.List;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private SensorControler sensorControler;
    private Camera camera;

    public CameraPreview(Context context) {
        super(context);
        this.init(context);
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setKeepScreenOn(true);
        holder.setType(3);
        this.sensorControler = SensorControler.getInstance(context);
        this.sensorControler.setCameraFocusListener(new SensorControler.CameraFocusListener(){

            @Override
            public void onFocus() {
                CameraPreview.this.autoFocus();
            }
        });
    }

    public boolean switchFlashLight() {
        if (null != this.camera) {
            Camera.Parameters parameters = this.camera.getParameters();
            if (parameters.getFlashMode().equals("off")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
                return true;
            }
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
            return false;
        }
        return false;
    }

    public void takePic(Camera.PictureCallback callback) {
        if (null != this.camera) {
            this.camera.takePicture(null, null, callback);
        }
    }

    public void autoFocus() {
        if (null != this.camera) {
            this.camera.autoFocus(null);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.camera = CameraUtils.openCamera();
        if (this.camera != null) {
            try {
                this.camera.setPreviewDisplay(holder);
                Camera.Parameters parameters = this.camera.getParameters();
                if (this.getResources().getConfiguration().orientation == 1) {
                    this.camera.setDisplayOrientation(90);
                    parameters.setRotation(90);
                } else {
                    this.camera.setDisplayOrientation(0);
                    parameters.setRotation(0);
                }
                Camera.Size bestSize = this.getBestSize(parameters.getSupportedPreviewSizes());
                if (bestSize != null) {
                    parameters.setPreviewSize(bestSize.width, bestSize.height);
                    parameters.setPictureSize(bestSize.width, bestSize.height);
                } else {
                    parameters.setPreviewSize(1920, 1080);
                    parameters.setPictureSize(1920, 1080);
                }
                this.camera.setParameters(parameters);
                this.camera.startPreview();
                this.autoFocus();
            }
            catch (Exception e) {
                try {
                    Camera.Parameters parameters = this.camera.getParameters();
                    if (this.getResources().getConfiguration().orientation == 1) {
                        this.camera.setDisplayOrientation(90);
                        parameters.setRotation(90);
                    } else {
                        this.camera.setDisplayOrientation(0);
                        parameters.setRotation(0);
                    }
                    this.camera.setParameters(parameters);
                    this.camera.startPreview();
                    this.autoFocus();
                }
                catch (Exception e1) {
                    e.printStackTrace();
                    this.camera = null;
                }
            }
        }
    }

    private void setCameraParms(SurfaceHolder surfaceHolder) throws IOException {
        this.camera.setPreviewDisplay(surfaceHolder);
        Camera.Parameters parameters = this.camera.getParameters();
        if (this.getResources().getConfiguration().orientation == 1) {
            this.camera.setDisplayOrientation(90);
            parameters.setRotation(90);
        } else {
            this.camera.setDisplayOrientation(0);
            parameters.setRotation(0);
        }
        Camera.Size bastSize = this.getBestSize(parameters.getSupportedPreviewSizes());
        if (null != bastSize) {
            parameters.setPictureSize(bastSize.width, bastSize.height);
            parameters.setPreviewSize(bastSize.width, bastSize.height);
        } else {
            parameters.setPreviewSize(1920, 1080);
            parameters.setPictureSize(1920, 1080);
        }
        this.camera.setParameters(parameters);
        this.camera.startPreview();
        this.autoFocus();
    }

    private Camera.Size getBestSize(List<Camera.Size> sizes) {
        Camera.Size bestSize = null;
        for (Camera.Size size : sizes) {
            if ((float)size.width / (float)size.height != 1.7777778f) continue;
            if (bestSize == null) {
                bestSize = size;
                continue;
            }
            if (size.width <= bestSize.width) continue;
            bestSize = size;
        }
        return bestSize;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
    }

    public void onStop() {
        if (null != this.sensorControler) {
            this.sensorControler.onStop();
        }
        this.release();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.release();
    }

    private void release() {
        if (null != this.camera) {
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
        }
    }

    public void startPreview() {
        if (this.camera != null) {
            this.camera.startPreview();
        }
    }
}

