/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.idcardphoto.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import cn.mrlong.idcardphoto.R;
import cn.mrlong.idcardphoto.camera.CameraPreview;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class CameraActivity
extends Activity
implements View.OnClickListener {
    public static final int IDCARD_FRONT = 1;
    public static final int IDCARD_BACK = 2;
    public static final String TAKE_TYPE = "take_type";
    public static final String IMAGE_PATH = "image_path";
    public static final int REQ_CODE = 11;
    public static final int RES_CODE = 12;
    public static final int PERMISSION_CODE = 13;
    public static boolean isToastNotice = true;
    public static int mType;
    private CameraPreview mCameraPreview;
    private LinearLayout mLlCameraCropContainer;
    private ImageView mIvCameraCrop;
    private ImageView mIvCameraFlash;
    private LinearLayout mLlCameraOption;
    private LinearLayout mLlCameraResult;
    private TextView mViewCameraCropBottom;
    private Bitmap mCropBitmap;
    private ImageView resPicPre;
    private ImageView iv_camera_close;
    private ImageView iv_camera_take;
    private ImageView iv_camera_result_ok;
    private ImageView iv_camera_result_cancel;
    public static String FILE_PATH;

    public static void openCamera(Activity activity, int type) {
        Intent intent = new Intent((Context)activity, CameraActivity.class);
        intent.putExtra(TAKE_TYPE, type);
        activity.startActivityForResult(intent, 11);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean flag = CameraActivity.checkPermissionFirst((Context)this, 13, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.CAMERA"});
        if (flag) {
            this.init();
        }
    }

    private void init() {
        this.setContentView(R.layout.activity_camera);
        mType = this.getIntent().getIntExtra(TAKE_TYPE, 1);
        this.setRequestedOrientation(0);
        this.initView();
        this.initListener();
    }

    private void initView() {
        this.findView();
        float screenMinSize = Math.min(this.getResources().getDisplayMetrics().widthPixels, this.getResources().getDisplayMetrics().heightPixels);
        float maxSize = screenMinSize / 9.0f * 16.0f;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)maxSize, (int)screenMinSize);
        layoutParams.addRule(13);
        this.mCameraPreview.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        float height = (int)((double)screenMinSize * 0.75);
        float width = (int)(height * 75.0f / 47.0f);
        LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams((int)width, -1);
        LinearLayout.LayoutParams cropParams = new LinearLayout.LayoutParams((int)width, (int)height);
        this.mLlCameraCropContainer.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.mIvCameraCrop.setLayoutParams((ViewGroup.LayoutParams)cropParams);
        switch (mType) {
            case 1: {
                this.mIvCameraCrop.setImageResource(R.mipmap.camera_idcard_front);
                break;
            }
            case 2: {
                this.mIvCameraCrop.setImageResource(R.mipmap.camera_idcard_back);
            }
        }
    }

    private void findView() {
        this.mCameraPreview = (CameraPreview)this.findViewById(R.id.camera_preview);
        this.mLlCameraCropContainer = (LinearLayout)this.findViewById(R.id.ll_camera_crop_container);
        this.mIvCameraCrop = (ImageView)this.findViewById(R.id.iv_camera_crop);
        this.mIvCameraFlash = (ImageView)this.findViewById(R.id.iv_camera_flash);
        this.mLlCameraOption = (LinearLayout)this.findViewById(R.id.ll_camera_option);
        this.mLlCameraResult = (LinearLayout)this.findViewById(R.id.ll_camera_result);
        this.resPicPre = (ImageView)this.findViewById(R.id.iv_camera_result_pic);
        this.mViewCameraCropBottom = (TextView)this.findViewById(R.id.view_camera_crop_bottom);
        this.iv_camera_close = (ImageView)this.findViewById(R.id.iv_camera_close);
        this.iv_camera_take = (ImageView)this.findViewById(R.id.iv_camera_take);
        this.iv_camera_result_ok = (ImageView)this.findViewById(R.id.iv_camera_result_ok);
        this.iv_camera_result_cancel = (ImageView)this.findViewById(R.id.iv_camera_result_cancel);
    }

    private void initListener() {
        this.mCameraPreview.setOnClickListener(this);
        this.mIvCameraFlash.setOnClickListener((View.OnClickListener)this);
        this.iv_camera_close.setOnClickListener((View.OnClickListener)this);
        this.iv_camera_result_ok.setOnClickListener((View.OnClickListener)this);
        this.iv_camera_take.setOnClickListener((View.OnClickListener)this);
        this.iv_camera_result_cancel.setOnClickListener((View.OnClickListener)this);
    }

    public static boolean checkPermissionFirst(Context context, int requestCode, String[] permission2) {
        ArrayList<String> permissions = new ArrayList<String>();
        for (String per : permission2) {
            int permissionCode = ActivityCompat.checkSelfPermission((Context)context, (String)per);
            if (permissionCode == 0) continue;
            permissions.add(per);
        }
        if (!permissions.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])permissions.toArray(new String[permissions.size()]), (int)requestCode);
            return false;
        }
        return true;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean permissionsFlag = true;
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] != -1) continue;
            permissionsFlag = false;
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permissions[i])) continue;
            this.showNotice("\u8bf7\u624b\u52a8\u6253\u5f00\u8be5\u5e94\u7528\u9700\u8981\u7684\u6743\u9650");
            isToastNotice = false;
        }
        isToastNotice = true;
        if (permissionsFlag) {
            this.init();
        } else {
            this.finish();
        }
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.camera_preview) {
            this.mCameraPreview.autoFocus();
        } else if (i == R.id.iv_camera_close) {
            this.finish();
        } else if (i == R.id.iv_camera_take) {
            this.takePic();
        } else if (i == R.id.iv_camera_flash) {
            boolean isOpen = this.mCameraPreview.switchFlashLight();
            this.mIvCameraFlash.setImageResource(isOpen ? R.mipmap.camera_flash_on : R.mipmap.camera_flash_off);
        } else if (i == R.id.iv_camera_result_ok) {
            this.confirm();
        } else if (i == R.id.iv_camera_result_cancel) {
            this.mCameraPreview.setEnabled(true);
            this.mCameraPreview.startPreview();
            this.mIvCameraFlash.setImageResource(R.mipmap.camera_flash_off);
            this.setLayout();
        }
    }

    private void setCropLayout() {
        this.mIvCameraCrop.setVisibility(8);
        this.mCameraPreview.setVisibility(8);
        this.mLlCameraOption.setVisibility(8);
        this.resPicPre.setVisibility(0);
        this.mLlCameraResult.setVisibility(0);
        this.mViewCameraCropBottom.setText((CharSequence)"");
    }

    private void setLayout() {
        this.mIvCameraCrop.setVisibility(0);
        this.mCameraPreview.setVisibility(0);
        this.mLlCameraOption.setVisibility(0);
        this.resPicPre.setVisibility(8);
        this.mLlCameraResult.setVisibility(8);
        this.mViewCameraCropBottom.setText((CharSequence)"\u89e6\u6478\u5c4f\u5e55\u5bf9\u7126");
        this.mCameraPreview.autoFocus();
    }

    private void confirm() {
        if (!"".equals(FILE_PATH)) {
            String imgPath = "";
            File pathS = new File(FILE_PATH.toString());
            if (!pathS.exists()) {
                pathS.mkdirs();
            }
            imgPath = pathS.getPath();
            StringBuffer name = new StringBuffer();
            if (mType == 1) {
                name.append("idcard.jpg");
            } else {
                name.append("idcardback.jpg");
            }
            File realFile = new File(imgPath, name.toString());
            System.out.println("=====================================>" + realFile.getAbsolutePath());
            boolean flag = this.saveFile(this.mCropBitmap, realFile, Bitmap.CompressFormat.JPEG, false);
            if (flag) {
                Intent intent = new Intent();
                intent.putExtra(IMAGE_PATH, realFile.getAbsolutePath());
                this.setResult(12, intent);
                this.finish();
            }
        } else {
            this.showNotice("\u6ca1\u6709\u8bbe\u7f6e\u8def\u5f84");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveFile(Bitmap src, File file, Bitmap.CompressFormat format, boolean recycle) {
        if (CameraActivity.isEmptyBitmap(src)) {
            return false;
        }
        BufferedOutputStream os = null;
        boolean ret = false;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            ret = src.compress(format, 100, (OutputStream)os);
            if (!recycle) return ret;
            if (src.isRecycled()) return ret;
            src.recycle();
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ret;
        }
        finally {
            if (null != os) {
                try {
                    try {
                        ((OutputStream)os).flush();
                        ((OutputStream)os).close();
                        os = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        os = null;
                    }
                }
                catch (Throwable throwable) {
                    os = null;
                    throw throwable;
                }
            }
        }
    }

    private static boolean isEmptyBitmap(Bitmap src) {
        return src == null || src.getWidth() == 0 || src.getHeight() == 0;
    }

    private void showNotice(String msg) {
        if (isToastNotice) {
            Toast.makeText((Context)this, (CharSequence)msg, (int)0).show();
            Log.e((String)(((Object)((Object)this)).getClass().getName() + "==>"), (String)msg);
        }
    }

    private void takePic() {
        this.mCameraPreview.setEnabled(false);
        this.mCameraPreview.takePic(new Camera.PictureCallback(){

            public void onPictureTaken(final byte[] data, Camera camera) {
                camera.stopPreview();
                new Thread(){

                    @Override
                    public void run() {
                        super.run();
                        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                        float left = ((float)CameraActivity.this.mLlCameraCropContainer.getLeft() - (float)CameraActivity.this.mCameraPreview.getLeft()) / (float)CameraActivity.this.mCameraPreview.getWidth();
                        float top = (float)CameraActivity.this.mIvCameraCrop.getTop() / (float)CameraActivity.this.mCameraPreview.getHeight();
                        float right = (float)CameraActivity.this.mLlCameraCropContainer.getRight() / (float)CameraActivity.this.mCameraPreview.getWidth();
                        float bottom = (float)CameraActivity.this.mIvCameraCrop.getBottom() / (float)CameraActivity.this.mCameraPreview.getHeight();
                        CameraActivity.this.mCropBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)(left * (float)bitmap.getWidth())), (int)((int)(top * (float)bitmap.getHeight())), (int)((int)((right - left) * (float)bitmap.getWidth())), (int)((int)((bottom - top) * (float)bitmap.getHeight())));
                        CameraActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (null != CameraActivity.this.mCropBitmap) {
                                    CameraActivity.this.resPicPre.setImageBitmap(CameraActivity.this.mCropBitmap);
                                }
                                CameraActivity.this.setCropLayout();
                            }
                        });
                    }
                }.start();
            }
        });
    }

    protected void onDestroy() {
        super.onDestroy();
        if (null != this.mCameraPreview) {
            this.mCameraPreview.onStop();
        }
    }

    public static String getImagePath(Intent data) {
        if (data != null) {
            return data.getStringExtra(IMAGE_PATH);
        }
        return "";
    }

    public static void setPath(String path) {
        FILE_PATH = path;
    }

    static {
        FILE_PATH = "";
    }
}

