/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.recordandplay;

import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Message;
import java.util.Timer;
import java.util.TimerTask;

public class RecordUtil {
    private static int MESSAGE_RECORD = 99991;
    private MediaRecorder mediaRecorder;
    public boolean isRecording = false;
    private RecordTimeCallback callback;
    private int second = 0;
    private int minute = 0;
    private int hour = 0;
    private Timer timer;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (MESSAGE_RECORD == msg.what) {
                RecordUtil.this.callback.recordTime(RecordUtil.this.getFormatTime());
            }
        }
    };
    private long limitTime = 0L;
    private String outFilePath = "";

    private String getFormatTime() {
        return String.format("%1$02d:%2$02d:%3$02d", this.hour, this.minute, this.second);
    }

    public RecordUtil(RecordTimeCallback callback) {
        this.callback = callback;
    }

    public void startRecord(String outFilePath) {
        this.outFilePath = outFilePath;
        if (this.mediaRecorder == null) {
            this.mediaRecorder = new MediaRecorder();
        } else {
            this.mediaRecorder.reset();
        }
        this.mediaRecorder.setAudioSource(1);
        this.mediaRecorder.setOutputFormat(3);
        this.mediaRecorder.setAudioEncoder(1);
        this.mediaRecorder.setOutputFile(outFilePath);
        try {
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
            this.limitTime = System.currentTimeMillis();
            this.recordTime();
            this.isRecording = true;
        }
        catch (Exception e) {
            this.isRecording = false;
            this.resetTimeParams();
            e.printStackTrace();
        }
    }

    private void recordTime() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                RecordUtil.this.second++;
                if (RecordUtil.this.second >= 60) {
                    RecordUtil.this.second = 0;
                    RecordUtil.this.minute++;
                    if (RecordUtil.this.minute >= 60) {
                        RecordUtil.this.minute = 0;
                        RecordUtil.this.hour++;
                    }
                }
                RecordUtil.this.handler.sendEmptyMessage(MESSAGE_RECORD);
            }
        };
        this.timer = new Timer();
        this.timer.schedule(timerTask, 1000L, 1000L);
    }

    public void resetRecord() {
        if (null != this.mediaRecorder) {
            this.mediaRecorder.reset();
            this.resetTimeParams();
            this.isRecording = false;
        }
    }

    public void stopRecord() {
        if (System.currentTimeMillis() - this.limitTime < 1100L) {
            this.callback.noticeMsg("\u5f55\u97f3\u65f6\u95f4\u957f\u5ea6\u4e0d\u5f97\u4f4e\u4e8e1\u79d2\u949f\uff01");
            return;
        }
        if (null != this.mediaRecorder) {
            this.mediaRecorder.stop();
            this.mediaRecorder.release();
            this.callback.recordSucc(this.outFilePath, this.getFormatTime());
            this.resetTimeParams();
            this.mediaRecorder = null;
        }
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
        this.isRecording = false;
    }

    public void onDestory() {
        if (null != this.handler) {
            this.handler = null;
        }
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
        if (null != this.mediaRecorder) {
            this.mediaRecorder.stop();
            this.mediaRecorder.release();
            this.mediaRecorder = null;
        }
    }

    private void resetTimeParams() {
        this.minute = 0;
        this.hour = 0;
        this.second = 0;
    }

    public static interface RecordTimeCallback {
        public void recordTime(String var1);

        public void noticeMsg(String var1);

        public void recordSucc(String var1, String var2);
    }
}

