/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.mdialogstyle.dialog;

import android.app.Dialog;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import cn.mrlong.mdialogstyle.R;
import java.util.ArrayList;
import java.util.List;

public class AlertSheetDialog {
    private Context context;
    private TextView tv_cancel;
    private TextView tv_title;
    private boolean isShowTitle;
    private Dialog dialog;
    private RecyclerView rv_items;
    private SheetAdapter adapter;
    private ImageView iv_titleline;
    private boolean isWhite;

    public AlertSheetDialog(Context context) {
        this.context = context;
        this.isWhite = true;
    }

    public AlertSheetDialog(Context context, boolean isWhite) {
        this.context = context;
        this.isWhite = isWhite;
    }

    public AlertSheetDialog builder() {
        int layoutId = this.isWhite ? R.layout.dialog_actionsheet_white : R.layout.dialog_actionsheet;
        View view = LayoutInflater.from((Context)this.context).inflate(layoutId, null);
        this.tv_cancel = (TextView)view.findViewById(R.id.tv_cancel);
        this.tv_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (null != AlertSheetDialog.this.dialog) {
                    AlertSheetDialog.this.dialog.dismiss();
                }
            }
        });
        this.tv_title = (TextView)view.findViewById(R.id.tv_title);
        this.rv_items = (RecyclerView)view.findViewById(R.id.rv_items);
        this.iv_titleline = (ImageView)view.findViewById(R.id.iv_titleline);
        this.initRecycelerView(this.context);
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        view.setMinimumWidth(display.getWidth());
        this.dialog = new Dialog(this.context, R.style.ActionSheetDialogStyle);
        this.dialog.setContentView(view);
        Window window = this.dialog.getWindow();
        window.setGravity(83);
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.x = 0;
        lp.y = 0;
        window.setAttributes(lp);
        return this;
    }

    public AlertSheetDialog setItemClickListener(OnSheetItemClickListener listener) {
        this.adapter.setClickListener(listener);
        return this;
    }

    private void initRecycelerView(Context context) {
        this.rv_items.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        ArrayList<String> datas = new ArrayList<String>();
        this.adapter = new SheetAdapter(context, datas, this.isWhite);
        this.rv_items.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public AlertSheetDialog setCancelable(boolean cancel) {
        this.dialog.setCancelable(cancel);
        return this;
    }

    public AlertSheetDialog addItem(List<String> strItem) {
        this.adapter.datas.clear();
        this.adapter.datas.addAll(strItem);
        this.adapter.notifyDataSetChanged();
        return this;
    }

    public void show() {
        this.showViewControl();
        this.dialog.show();
    }

    public void dismiss() {
        if (null != this.dialog) {
            this.dialog.dismiss();
        }
    }

    private void showViewControl() {
        if (this.isShowTitle) {
            this.tv_title.setVisibility(0);
        } else {
            this.tv_title.setVisibility(8);
        }
    }

    public AlertSheetDialog setTitleTextColor(int color) {
        this.tv_title.setTextColor(color);
        return this;
    }

    public AlertSheetDialog setItemTextColor(int color) {
        this.adapter.setItemTextColor(color);
        return this;
    }

    public AlertSheetDialog setCanceledOnTouchOutside(boolean cancel) {
        this.dialog.setCanceledOnTouchOutside(cancel);
        return this;
    }

    public AlertSheetDialog setTitle(String title) {
        this.isShowTitle = true;
        if (null != title && !"".equals(title)) {
            this.tv_title.setText((CharSequence)title);
            this.iv_titleline.setVisibility(0);
            this.tv_title.setVisibility(0);
        } else {
            this.iv_titleline.setVisibility(8);
            this.tv_title.setVisibility(8);
        }
        return this;
    }

    public static interface OnSheetItemClickListener {
        public void onClick(int var1);
    }

    class SheetAdapter
    extends RecyclerView.Adapter<SheetHolder> {
        private Context context;
        private List<String> datas;
        private OnSheetItemClickListener itemClickListener;
        private int color;
        private boolean isWhite;

        public SheetAdapter(Context context, List<String> datas, boolean white) {
            this.context = context;
            this.datas = datas;
            this.isWhite = white;
        }

        public SheetHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = this.isWhite ? LayoutInflater.from((Context)this.context).inflate(R.layout.item_white, parent, false) : LayoutInflater.from((Context)this.context).inflate(R.layout.item, parent, false);
            SheetHolder holder = new SheetHolder(view);
            return holder;
        }

        public void onBindViewHolder(SheetHolder holder, int position) {
            holder.setData(position);
        }

        public int getItemCount() {
            return this.datas.size();
        }

        public void setClickListener(OnSheetItemClickListener listener) {
            this.itemClickListener = listener;
        }

        public void setItemTextColor(int color) {
            this.color = color;
        }

        class SheetHolder
        extends RecyclerView.ViewHolder {
            int position;
            TextView tv_content;
            ImageView line;

            public SheetHolder(View itemView) {
                super(itemView);
                this.tv_content = (TextView)itemView.findViewById(R.id.tv_content);
                this.line = (ImageView)itemView.findViewById(R.id.img_line);
            }

            public void setData(final int position) {
                this.position = position;
                this.tv_content.setText((CharSequence)SheetAdapter.this.datas.get(position));
                if (SheetAdapter.this.color != 0) {
                    this.tv_content.setTextColor(SheetAdapter.this.color);
                }
                if (position == SheetAdapter.this.datas.size() - 1) {
                    this.line.setVisibility(8);
                } else {
                    this.line.setVisibility(0);
                }
                this.tv_content.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        SheetAdapter.this.itemClickListener.onClick(position);
                        if (null != AlertSheetDialog.this.dialog) {
                            AlertSheetDialog.this.dialog.dismiss();
                        }
                    }
                });
            }
        }
    }
}

