/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.constraintlayout.widget.ConstraintLayout;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J(\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0014J\b\u0010,\u001a\u00020#H\u0002J\b\u0010-\u001a\u00020#H\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR$\u0010\u0013\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000fR$\u0010\u001f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\r\"\u0004\b!\u0010\u000f\u00a8\u0006."}, d2={"Lcom/giphy/sdk/ui/views/RoundedConstraintLayout;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "bottomLeftCornerRadius", "getBottomLeftCornerRadius", "()F", "setBottomLeftCornerRadius", "(F)V", "bottomRightCornerRadius", "getBottomRightCornerRadius", "setBottomRightCornerRadius", "cornerRadius", "getCornerRadius", "setCornerRadius", "mRadii", "", "path", "Landroid/graphics/Path;", "rectF", "Landroid/graphics/RectF;", "topLeftCornerRadius", "getTopLeftCornerRadius", "setTopLeftCornerRadius", "topRightCornerRadius", "getTopRightCornerRadius", "setTopRightCornerRadius", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "draw", "onSizeChanged", "w", "h", "oldw", "oldh", "resetPath", "updateCornersRadius", "giphy-ui-2.3.17_release"})
public class RoundedConstraintLayout
extends ConstraintLayout {
    @NotNull
    private final float[] mRadii;
    private RectF rectF;
    @NotNull
    private final Path path;
    private float cornerRadius;
    private float topLeftCornerRadius;
    private float topRightCornerRadius;
    private float bottomRightCornerRadius;
    private float bottomLeftCornerRadius;

    @JvmOverloads
    public RoundedConstraintLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mRadii = new float[8];
        this.path = new Path();
        ArraysKt.fill((float[])this.mRadii, (float)0.0f, (int)0, (int)this.mRadii.length);
        this.updateCornersRadius();
    }

    public /* synthetic */ RoundedConstraintLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final float getCornerRadius() {
        return this.cornerRadius;
    }

    public final void setCornerRadius(float value) {
        this.cornerRadius = value;
        ArraysKt.fill((float[])this.mRadii, (float)value, (int)0, (int)this.mRadii.length);
    }

    public final float getTopLeftCornerRadius() {
        return this.topLeftCornerRadius;
    }

    public final void setTopLeftCornerRadius(float value) {
        this.topLeftCornerRadius = value;
        this.updateCornersRadius();
    }

    public final float getTopRightCornerRadius() {
        return this.topRightCornerRadius;
    }

    public final void setTopRightCornerRadius(float value) {
        this.topRightCornerRadius = value;
        this.updateCornersRadius();
    }

    public final float getBottomRightCornerRadius() {
        return this.bottomRightCornerRadius;
    }

    public final void setBottomRightCornerRadius(float value) {
        this.bottomRightCornerRadius = value;
        this.updateCornersRadius();
    }

    public final float getBottomLeftCornerRadius() {
        return this.bottomLeftCornerRadius;
    }

    public final void setBottomLeftCornerRadius(float value) {
        this.bottomLeftCornerRadius = value;
        this.updateCornersRadius();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.rectF = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.resetPath();
    }

    private final void updateCornersRadius() {
        this.mRadii[0] = this.topLeftCornerRadius;
        this.mRadii[1] = this.topLeftCornerRadius;
        this.mRadii[2] = this.topRightCornerRadius;
        this.mRadii[3] = this.topRightCornerRadius;
        this.mRadii[4] = this.bottomRightCornerRadius;
        this.mRadii[5] = this.bottomRightCornerRadius;
        this.mRadii[6] = this.bottomLeftCornerRadius;
        this.mRadii[7] = this.bottomLeftCornerRadius;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int save = canvas.save();
        canvas.clipPath(this.path);
        super.draw(canvas);
        canvas.restoreToCount(save);
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int save = canvas.save();
        canvas.clipPath(this.path);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(save);
    }

    private final void resetPath() {
        this.path.reset();
        RectF rectF = this.rectF;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rectF");
            rectF = null;
        }
        this.path.addRoundRect(rectF, this.mRadii, Path.Direction.CW);
        this.path.close();
    }

    @JvmOverloads
    public RoundedConstraintLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RoundedConstraintLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

