/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.giphy.sdk.ui.GPHSuggestion;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.themes.Theme;
import com.giphy.sdk.ui.views.GPHSuggestionsAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0011\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/giphy/sdk/ui/views/GPHSuggestionsView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "theme", "Lcom/giphy/sdk/ui/themes/Theme;", "listener", "Lkotlin/Function1;", "Lcom/giphy/sdk/ui/GPHSuggestion;", "", "(Landroid/content/Context;Lcom/giphy/sdk/ui/themes/Theme;Lkotlin/jvm/functions/Function1;)V", "suggestions", "", "suggestionsAdapter", "Lcom/giphy/sdk/ui/views/GPHSuggestionsAdapter;", "getTheme", "()Lcom/giphy/sdk/ui/themes/Theme;", "update", "giphy-ui-2.3.17_release"})
@SuppressLint(value={"ViewConstructor", "NotifyDataSetChanged"})
public final class GPHSuggestionsView
extends ConstraintLayout {
    @NotNull
    private final Theme theme;
    @NotNull
    private final List<GPHSuggestion> suggestions;
    @NotNull
    private GPHSuggestionsAdapter suggestionsAdapter;

    public GPHSuggestionsView(@NotNull Context context, @NotNull Theme theme, @NotNull Function1<? super GPHSuggestion, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        super(context);
        this.theme = theme;
        this.suggestions = CollectionsKt.emptyList();
        LayoutInflater.from((Context)context).inflate(R.layout.gph_suggestions_view, (ViewGroup)this, true);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.suggestionsAdapter = new GPHSuggestionsAdapter(this.suggestions, this.theme, listener2);
        LinearLayoutManager layoutManager = new LinearLayoutManager(context);
        layoutManager.setOrientation(0);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        recyclerView.setAdapter((RecyclerView.Adapter)this.suggestionsAdapter);
        this.suggestionsAdapter.notifyDataSetChanged();
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    public final void update(@NotNull List<GPHSuggestion> suggestions2) {
        Intrinsics.checkNotNullParameter(suggestions2, (String)"suggestions");
        this.suggestionsAdapter.setSuggestions(suggestions2);
        this.suggestionsAdapter.notifyDataSetChanged();
    }
}

