/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.core;

import android.content.Context;
import com.giphy.sdk.analytics.GiphyPingbacks;
import com.giphy.sdk.analytics.batching.AnalyticsId;
import com.giphy.sdk.core.GiphyCoreUtils;
import com.giphy.sdk.core.network.api.GPHApiClient;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0014J \u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0005R6\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010\u001e\u00a8\u0006,"}, d2={"Lcom/giphy/sdk/core/GiphyCore;", "", "()V", "additionalHeaders", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getAdditionalHeaders", "()Ljava/util/HashMap;", "setAdditionalHeaders", "(Ljava/util/HashMap;)V", "apiClient", "Lcom/giphy/sdk/core/network/api/GPHApiClient;", "getApiClient", "()Lcom/giphy/sdk/core/network/api/GPHApiClient;", "setApiClient", "(Lcom/giphy/sdk/core/network/api/GPHApiClient;)V", "applicationContext", "Landroid/content/Context;", "value", "", "logsEnabled", "getLogsEnabled", "()Z", "setLogsEnabled", "(Z)V", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "secondaryApiClientInstances", "versionName", "getVersionName", "setVersionName", "configure", "", "context", "apiKey", "verificationMode", "configureSecondaryApiClient", "instanceName", "enableVerificationMode", "instanceByName", "giphy-ui-2.3.17_release"})
public final class GiphyCore {
    @NotNull
    public static final GiphyCore INSTANCE = new GiphyCore();
    public static GPHApiClient apiClient;
    @NotNull
    private static HashMap<String, String> additionalHeaders;
    @NotNull
    private static String name;
    @NotNull
    private static String versionName;
    private static boolean logsEnabled;
    private static Context applicationContext;
    @NotNull
    private static HashMap<String, GPHApiClient> secondaryApiClientInstances;

    private GiphyCore() {
    }

    @NotNull
    public final GPHApiClient getApiClient() {
        GPHApiClient gPHApiClient = apiClient;
        if (gPHApiClient != null) {
            return gPHApiClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"apiClient");
        return null;
    }

    public final void setApiClient(@NotNull GPHApiClient gPHApiClient) {
        Intrinsics.checkNotNullParameter((Object)gPHApiClient, (String)"<set-?>");
        apiClient = gPHApiClient;
    }

    @NotNull
    public final HashMap<String, String> getAdditionalHeaders() {
        return additionalHeaders;
    }

    public final void setAdditionalHeaders(@NotNull HashMap<String, String> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        additionalHeaders = hashMap;
    }

    @NotNull
    public final String getName() {
        return name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        name = string;
    }

    @NotNull
    public final String getVersionName() {
        return versionName;
    }

    public final void setVersionName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        versionName = string;
    }

    public final boolean getLogsEnabled() {
        return logsEnabled;
    }

    public final void setLogsEnabled(boolean value) {
        logsEnabled = value;
        GiphyPingbacks.INSTANCE.setLogsEnabled(value);
    }

    public final void configure(@NotNull Context context, @NotNull String apiKey, boolean verificationMode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        applicationContext = context2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-GIPHY-SDK-VERSION", (Object)versionName), TuplesKt.to((Object)"X-GIPHY-SDK-NAME", (Object)name), TuplesKt.to((Object)"X-GIPHY-SDK-PLATFORM", (Object)"Android"), TuplesKt.to((Object)"X-GIPHY-UI-SDK-IS-EXTENSION", (Object)String.valueOf(GiphyCoreUtils.INSTANCE.runningInExtensionContext(context))), TuplesKt.to((Object)"Accept-Encoding", (Object)"gzip,br")};
        additionalHeaders = MapsKt.hashMapOf((Pair[])pairArray);
        GiphyPingbacks.INSTANCE.setAdditionalHeaders(additionalHeaders);
        Context context3 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context.applicationContext");
        GiphyPingbacks.INSTANCE.configure(context3, apiKey, verificationMode);
        this.setApiClient(new GPHApiClient(apiKey, null, new AnalyticsId(apiKey, true, verificationMode), 2, null));
    }

    public static /* synthetic */ void configure$default(GiphyCore giphyCore, Context context, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        giphyCore.configure(context, string, bl);
    }

    @NotNull
    public final GPHApiClient configureSecondaryApiClient(@NotNull String instanceName, @NotNull String apiKey, boolean enableVerificationMode) {
        Intrinsics.checkNotNullParameter((Object)instanceName, (String)"instanceName");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        GPHApiClient apiClient = new GPHApiClient(apiKey, null, new AnalyticsId(apiKey, false, enableVerificationMode), 2, null);
        ((Map)secondaryApiClientInstances).put(instanceName, apiClient);
        return apiClient;
    }

    public static /* synthetic */ GPHApiClient configureSecondaryApiClient$default(GiphyCore giphyCore, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return giphyCore.configureSecondaryApiClient(string, string2, bl);
    }

    @NotNull
    public final GPHApiClient instanceByName(@NotNull String name) {
        GPHApiClient apiClient;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        GPHApiClient gPHApiClient = apiClient = secondaryApiClientInstances.get(name);
        if (gPHApiClient != null) {
            return gPHApiClient;
        }
        throw new Exception("An instance with name=" + name + " was never configured.");
    }

    static {
        additionalHeaders = new HashMap();
        name = "CoreSDK";
        versionName = "3.1.12";
        secondaryApiClientInstances = new HashMap();
    }
}

