/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.analytics.batching;

import android.util.Log;
import com.giphy.sdk.analytics.GiphyPingbacks;
import com.giphy.sdk.analytics.batching.AnalyticsId;
import com.giphy.sdk.analytics.batching.PingbackSubmissionQueue;
import com.giphy.sdk.analytics.batching.PingbackWrapperRecycler;
import com.giphy.sdk.analytics.models.AnalyticsEvent;
import com.giphy.sdk.analytics.models.Session;
import com.giphy.sdk.analytics.models.enums.ActionType;
import com.giphy.sdk.analytics.models.enums.EventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJl\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010\u00032\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00032\b\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0003J\u0006\u00100\u001a\u00020!J\u0010\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0002J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001904J\u001a\u00105\u001a\u00020\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u00102\u001a\u00020\u0003H\u0002J\b\u00106\u001a\u00020!H\u0002J\b\u00107\u001a\u00020!H\u0002J\b\u00108\u001a\u00020!H\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u001cH\u0002J\u001a\u0010;\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u00102\u001a\u00020\u0003H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/giphy/sdk/analytics/batching/PingbackCollector;", "", "apiKey", "", "isMainInstance", "", "enableVerificationMode", "submissionQueue", "Lcom/giphy/sdk/analytics/batching/PingbackSubmissionQueue;", "verificationMode", "(Ljava/lang/String;ZZLcom/giphy/sdk/analytics/batching/PingbackSubmissionQueue;Z)V", "addPingbackFuture", "Ljava/util/concurrent/ScheduledFuture;", "addPingbackRunnable", "Ljava/lang/Runnable;", "analyticsId", "Lcom/giphy/sdk/analytics/batching/AnalyticsId;", "getAnalyticsId", "()Lcom/giphy/sdk/analytics/batching/AnalyticsId;", "eventWrapperRecycler", "Lcom/giphy/sdk/analytics/batching/PingbackWrapperRecycler;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "pingbacksBatch", "", "Lcom/giphy/sdk/analytics/batching/PingbackWrapperRecycler$PingbackWrapper;", "sessions", "Ljava/util/HashMap;", "Lcom/giphy/sdk/analytics/models/Session;", "getSessions", "()Ljava/util/HashMap;", "submitReadySessionsFuture", "addPingback", "", "loggedInUserId", "analyticsResponsePayload", "referrer", "eventType", "Lcom/giphy/sdk/analytics/models/enums/EventType;", "mediaId", "tid", "actionType", "Lcom/giphy/sdk/analytics/models/enums/ActionType;", "sessionId", "layoutType", "position", "", "placement", "flush", "generalSessionKeyForUser", "userId", "getPingbacksBatch", "", "getSession", "processPingbacksBatch", "scheduleSubmitAllSessions", "submitAllSessions", "submitReadySession", "session", "uniqueSessionKey", "Companion", "giphy-ui-2.3.17_release"})
public final class PingbackCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String apiKey;
    private final boolean isMainInstance;
    private final boolean enableVerificationMode;
    @NotNull
    private final PingbackSubmissionQueue submissionQueue;
    private final boolean verificationMode;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final HashMap<String, Session> sessions;
    @Nullable
    private ScheduledFuture<?> addPingbackFuture;
    @Nullable
    private ScheduledFuture<?> submitReadySessionsFuture;
    @NotNull
    private final PingbackWrapperRecycler eventWrapperRecycler;
    @NotNull
    private final List<PingbackWrapperRecycler.PingbackWrapper> pingbacksBatch;
    @NotNull
    private final AnalyticsId analyticsId;
    @NotNull
    private final Runnable addPingbackRunnable;
    private static long addPingbackDelay = 3000L;
    private static long maximumIdleTimeBeforeSubmitting = 10000L;
    private static int maximumPingbacksBeforeSubmitting = 100;
    private static boolean isTestingEnvironment;

    public PingbackCollector(@NotNull String apiKey, boolean isMainInstance, boolean enableVerificationMode, @NotNull PingbackSubmissionQueue submissionQueue, boolean verificationMode) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)submissionQueue, (String)"submissionQueue");
        this.apiKey = apiKey;
        this.isMainInstance = isMainInstance;
        this.enableVerificationMode = enableVerificationMode;
        this.submissionQueue = submissionQueue;
        this.verificationMode = verificationMode;
        this.analyticsId = new AnalyticsId(this.apiKey, this.isMainInstance, this.enableVerificationMode);
        this.addPingbackRunnable = () -> PingbackCollector.addPingbackRunnable$lambda$0(this);
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
        this.executorService = scheduledExecutorService;
        this.sessions = new HashMap();
        this.pingbacksBatch = new ArrayList();
        this.eventWrapperRecycler = new PingbackWrapperRecycler();
    }

    public /* synthetic */ PingbackCollector(String string, boolean bl, boolean bl2, PingbackSubmissionQueue pingbackSubmissionQueue, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            pingbackSubmissionQueue = new PingbackSubmissionQueue(string, bl, bl2);
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        this(string, bl, bl2, pingbackSubmissionQueue, bl3);
    }

    @NotNull
    public final HashMap<String, Session> getSessions() {
        return this.sessions;
    }

    @NotNull
    public final AnalyticsId getAnalyticsId() {
        return this.analyticsId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPingback(@NotNull String loggedInUserId, @NotNull String analyticsResponsePayload, @Nullable String referrer, @Nullable EventType eventType, @NotNull String mediaId, @Nullable String tid, @NotNull ActionType actionType, @Nullable String sessionId, @Nullable String layoutType, int position, @Nullable String placement) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)loggedInUserId, (String)"loggedInUserId");
        Intrinsics.checkNotNullParameter((Object)analyticsResponsePayload, (String)"analyticsResponsePayload");
        Intrinsics.checkNotNullParameter((Object)mediaId, (String)"mediaId");
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        PingbackWrapperRecycler.PingbackWrapper pingbackWrapper = null;
        PingbackWrapperRecycler pingbackWrapperRecycler = this.eventWrapperRecycler;
        synchronized (pingbackWrapperRecycler) {
            boolean bl = false;
            String arp = analyticsResponsePayload;
            if (isTestingEnvironment) {
                arp = arp + "&mode=verification";
            }
            pingbackWrapper = this.eventWrapperRecycler.getItem(this.analyticsId.getPingbackId(), loggedInUserId, this.analyticsId.getVerificationID(), arp, referrer, eventType, mediaId, tid, actionType, sessionId, layoutType, position, placement);
            object = Unit.INSTANCE;
        }
        int pingbacksBatchSize = 0;
        object = this.pingbacksBatch;
        synchronized (object) {
            boolean bl = false;
            PingbackWrapperRecycler.PingbackWrapper pingbackWrapper2 = pingbackWrapper;
            if (pingbackWrapper2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pingbackWrapper");
                pingbackWrapper2 = null;
            }
            this.pingbacksBatch.add(pingbackWrapper2);
            pingbacksBatchSize = this.pingbacksBatch.size();
            Unit unit = Unit.INSTANCE;
        }
        if (this.addPingbackFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.addPingbackFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            if (!scheduledFuture.isCancelled()) {
                ScheduledFuture<?> scheduledFuture2 = this.addPingbackFuture;
                Intrinsics.checkNotNull(scheduledFuture2);
                scheduledFuture2.cancel(false);
            }
        }
        if (tid != null) {
            this.flush();
        } else if (pingbacksBatchSize < maximumPingbacksBeforeSubmitting) {
            this.addPingbackFuture = this.executorService.schedule(this.addPingbackRunnable, addPingbackDelay, TimeUnit.MILLISECONDS);
        } else {
            this.executorService.execute(this.addPingbackRunnable);
        }
    }

    public static /* synthetic */ void addPingback$default(PingbackCollector pingbackCollector, String string, String string2, String string3, EventType eventType, String string4, String string5, ActionType actionType, String string6, String string7, int n, String string8, int n2, Object object) {
        if ((n2 & 0x400) != 0) {
            string8 = null;
        }
        pingbackCollector.addPingback(string, string2, string3, eventType, string4, string5, actionType, string6, string7, n, string8);
    }

    public final void flush() {
        this.executorService.execute(() -> PingbackCollector.flush$lambda$3(this));
    }

    @NotNull
    public final List<PingbackWrapperRecycler.PingbackWrapper> getPingbacksBatch() {
        return this.pingbacksBatch;
    }

    private final void submitAllSessions() {
        Iterator<Map.Entry<String, Session>> it = this.sessions.entrySet().iterator();
        while (it.hasNext()) {
            Session session;
            Intrinsics.checkNotNullExpressionValue((Object)it.next().getValue(), (String)"it.next().value");
            if (!((Collection)session.getEvents()).isEmpty()) {
                if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
                    String string = "Enqueueing session %s %s";
                    Object[] objectArray = new Object[]{session.getSessionId(), session.getEvents().size()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    Log.d((String)"PINGBACK", (String)string2);
                }
                this.submissionQueue.add(session);
            }
            it.remove();
        }
    }

    private final void submitReadySession(Session session) {
        if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
            String string = "Enqueueing ready session %s %s";
            Object[] objectArray = new Object[]{session.getSessionId(), session.getEvents().size()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            Log.d((String)"PINGBACK", (String)string2);
        }
        this.submissionQueue.add(session);
        String string = session.getSessionId();
        String string3 = session.getUserId();
        if (string3 == null) {
            string3 = "";
        }
        this.sessions.remove(this.uniqueSessionKey(string, string3));
    }

    private final void scheduleSubmitAllSessions() {
        if (this.submitReadySessionsFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.submitReadySessionsFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            if (!scheduledFuture.isCancelled()) {
                ScheduledFuture<?> scheduledFuture2 = this.submitReadySessionsFuture;
                Intrinsics.checkNotNull(scheduledFuture2);
                scheduledFuture2.cancel(false);
            }
        }
        this.submitReadySessionsFuture = this.executorService.schedule(() -> PingbackCollector.scheduleSubmitAllSessions$lambda$4(this), maximumIdleTimeBeforeSubmitting, TimeUnit.MILLISECONDS);
    }

    private final Session getSession(String sessionId, String userId) {
        String sessionKey = this.uniqueSessionKey(sessionId, userId);
        Session cachedSession = this.sessions.get(sessionKey);
        if (cachedSession != null) {
            return cachedSession;
        }
        Session newSession = new Session(sessionId, null, 2, null);
        ((Map)this.sessions).put(sessionKey, newSession);
        return newSession;
    }

    private final String uniqueSessionKey(String sessionId, String userId) {
        return sessionId != null && !(((CharSequence)sessionId).length() == 0) ? sessionId : this.generalSessionKeyForUser(userId);
    }

    private final String generalSessionKeyForUser(String userId) {
        return "user:" + userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processPingbacksBatch() {
        ArrayList pingbacksBatchCopy = new ArrayList();
        Object object = this.pingbacksBatch;
        synchronized (object) {
            boolean $i$a$-synchronized-PingbackCollector$processPingbacksBatch$22 = false;
            pingbacksBatchCopy.addAll(this.pingbacksBatch);
            this.pingbacksBatch.clear();
            Unit $i$a$-synchronized-PingbackCollector$processPingbacksBatch$22 = Unit.INSTANCE;
        }
        for (PingbackWrapperRecycler.PingbackWrapper pingbackWrapper : pingbacksBatchCopy) {
            String string;
            String it;
            HashMap<String, String> attributes = new HashMap<String, String>();
            Session session = this.getSession(pingbackWrapper.getSessionId(), pingbackWrapper.getUserId());
            if (pingbackWrapper.getLayoutType() != null) {
                boolean bl = false;
                ((Map)attributes).put("layout_type", it);
            }
            if (pingbackWrapper.getPosition() >= 0) {
                Map map = attributes;
                string = "position";
                Intrinsics.checkNotNullExpressionValue((Object)Integer.toString(pingbackWrapper.getPosition()), (String)"toString(pingbackWrapper.position)");
                map.put(string, it);
            }
            if (pingbackWrapper.getPlacement() != null) {
                boolean bl = false;
                ((Map)attributes).put("placement", it);
            }
            session.getEvents().add(new AnalyticsEvent(pingbackWrapper.getAnalyticsResponsePayload(), pingbackWrapper.getEventType(), pingbackWrapper.getActionType(), pingbackWrapper.getMediaId(), pingbackWrapper.getTid(), pingbackWrapper.getTs(), attributes, pingbackWrapper.getUserId(), pingbackWrapper.getLoggedInUserId(), pingbackWrapper.getRandomId()));
            if (GiphyPingbacks.INSTANCE.getLogsEnabled()) {
                string = "Event added %s %s %s | %s %s %s %s | %s | %s %s %s";
                Object[] objectArray = new Object[]{pingbackWrapper.getActionType(), pingbackWrapper.getMediaId(), pingbackWrapper.getTs(), pingbackWrapper.getAnalyticsResponsePayload(), pingbackWrapper.getRandomId(), pingbackWrapper.getReferrer(), pingbackWrapper.getEventType(), pingbackWrapper.getSessionId(), pingbackWrapper.getLayoutType(), pingbackWrapper.getPosition(), pingbackWrapper.getPlacement()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                Log.d((String)"PINGBACK", (String)string2);
            }
            if (session.getEvents().size() < maximumPingbacksBeforeSubmitting) continue;
            this.submitReadySession(session);
        }
        object = this.eventWrapperRecycler;
        synchronized (object) {
            boolean bl = false;
            for (PingbackWrapperRecycler.PingbackWrapper eventWrapper : pingbacksBatchCopy) {
                Intrinsics.checkNotNullExpressionValue((Object)eventWrapper, (String)"eventWrapper");
                this.eventWrapperRecycler.recycleItem(eventWrapper);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void addPingbackRunnable$lambda$0(PingbackCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.processPingbacksBatch();
        this$0.scheduleSubmitAllSessions();
    }

    private static final void flush$lambda$3(PingbackCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.processPingbacksBatch();
        this$0.submitAllSessions();
        this$0.submissionQueue.flush();
    }

    private static final void scheduleSubmitAllSessions$lambda$4(PingbackCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.submitAllSessions();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/giphy/sdk/analytics/batching/PingbackCollector$Companion;", "", "()V", "addPingbackDelay", "", "getAddPingbackDelay", "()J", "setAddPingbackDelay", "(J)V", "isTestingEnvironment", "", "()Z", "setTestingEnvironment", "(Z)V", "maximumIdleTimeBeforeSubmitting", "getMaximumIdleTimeBeforeSubmitting", "setMaximumIdleTimeBeforeSubmitting", "maximumPingbacksBeforeSubmitting", "", "getMaximumPingbacksBeforeSubmitting", "()I", "setMaximumPingbacksBeforeSubmitting", "(I)V", "giphy-ui-2.3.17_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getAddPingbackDelay() {
            return addPingbackDelay;
        }

        public final void setAddPingbackDelay(long l) {
            addPingbackDelay = l;
        }

        public final long getMaximumIdleTimeBeforeSubmitting() {
            return maximumIdleTimeBeforeSubmitting;
        }

        public final void setMaximumIdleTimeBeforeSubmitting(long l) {
            maximumIdleTimeBeforeSubmitting = l;
        }

        public final int getMaximumPingbacksBeforeSubmitting() {
            return maximumPingbacksBeforeSubmitting;
        }

        public final void setMaximumPingbacksBeforeSubmitting(int n) {
            maximumPingbacksBeforeSubmitting = n;
        }

        public final boolean isTestingEnvironment() {
            return isTestingEnvironment;
        }

        public final void setTestingEnvironment(boolean bl) {
            isTestingEnvironment = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

