/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.hazelcast;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.TypeParser;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.hazelcast.DataStoreHazelcastProperties;
import com.hazelcast.core.HazelcastInstance;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;
import org.wicketstuff.datastores.hazelcast.HazelcastDataStore;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.datastore.hazelcast", value={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={HazelcastInstance.class})
@ConditionalOnClass(value={HazelcastInstance.class, HazelcastDataStore.class})
@EnableConfigurationProperties(value={DataStoreHazelcastProperties.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
public class DataStoreHazelcastConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DataStoreHazelcastProperties prop;
    @Autowired
    private HazelcastInstance hazelcastInstance;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication){

            protected IDataStore newDataStore() {
                HazelcastDataStore hazelcastDataStore = new HazelcastDataStore(DataStoreHazelcastConfig.this.hazelcastInstance);
                return new SessionQuotaManagingDataStore((IDataStore)hazelcastDataStore, TypeParser.parse((Long)DataStoreHazelcastConfig.this.prop.getSessionSize(), (SessionUnit)DataStoreHazelcastConfig.this.prop.getSessionUnit()));
            }
        });
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.prop).build());
    }
}

