/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.IntDef;
import android.util.AttributeSet;
import android.widget.ImageButton;
import android.widget.TextView;
import com.getbase.floatingactionbutton.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FloatingActionButton
extends ImageButton {
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_MINI = 1;
    private static final int HALF_TRANSPARENT_WHITE = Color.argb((int)128, (int)255, (int)255, (int)255);
    private static final int HALF_TRANSPARENT_BLACK = Color.argb((int)128, (int)0, (int)0, (int)0);
    int mColorNormal;
    int mColorPressed;
    String mTitle;
    private int mIcon;
    private int mSize;
    private float mCircleSize;
    private float mShadowRadius;
    private float mShadowOffset;
    private int mDrawableSize;

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    void init(Context context, AttributeSet attributeSet) {
        TypedArray attr = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionButton, 0, 0);
        this.mColorNormal = attr.getColor(1, this.getColor(17170451));
        this.mColorPressed = attr.getColor(0, this.getColor(17170450));
        this.mSize = attr.getInt(3, 0);
        this.mIcon = attr.getResourceId(2, 0);
        this.mTitle = attr.getString(4);
        attr.recycle();
        this.updateCircleSize();
        this.mShadowRadius = this.getDimension(R.dimen.fab_shadow_radius);
        this.mShadowOffset = this.getDimension(R.dimen.fab_shadow_offset);
        this.updateDrawableSize();
        this.updateBackground();
    }

    private void updateDrawableSize() {
        this.mDrawableSize = (int)(this.mCircleSize + 2.0f * this.mShadowRadius);
    }

    private void updateCircleSize() {
        this.mCircleSize = this.getDimension(this.mSize == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini);
    }

    public void setSize(int size) {
        if (size != 1 && size != 0) {
            throw new IllegalArgumentException("Use @FAB_SIZE constants only!");
        }
        if (this.mSize != size) {
            this.mSize = size;
            this.updateCircleSize();
            this.updateDrawableSize();
            this.updateBackground();
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public void setIcon(int icon) {
        if (this.mIcon != icon) {
            this.mIcon = icon;
            this.updateBackground();
        }
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorNormalResId(int colorNormal) {
        this.setColorNormal(this.getColor(colorNormal));
    }

    public void setColorNormal(int color) {
        if (this.mColorNormal != color) {
            this.mColorNormal = color;
            this.updateBackground();
        }
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorPressedResId(int colorPressed) {
        this.setColorPressed(this.getColor(colorPressed));
    }

    public void setColorPressed(int color) {
        if (this.mColorPressed != color) {
            this.mColorPressed = color;
            this.updateBackground();
        }
    }

    int getColor(int id2) {
        return this.getResources().getColor(id2);
    }

    float getDimension(int id2) {
        return this.getResources().getDimension(id2);
    }

    public void setTitle(String title) {
        this.mTitle = title;
        TextView label = (TextView)this.getTag(R.id.fab_label);
        if (label != null) {
            label.setText((CharSequence)title);
        }
    }

    public String getTitle() {
        return this.mTitle;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mDrawableSize, this.mDrawableSize);
    }

    void updateBackground() {
        float strokeWidth = this.getDimension(R.dimen.fab_stroke_width);
        float halfStrokeWidth = strokeWidth / 2.0f;
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.getResources().getDrawable(this.mSize == 0 ? R.drawable.fab_bg_normal : R.drawable.fab_bg_mini), this.createFillDrawable(), this.createOuterStrokeDrawable(strokeWidth), this.createInnerStrokesDrawable(strokeWidth), this.getIconDrawable()});
        int iconOffset = (int)(this.mCircleSize - this.getDimension(R.dimen.fab_icon_size)) / 2;
        int circleInsetHorizontal = (int)this.mShadowRadius;
        int circleInsetTop = (int)(this.mShadowRadius - this.mShadowOffset);
        int circleInsetBottom = (int)(this.mShadowRadius + this.mShadowOffset);
        layerDrawable.setLayerInset(1, circleInsetHorizontal, circleInsetTop, circleInsetHorizontal, circleInsetBottom);
        layerDrawable.setLayerInset(2, (int)((float)circleInsetHorizontal - halfStrokeWidth), (int)((float)circleInsetTop - halfStrokeWidth), (int)((float)circleInsetHorizontal - halfStrokeWidth), (int)((float)circleInsetBottom - halfStrokeWidth));
        layerDrawable.setLayerInset(3, (int)((float)circleInsetHorizontal + halfStrokeWidth), (int)((float)circleInsetTop + halfStrokeWidth), (int)((float)circleInsetHorizontal + halfStrokeWidth), (int)((float)circleInsetBottom + halfStrokeWidth));
        layerDrawable.setLayerInset(4, circleInsetHorizontal + iconOffset, circleInsetTop + iconOffset, circleInsetHorizontal + iconOffset, circleInsetBottom + iconOffset);
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    Drawable getIconDrawable() {
        if (this.mIcon != 0) {
            return this.getResources().getDrawable(this.mIcon);
        }
        return new ColorDrawable(0);
    }

    private StateListDrawable createFillDrawable() {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{16842919}, this.createCircleDrawable(this.mColorPressed));
        drawable2.addState(new int[0], this.createCircleDrawable(this.mColorNormal));
        return drawable2;
    }

    private Drawable createCircleDrawable(int color) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        Paint paint = shapeDrawable.getPaint();
        paint.setAntiAlias(true);
        paint.setColor(color);
        return shapeDrawable;
    }

    private Drawable createOuterStrokeDrawable(float strokeWidth) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        Paint paint = shapeDrawable.getPaint();
        paint.setAntiAlias(true);
        paint.setStrokeWidth(strokeWidth);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-16777216);
        paint.setAlpha(this.opacityToAlpha(0.02f));
        return shapeDrawable;
    }

    private int opacityToAlpha(float opacity) {
        return (int)(255.0f * opacity);
    }

    private Drawable createInnerStrokesDrawable(float strokeWidth) {
        ShapeDrawable innerBottom = new ShapeDrawable((Shape)new OvalShape());
        Paint bottomPaint = innerBottom.getPaint();
        bottomPaint.setAntiAlias(true);
        bottomPaint.setStrokeWidth(strokeWidth);
        bottomPaint.setStyle(Paint.Style.STROKE);
        bottomPaint.setAlpha(this.opacityToAlpha(0.04f));
        innerBottom.setShaderFactory(new ShapeDrawable.ShaderFactory(){

            public Shader resize(int width, int height) {
                return new LinearGradient((float)(width / 2), 0.0f, (float)(width / 2), (float)height, new int[]{0, HALF_TRANSPARENT_BLACK, -16777216}, new float[]{0.0f, 0.8f, 1.0f}, Shader.TileMode.CLAMP);
            }
        });
        ShapeDrawable innerTop = new ShapeDrawable((Shape)new OvalShape());
        Paint topPaint = innerTop.getPaint();
        topPaint.setAntiAlias(true);
        topPaint.setStrokeWidth(strokeWidth);
        topPaint.setStyle(Paint.Style.STROKE);
        topPaint.setAlpha(this.opacityToAlpha(0.8f));
        innerTop.setShaderFactory(new ShapeDrawable.ShaderFactory(){

            public Shader resize(int width, int height) {
                return new LinearGradient((float)(width / 2), 0.0f, (float)(width / 2), (float)height, new int[]{-1, HALF_TRANSPARENT_WHITE, 0}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP);
            }
        });
        return new LayerDrawable(new Drawable[]{innerBottom, innerTop});
    }

    @SuppressLint(value={"NewApi"})
    private void setBackgroundCompat(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    public static @interface FAB_SIZE {
    }
}

