/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.IntDef;
import android.util.AttributeSet;
import android.widget.ImageButton;
import com.getbase.floatingactionbutton.R;

public class FloatingActionButton
extends ImageButton {
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_MINI = 1;
    private static final int HALF_TRANSPARENT_WHITE = Color.argb((int)128, (int)255, (int)255, (int)255);
    private static final int HALF_TRANSPARENT_BLACK = Color.argb((int)128, (int)0, (int)0, (int)0);
    int mColorNormal;
    int mColorPressed;
    private int mIcon;
    private int mSize;
    private float mCircleSize;
    private float mShadowRadius;
    private float mShadowOffset;
    private int mDrawableSize;

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    void init(Context context, AttributeSet attributeSet) {
        this.mColorNormal = this.getColor(17170451);
        this.mColorPressed = this.getColor(17170450);
        this.mIcon = 0;
        this.mSize = 0;
        if (attributeSet != null) {
            this.initAttributes(context, attributeSet);
        }
        this.updateCircleSize();
        this.mShadowRadius = this.getDimension(R.dimen.fab_shadow_radius);
        this.mShadowOffset = this.getDimension(R.dimen.fab_shadow_offset);
        this.updateDrawableSize();
        this.updateBackground();
    }

    private void updateDrawableSize() {
        this.mDrawableSize = (int)(this.mCircleSize + 2.0f * this.mShadowRadius);
    }

    private void updateCircleSize() {
        this.mCircleSize = this.getDimension(this.mSize == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini);
    }

    public void setSize(@FAB_SIZE int size) {
        if (size != 1 && size != 0) {
            throw new IllegalArgumentException("Use @FAB_SIZE constants only!");
        }
        if (this.mSize != size) {
            this.mSize = size;
            this.updateCircleSize();
            this.updateDrawableSize();
            this.updateBackground();
        }
    }

    @FAB_SIZE
    public int getSize() {
        return this.mSize;
    }

    public void setIcon(int icon) {
        if (this.mIcon != icon) {
            this.mIcon = icon;
            this.updateBackground();
        }
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorNormalResId(int colorNormal) {
        this.setColorNormal(this.getColor(colorNormal));
    }

    public void setColorNormal(int color) {
        if (this.mColorNormal != color) {
            this.mColorNormal = color;
            this.updateBackground();
        }
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorPressedResId(int colorPressed) {
        this.setColorPressed(this.getColor(colorPressed));
    }

    public void setColorPressed(int color) {
        if (this.mColorPressed != color) {
            this.mColorPressed = color;
            this.updateBackground();
        }
    }

    int getColor(int id) {
        return this.getResources().getColor(id);
    }

    float getDimension(int id) {
        return this.getResources().getDimension(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attributeSet) {
        TypedArray attr = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionButton, 0, 0);
        if (attr != null) {
            try {
                this.mColorNormal = attr.getColor(1, this.getColor(17170451));
                this.mColorPressed = attr.getColor(0, this.getColor(17170450));
                this.mSize = attr.getInt(3, 0);
                this.mIcon = attr.getResourceId(2, 0);
            }
            finally {
                attr.recycle();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mDrawableSize, this.mDrawableSize);
    }

    void updateBackground() {
        float circleLeft = this.mShadowRadius;
        float circleTop = this.mShadowRadius - this.mShadowOffset;
        RectF circleRect = new RectF(circleLeft, circleTop, circleLeft + this.mCircleSize, circleTop + this.mCircleSize);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.getResources().getDrawable(this.mSize == 0 ? R.drawable.fab_bg_normal : R.drawable.fab_bg_mini), this.createFillDrawable(circleRect), this.createStrokesDrawable(circleRect), this.getIconDrawable()});
        float iconOffset = (this.mCircleSize - this.getDimension(R.dimen.fab_icon_size)) / 2.0f;
        int iconInsetHorizontal = (int)(this.mShadowRadius + iconOffset);
        int iconInsetTop = (int)(circleTop + iconOffset);
        int iconInsetBottom = (int)(this.mShadowRadius + this.mShadowOffset + iconOffset);
        layerDrawable.setLayerInset(3, iconInsetHorizontal, iconInsetTop, iconInsetHorizontal, iconInsetBottom);
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    Drawable getIconDrawable() {
        if (this.mIcon != 0) {
            return this.getResources().getDrawable(this.mIcon);
        }
        return new ColorDrawable(0);
    }

    private StateListDrawable createFillDrawable(RectF circleRect) {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{16842919}, this.createCircleDrawable(circleRect, this.mColorPressed));
        drawable2.addState(new int[0], this.createCircleDrawable(circleRect, this.mColorNormal));
        return drawable2;
    }

    private Drawable createCircleDrawable(RectF circleRect, int color) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.mDrawableSize, (int)this.mDrawableSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(color);
        canvas.drawOval(circleRect, paint);
        return new BitmapDrawable(this.getResources(), bitmap);
    }

    private int opacityToAlpha(float opacity) {
        return (int)(255.0f * opacity);
    }

    private Drawable createStrokesDrawable(RectF circleRect) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.mDrawableSize, (int)this.mDrawableSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        float strokeWidth = this.getDimension(R.dimen.fab_stroke_width);
        float halfStrokeWidth = strokeWidth / 2.0f;
        RectF outerStrokeRect = new RectF(circleRect.left - halfStrokeWidth, circleRect.top - halfStrokeWidth, circleRect.right + halfStrokeWidth, circleRect.bottom + halfStrokeWidth);
        RectF innerStrokeRect = new RectF(circleRect.left + halfStrokeWidth, circleRect.top + halfStrokeWidth, circleRect.right - halfStrokeWidth, circleRect.bottom - halfStrokeWidth);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setStrokeWidth(strokeWidth);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-16777216);
        paint.setAlpha(this.opacityToAlpha(0.02f));
        canvas.drawOval(outerStrokeRect, paint);
        paint.setShader((Shader)new LinearGradient(innerStrokeRect.centerX(), innerStrokeRect.top, innerStrokeRect.centerX(), innerStrokeRect.bottom, new int[]{0, HALF_TRANSPARENT_BLACK, -16777216}, new float[]{0.0f, 0.8f, 1.0f}, Shader.TileMode.CLAMP));
        paint.setAlpha(this.opacityToAlpha(0.04f));
        canvas.drawOval(innerStrokeRect, paint);
        paint.setShader((Shader)new LinearGradient(innerStrokeRect.centerX(), innerStrokeRect.top, innerStrokeRect.centerX(), innerStrokeRect.bottom, new int[]{-1, HALF_TRANSPARENT_WHITE, 0}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        paint.setAlpha(this.opacityToAlpha(0.8f));
        canvas.drawOval(innerStrokeRect, paint);
        return new BitmapDrawable(this.getResources(), bitmap);
    }

    @SuppressLint(value={"NewApi"})
    private void setBackgroundCompat(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    @IntDef(value={0L, 1L})
    public static @interface FAB_SIZE {
    }
}

