/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.floatingactionbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import com.getbase.floatingactionbutton.FloatingActionButton;
import com.getbase.floatingactionbutton.R;

public class AddFloatingActionButton
extends FloatingActionButton {
    int mPlusColor;

    public AddFloatingActionButton(Context context) {
        this(context, null);
    }

    public AddFloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AddFloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void init(Context context, AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray attr2 = context.obtainStyledAttributes(attributeSet, R.styleable.AddFloatingActionButton, 0, 0);
            if (attr2 != null) {
                try {
                    this.mPlusColor = attr2.getColor(0, this.getColor(17170443));
                }
                finally {
                    attr2.recycle();
                }
            }
        } else {
            this.mPlusColor = this.getColor(17170443);
        }
        super.init(context, attributeSet);
    }

    @Override
    Drawable getIconDrawable() {
        final float iconSize = this.getDimension(R.dimen.fab_icon_size);
        final float iconHalfSize = iconSize / 2.0f;
        float plusSize = this.getDimension(R.dimen.fab_plus_icon_size);
        final float plusHalfStroke = this.getDimension(R.dimen.fab_plus_icon_stroke) / 2.0f;
        final float plusOffset = (iconSize - plusSize) / 2.0f;
        Shape shape = new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                canvas.drawRect(plusOffset, iconHalfSize - plusHalfStroke, iconSize - plusOffset, iconHalfSize + plusHalfStroke, paint);
                canvas.drawRect(iconHalfSize - plusHalfStroke, plusOffset, iconHalfSize + plusHalfStroke, iconSize - plusOffset, paint);
            }
        };
        ShapeDrawable drawable2 = new ShapeDrawable(shape);
        Paint paint = drawable2.getPaint();
        paint.setColor(this.mPlusColor);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        return drawable2;
    }
}

