/*
 * Decompiled with CFR 0.152.
 */
package com.gabrielittner.auto.value.util;

import com.gabrielittner.auto.value.util.ElementUtil;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.TypeName;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class Property {
    private final String methodName;
    private final String humanName;
    private final ExecutableElement element;
    private final TypeName type;
    private final ImmutableSet<String> annotations;

    public static ImmutableList<Property> buildProperties(AutoValueExtension.Context context) {
        ImmutableList.Builder values = ImmutableList.builder();
        for (Map.Entry entry : context.properties().entrySet()) {
            values.add((Object)new Property((String)entry.getKey(), (ExecutableElement)entry.getValue()));
        }
        return values.build();
    }

    public Property(String humanName, ExecutableElement element) {
        this.methodName = element.getSimpleName().toString();
        this.humanName = humanName;
        this.element = element;
        this.type = TypeName.get((TypeMirror)element.getReturnType());
        this.annotations = ElementUtil.buildAnnotations(element);
    }

    public String methodName() {
        return this.methodName;
    }

    public String humanName() {
        return this.humanName;
    }

    public ExecutableElement element() {
        return this.element;
    }

    public TypeName type() {
        return this.type;
    }

    public Set<String> annotations() {
        return this.annotations;
    }

    public Boolean nullable() {
        return this.annotations.contains((Object)"Nullable");
    }
}

