/*
 * Decompiled with CFR 0.152.
 */
package com.gabrielittner.auto.value.util;

import com.gabrielittner.auto.value.util.Property;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class AutoValueUtil {
    public static ClassName getAutoValueClassClassName(AutoValueExtension.Context context) {
        return ClassName.get((TypeElement)context.autoValueClass());
    }

    private static String getFinalClassSimpleName(AutoValueExtension.Context context) {
        TypeElement autoValueClass = context.autoValueClass();
        String name = autoValueClass.getSimpleName().toString();
        Element enclosingElement = autoValueClass.getEnclosingElement();
        while (enclosingElement instanceof TypeElement) {
            name = enclosingElement.getSimpleName().toString() + "_" + name;
            enclosingElement = enclosingElement.getEnclosingElement();
        }
        return "AutoValue_" + name;
    }

    public static ClassName getFinalClassClassName(AutoValueExtension.Context context) {
        return ClassName.get((String)context.packageName(), (String)AutoValueUtil.getFinalClassSimpleName(context), (String[])new String[0]);
    }

    public static TypeSpec.Builder newTypeSpecBuilder(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        TypeVariableName[] typeVariables = AutoValueUtil.getTypeVariables(context.autoValueClass());
        return TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{isFinal ? Modifier.FINAL : Modifier.ABSTRACT}).addTypeVariables(Arrays.asList(typeVariables)).superclass(AutoValueUtil.getSuperClass(context.packageName(), classToExtend, (TypeName[])typeVariables)).addMethod(AutoValueUtil.newConstructor(context.properties()));
    }

    private static TypeVariableName[] getTypeVariables(TypeElement autoValueClass) {
        List<? extends TypeParameterElement> parameters = autoValueClass.getTypeParameters();
        TypeVariableName[] typeVariables = new TypeVariableName[parameters.size()];
        int length = typeVariables.length;
        for (int i = 0; i < length; ++i) {
            typeVariables[i] = TypeVariableName.get((TypeParameterElement)parameters.get(i));
        }
        return typeVariables;
    }

    private static TypeName getSuperClass(String packageName, String classToExtend, TypeName[] typeVariables) {
        ClassName superClassWithoutParameters = ClassName.get((String)packageName, (String)classToExtend, (String[])new String[0]);
        if (typeVariables.length > 0) {
            return ParameterizedTypeName.get((ClassName)superClassWithoutParameters, (TypeName[])typeVariables);
        }
        return superClassWithoutParameters;
    }

    private static MethodSpec newConstructor(Map<String, ExecutableElement> properties) {
        ArrayList params = Lists.newArrayList();
        for (Map.Entry<String, ExecutableElement> entry : properties.entrySet()) {
            TypeName typeName = TypeName.get((TypeMirror)entry.getValue().getReturnType());
            params.add(ParameterSpec.builder((TypeName)typeName, (String)entry.getKey(), (Modifier[])new Modifier[0]).build());
        }
        CodeBlock code = AutoValueUtil.newConstructorCall(CodeBlock.of((String)"super", (Object[])new Object[0]), properties.keySet().toArray());
        return MethodSpec.constructorBuilder().addParameters((Iterable)params).addCode(code).build();
    }

    public static CodeBlock newFinalClassConstructorCall(AutoValueExtension.Context context, Object[] properties) {
        CodeBlock constructorName = CodeBlock.of((String)"new $T", (Object[])new Object[]{AutoValueUtil.getFinalClassClassName(context)});
        return AutoValueUtil.newConstructorCall(constructorName, properties);
    }

    private static CodeBlock newConstructorCall(CodeBlock constructorName, Object[] properties) {
        StringBuilder params = new StringBuilder("(");
        for (int i = properties.length; i > 0; --i) {
            params.append("$N");
            if (i <= 1) continue;
            params.append(", ");
        }
        params.append(")");
        return CodeBlock.builder().add(constructorName).addStatement(params.toString(), properties).build();
    }

    public static void error(AutoValueExtension.Context context, Property property, String message) {
        context.processingEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message, property.element());
    }

    public static void error(AutoValueExtension.Context context, Property property, String message, Object ... args) {
        AutoValueUtil.error(context, property, String.format(message, args));
    }

    private AutoValueUtil() {
        throw new AssertionError((Object)"No instances.");
    }
}

