/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.restapi.services;

import com.foilen.smalltools.restapi.model.FormResult;
import com.foilen.smalltools.tools.CollectionsTools;
import com.foilen.smalltools.tools.DateTools;
import com.foilen.smalltools.tools.StringTools;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.regex.Pattern;

public class FormValidationTools {
    private static final Pattern alphaNum = Pattern.compile("[A-Za-z0-9]*");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9_!#$%&'*+/=?`{|}~^.-]+@[a-zA-Z0-9.-]+$");

    public static void validateAlphaNum(FormResult formResult, String fieldName, String fieldValue) {
        if (Strings.isNullOrEmpty((String)fieldValue)) {
            return;
        }
        if (!alphaNum.matcher(fieldValue).matches()) {
            CollectionsTools.getOrCreateEmptyArrayList(formResult.getValidationErrorsByField(), (Object)fieldName, String.class).add("Format is alphanumeric");
        }
    }

    public static void validateAtLeastOneManadatory(FormResult formResult, String[] fieldNames, String[] fieldValues) {
        for (String fieldValue : fieldValues) {
            if (Strings.isNullOrEmpty((String)fieldValue)) continue;
            return;
        }
        for (String fieldName : fieldNames) {
            CollectionsTools.getOrCreateEmptyArrayList(formResult.getValidationErrorsByField(), (Object)fieldName, String.class).add("At least one value must be entered");
        }
    }

    public static void validateDateOnly(FormResult formResult, String fieldName, String date) {
        if (Strings.isNullOrEmpty((String)date)) {
            return;
        }
        boolean goodFormat = false;
        try {
            String expectedDate = DateTools.formatDateOnly((Date)DateTools.parseDateOnly((String)date));
            goodFormat = StringTools.safeEquals((String)expectedDate, (String)date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!goodFormat) {
            CollectionsTools.getOrCreateEmptyArrayList(formResult.getValidationErrorsByField(), (Object)fieldName, String.class).add("Format is yyyy-MM-dd");
        }
    }

    public static void validateEmail(FormResult formResult, String fieldName, String fieldValue) {
        if (Strings.isNullOrEmpty((String)fieldValue)) {
            return;
        }
        if (!EMAIL_PATTERN.matcher(fieldValue).matches()) {
            CollectionsTools.getOrCreateEmptyArrayList(formResult.getValidationErrorsByField(), (Object)fieldName, String.class).add("Is not an email");
        }
    }

    public static void validateMandatory(FormResult formResult, String fieldName, String fieldValue) {
        if (Strings.isNullOrEmpty((String)fieldValue)) {
            CollectionsTools.getOrCreateEmptyArrayList(formResult.getValidationErrorsByField(), (Object)fieldName, String.class).add("The value is mandatory");
        }
    }
}

