/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.restapi.model;

import com.foilen.smalltools.restapi.model.AbstractApiBase;
import org.springframework.data.domain.Page;

public class ApiPagination
extends AbstractApiBase {
    private long currentPage;
    private long totalPages;
    private long itemsPerPage;
    private long totalItems;

    public ApiPagination() {
    }

    public ApiPagination(long currentPage, long totalPages, long itemsPerPage, long totalItems) {
        this.currentPage = currentPage;
        this.totalPages = totalPages;
        this.itemsPerPage = itemsPerPage;
        this.totalItems = totalItems;
    }

    public ApiPagination(Page<?> page) {
        this.currentPage = page.getNumber();
        this.totalPages = page.getTotalPages();
        this.setItemsPerPage(page.getSize());
        this.totalItems = page.getTotalElements();
    }

    public long getCurrentPage() {
        return this.currentPage;
    }

    public long getCurrentPageUi() {
        return this.currentPage + 1L;
    }

    public long getItemsPerPage() {
        return this.itemsPerPage;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public boolean isFirstPage() {
        return this.currentPage == 0L;
    }

    public boolean isLastPage() {
        return this.currentPage >= this.totalPages - 1L;
    }

    public ApiPagination setCurrentPage(long currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    public ApiPagination setCurrentPageUi(long currentPageUi) {
        this.currentPage = currentPageUi - 1L;
        return this;
    }

    public ApiPagination setItemsPerPage(long itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        return this;
    }

    public ApiPagination setTotalItems(long totalItems) {
        this.totalItems = totalItems;
        return this;
    }

    public ApiPagination setTotalPages(long totalPages) {
        this.totalPages = totalPages;
        if (this.totalPages == 0L) {
            this.totalPages = 1L;
        }
        return this;
    }
}

