/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.restapi.exception;

import com.foilen.smalltools.restapi.exception.ApiException;
import com.foilen.smalltools.restapi.model.AbstractApiBaseWithError;
import com.foilen.smalltools.restapi.model.FormResult;
import com.foilen.smalltools.tools.CollectionsTools;

public class ApiExceptionTools {
    public static void throwIfFailure(String context, AbstractApiBaseWithError result) {
        if (result == null) {
            throw new ApiException(context + " : The response is null");
        }
        if (!result.isSuccess()) {
            throw new ApiException(context + " : " + String.valueOf((Object)result.getError()));
        }
    }

    public static void throwIfFailure(String context, FormResult result) {
        if (result == null) {
            throw new ApiException(context + " : The response is null");
        }
        if (!result.isSuccess()) {
            StringBuilder message = new StringBuilder();
            if (result.getError() != null) {
                message.append(" error: ").append((Object)result.getError());
            }
            if (!CollectionsTools.isNullOrEmpty(result.getGlobalErrors())) {
                message.append(" global errors: ").append(result.getGlobalErrors());
            }
            if (result.getValidationErrorsByField() != null && !result.getValidationErrorsByField().isEmpty()) {
                message.append(" validation errors: ").append(result.getValidationErrorsByField());
            }
            throw new ApiException(context + " :" + message.toString());
        }
    }
}

