/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.email;

import com.foilen.smalltools.email.EmailAttachment;
import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.FreemarkerTools;
import com.foilen.smalltools.tools.ResourceTools;
import com.foilen.smalltools.tools.StreamsTools;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;

public class EmailBuilder {
    private String from;
    private String replyTo;
    private final List<String> tos = new ArrayList<String>();
    private final List<String> ccs = new ArrayList<String>();
    private final List<String> bccs = new ArrayList<String>();
    private String subject;
    private boolean isHtml;
    private String body;
    private final List<EmailAttachment> inlineAttachments = new ArrayList<EmailAttachment>();
    private final List<EmailAttachment> attachments = new ArrayList<EmailAttachment>();

    public EmailBuilder addAttachmentFromFile(String attachmentFilename, String fileName) {
        this.attachments.add(new EmailAttachment(attachmentFilename, new FileSystemResource(fileName)));
        return this;
    }

    public EmailBuilder addAttachmentFromResource(String attachmentFilename, String resource) {
        this.attachments.add(new EmailAttachment(attachmentFilename, new ClassPathResource(resource)));
        return this;
    }

    public EmailBuilder addAttachmentFromStream(String attachmentFilename, InputStream inputStream) {
        this.attachments.add(new EmailAttachment(attachmentFilename, new ByteArrayResource(StreamsTools.consumeAsBytes((InputStream)inputStream))));
        return this;
    }

    public EmailBuilder addBcc(String bcc) {
        this.bccs.add(bcc);
        return this;
    }

    public EmailBuilder addCc(String cc) {
        this.ccs.add(cc);
        return this;
    }

    public EmailBuilder addInlineAttachmentFromFile(String contentId, String fileName) {
        this.inlineAttachments.add(new EmailAttachment(contentId, new FileSystemResource(fileName)));
        return this;
    }

    public EmailBuilder addInlineAttachmentFromResource(String contentId, String resource) {
        this.inlineAttachments.add(new EmailAttachment(contentId, new ClassPathResource(resource)));
        return this;
    }

    public EmailBuilder addInlineAttachmentFromStream(String contentId, InputStream inputStream) {
        this.inlineAttachments.add(new EmailAttachment(contentId, new ByteArrayResource(StreamsTools.consumeAsBytes((InputStream)inputStream))));
        return this;
    }

    public EmailBuilder addTo(String to) {
        this.tos.add(to);
        return this;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public List<String> getBccs() {
        return this.bccs;
    }

    public String getBody() {
        return this.body;
    }

    public List<String> getCcs() {
        return this.ccs;
    }

    public String getFrom() {
        return this.from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public EmailBuilder setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public List<EmailAttachment> getInlineAttachments() {
        return this.inlineAttachments;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getTos() {
        return this.tos;
    }

    public boolean isHtml() {
        return this.isHtml;
    }

    public EmailBuilder setBodyHtmlFromFile(String filename) {
        try {
            return this.setBodyHtmlFromString(StreamsTools.consumeAsString((InputStream)new FileInputStream(filename)));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException((Throwable)e);
        }
    }

    public EmailBuilder setBodyHtmlFromFreemarker(String resource, Map<String, ?> model) {
        return this.setBodyHtmlFromString(FreemarkerTools.processTemplate((String)resource, model));
    }

    public EmailBuilder setBodyHtmlFromResource(String resource) {
        return this.setBodyHtmlFromString(ResourceTools.getResourceAsString((String)resource, this.getClass()));
    }

    public EmailBuilder setBodyHtmlFromResource(String resource, Class<?> context) {
        return this.setBodyHtmlFromString(ResourceTools.getResourceAsString((String)resource, context));
    }

    public EmailBuilder setBodyHtmlFromString(String body) {
        this.isHtml = true;
        this.body = body;
        return this;
    }

    public EmailBuilder setBodyTextFromFile(String filename) {
        try {
            return this.setBodyTextFromString(StreamsTools.consumeAsString((InputStream)new FileInputStream(filename)));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException((Throwable)e);
        }
    }

    public EmailBuilder setBodyTextFromFreemarker(String resource, Map<String, ?> model) {
        return this.setBodyTextFromString(FreemarkerTools.processTemplate((String)resource, model));
    }

    public EmailBuilder setBodyTextFromResource(String resource) {
        return this.setBodyTextFromString(ResourceTools.getResourceAsString((String)resource, this.getClass()));
    }

    public EmailBuilder setBodyTextFromResource(String resource, Class<?> context) {
        return this.setBodyTextFromString(ResourceTools.getResourceAsString((String)resource, context));
    }

    public EmailBuilder setBodyTextFromString(String body) {
        this.isHtml = false;
        this.body = body;
        return this;
    }

    public EmailBuilder setFrom(String from) {
        this.from = from;
        return this;
    }

    public EmailBuilder setSubject(String subject) {
        this.subject = subject;
        return this;
    }
}

