/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.upgrader.trackers;

import com.foilen.smalltools.tools.AbstractBasics;
import com.foilen.smalltools.tools.BufferBatchesTools;
import com.foilen.smalltools.tools.ResourceTools;
import com.foilen.smalltools.tools.StreamTools;
import com.foilen.smalltools.tools.StringTools;
import com.foilen.smalltools.tuple.Tuple2;
import com.foilen.smalltools.upgrader.tasks.UpgradeTask;
import com.mongodb.MongoCommandException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Sorts;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoOperations;

public abstract class AbstractMongoUpgradeTask
extends AbstractBasics
implements UpgradeTask {
    @Autowired
    protected MongoClient mongoClient;
    @Autowired
    protected MongoOperations mongoOperations;
    @Value(value="${spring.mongodb.database}")
    protected String databaseName;

    protected void addCollection(String collectionName) {
        block2: {
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            this.logger.info("Create collection {}", (Object)collectionName);
            try {
                mongoDatabase.createCollection(collectionName);
            }
            catch (MongoCommandException e) {
                if (e.getErrorCode() == 48) break block2;
                throw e;
            }
        }
    }

    protected void addCollection(String collectionName, CreateCollectionOptions createCollectionOptions) {
        block2: {
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            this.logger.info("Create collection {} with options {}", (Object)collectionName, (Object)createCollectionOptions);
            try {
                mongoDatabase.createCollection(collectionName, createCollectionOptions);
            }
            catch (MongoCommandException e) {
                if (e.getErrorCode() == 48) break block2;
                throw e;
            }
        }
    }

    @SafeVarargs
    protected final void addIndex(String collectionName, IndexOptions indexOptions, Tuple2<String, Object> ... keys) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        this.logger.info("Create index for collection {} , with keys {}", (Object)collectionName, keys);
        MongoCollection collection = mongoDatabase.getCollection(collectionName);
        Document keysDocument = new Document();
        for (Tuple2<String, Object> key : keys) {
            keysDocument.put((String)key.getA(), key.getB());
        }
        collection.createIndex((Bson)keysDocument, indexOptions);
    }

    @SafeVarargs
    protected final void addIndex(String collectionName, Tuple2<String, Object> ... keys) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        this.logger.info("Create index for collection {} , with keys {}", (Object)collectionName, keys);
        MongoCollection collection = mongoDatabase.getCollection(collectionName);
        Document keysDocument = new Document();
        for (Tuple2<String, Object> key : keys) {
            keysDocument.put((String)key.getA(), key.getB());
        }
        collection.createIndex((Bson)keysDocument);
    }

    protected void addView(String viewName, String viewOn, List<? extends Bson> pipeline) {
        block2: {
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            this.logger.info("Create view {}", (Object)viewName);
            try {
                mongoDatabase.createView(viewName, viewOn, pipeline);
            }
            catch (MongoCommandException e) {
                if (e.getErrorCode() == 48) break block2;
                throw e;
            }
        }
    }

    protected void insertInCollection(String collectionName, String resourceName, Class<?> resourceClass) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        this.logger.info("Insert in collection {}", (Object)collectionName);
        MongoCollection collection = mongoDatabase.getCollection(collectionName);
        BufferBatchesTools.autoClose((int)100, arg_0 -> ((MongoCollection)collection).insertMany(arg_0), documents -> ResourceTools.readResourceLinesIteration((String)resourceName, (Class)resourceClass).forEach(line -> {
            this.logger.info("Batching line {}", line);
            Document document = Document.parse((String)line);
            documents.add((Object)document);
        }));
    }

    protected void insertOrUpdateInCollection(String collectionName, String resourceName, Class<?> resourceClass) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        this.logger.info("Insert or update in collection {}", (Object)collectionName);
        MongoCollection collection = mongoDatabase.getCollection(collectionName);
        ResourceTools.readResourceLinesIteration((String)resourceName, resourceClass).forEach(line -> {
            this.logger.info("Line {}", line);
            Document document = Document.parse((String)line);
            if (collection.find(Filters.eq((String)"_id", (Object)document.get((Object)"_id"))).first() == null) {
                this.logger.info("Inserting {}", line);
                collection.insertOne((Object)document);
            } else {
                this.logger.info("Updating {}", line);
                collection.replaceOne(Filters.eq((String)"_id", (Object)document.get((Object)"_id")), (Object)document);
            }
        });
    }

    protected void exportAllCollections(String fileNamePrefix) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        try (PrintWriter insertsFile = new PrintWriter(fileNamePrefix + "_inserts.txt", StandardCharsets.UTF_8);){
            StreamTools.toStream((Spliterator)mongoDatabase.listCollectionNames().spliterator()).filter(collectionName -> !collectionName.startsWith("system.") && !StringTools.safeEquals((String)collectionName, (String)"upgraderTools")).sorted().forEach(collectionName -> {
                this.exportFromCollection(fileNamePrefix + "_" + collectionName + ".json", (String)collectionName, (Bson)new Document(), findIterable -> findIterable.sort(Sorts.ascending((String[])new String[]{"_id"})));
                insertsFile.println("insertInCollection(\"" + collectionName + "\", \"" + fileNamePrefix + "_" + collectionName + ".json\", getClass());");
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Problem exporting inserts", e);
        }
    }

    protected void exportFromCollection(String fileName, String collectionName, Bson filter, Consumer<FindIterable<Document>> findConsumer) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        this.logger.info("Export from collection {} to file {}", (Object)collectionName, (Object)fileName);
        MongoCollection collection = mongoDatabase.getCollection(collectionName);
        FindIterable findIterator = collection.find(filter);
        findConsumer.accept((FindIterable<Document>)findIterator);
        try (PrintWriter out = new PrintWriter(fileName, StandardCharsets.UTF_8);){
            findIterator.forEach(document -> {
                String line = document.toJson();
                this.logger.info("Exporting {}", (Object)line);
                out.println(line);
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Problem exporting", e);
        }
    }

    protected void exportSchema(String fileName) {
        try (PrintWriter out = new PrintWriter(fileName, StandardCharsets.UTF_8);){
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            StreamTools.toStream((Spliterator)mongoDatabase.listCollections().spliterator()).sorted(Comparator.comparing(a -> a.get((Object)"name").toString())).forEach(collection -> {
                this.logger.info("Exporting schema for {}", collection);
                String name = collection.getString((Object)"name");
                if (name.startsWith("system.") || StringTools.safeEquals((String)name, (String)"upgraderTools")) {
                    this.logger.info("Skipping {}", (Object)name);
                    return;
                }
                String type = collection.getString((Object)"type");
                Document options = (Document)collection.get((Object)"options", Document.class);
                switch (type) {
                    case "collection": {
                        if (options.isEmpty()) {
                            out.println("addCollection(\"" + name + "\");");
                        } else {
                            ArrayList<Object> collectionOptions = new ArrayList<Object>();
                            if (options.getBoolean((Object)"capped").booleanValue()) {
                                collectionOptions.add(".capped(true)");
                            }
                            if (options.containsKey((Object)"max")) {
                                collectionOptions.add(".maxDocuments(" + String.valueOf(options.get((Object)"max")) + ")");
                            }
                            if (options.containsKey((Object)"size")) {
                                collectionOptions.add(".sizeInBytes(" + String.valueOf(options.get((Object)"size")) + ")");
                            }
                            out.println("addCollection(\"" + name + "\", new CreateCollectionOptions()" + String.join((CharSequence)"", collectionOptions) + ");");
                        }
                        ListIndexesIterable indexes = mongoDatabase.getCollection(name).listIndexes();
                        for (Document index : indexes) {
                            this.logger.info("Collection {} has index {}", (Object)name, (Object)index);
                            if (StringTools.safeEquals((String)"_id_", (String)index.getString((Object)"name"))) {
                                this.logger.info("Skipping index {}", (Object)index);
                                continue;
                            }
                            Document keys = (Document)index.get((Object)"key", Document.class);
                            ArrayList<Object> indexOptionsList = new ArrayList<Object>();
                            if (index.containsKey((Object)"2dsphereIndexVersion")) {
                                indexOptionsList.add(".sphereVersion(" + String.valueOf(index.get((Object)"2dsphereIndexVersion")) + ")");
                            }
                            if (index.containsKey((Object)"background")) {
                                indexOptionsList.add(".background(true)");
                            }
                            if (index.containsKey((Object)"bits")) {
                                indexOptionsList.add(".bits(" + String.valueOf(index.get((Object)"bits")) + ")");
                            }
                            if (index.containsKey((Object)"bucketSize")) {
                                indexOptionsList.add(".bucketSize(" + String.valueOf(index.get((Object)"bucketSize")) + ")");
                            }
                            if (index.containsKey((Object)"default_language")) {
                                indexOptionsList.add(".defaultLanguage(\"" + String.valueOf(index.get((Object)"default_language")) + "\")");
                            }
                            if (index.containsKey((Object)"dropDups")) {
                                indexOptionsList.add(".dropDups(true)");
                            }
                            if (index.containsKey((Object)"name")) {
                                indexOptionsList.add(".name(\"" + String.valueOf(index.get((Object)"name")) + "\")");
                            }
                            if (index.containsKey((Object)"expireAfterSeconds")) {
                                indexOptionsList.add(".expireAfter(" + String.valueOf(index.get((Object)"expireAfterSeconds")) + ", TimeUnit.SECONDS)");
                            }
                            if (index.containsKey((Object)"collation")) {
                                indexOptionsList.add(".collation(" + this.outputNewDocument((Document)index.get((Object)"collation", Document.class)) + ")");
                            }
                            if (index.containsKey((Object)"language_override")) {
                                indexOptionsList.add(".languageOverride(\"" + String.valueOf(index.get((Object)"language_override")) + "\")");
                            }
                            if (index.containsKey((Object)"min")) {
                                indexOptionsList.add(".min(" + String.valueOf(index.get((Object)"min")) + ")");
                            }
                            if (index.containsKey((Object)"max")) {
                                indexOptionsList.add(".max(" + String.valueOf(index.get((Object)"max")) + ")");
                            }
                            if (index.containsKey((Object)"partialFilterExpression")) {
                                indexOptionsList.add(".partialFilterExpression(" + this.outputNewDocument((Document)index.get((Object)"partialFilterExpression", Document.class)) + ")");
                            }
                            if (index.containsKey((Object)"sparse")) {
                                indexOptionsList.add(".sparse(true)");
                            }
                            if (index.containsKey((Object)"storageEngine")) {
                                indexOptionsList.add(".storageEngine(" + this.outputNewDocument((Document)index.get((Object)"storageEngine", Document.class)) + ")");
                            }
                            if (index.containsKey((Object)"textIndexVersion")) {
                                indexOptionsList.add(".textVersion(" + String.valueOf(index.get((Object)"textIndexVersion")) + ")");
                            }
                            if (index.containsKey((Object)"unique")) {
                                indexOptionsList.add(".unique(true)");
                            }
                            if (index.containsKey((Object)"weights")) {
                                indexOptionsList.add(".weights(" + this.outputNewDocument((Document)index.get((Object)"weights", Document.class)) + ")");
                            }
                            ArrayList keyTuples = new ArrayList();
                            keys.forEach((key, value) -> keyTuples.add("  new Tuple2<>(\"" + key + "\", " + String.valueOf(value) + ")"));
                            out.println("addIndex(\"" + name + "\",\n  new IndexOptions()" + String.join((CharSequence)"", indexOptionsList) + ",\n" + String.join((CharSequence)",\n", keyTuples) + "\n);");
                        }
                        break;
                    }
                    case "view": {
                        String viewOn = options.getString((Object)"viewOn");
                        out.println("addView(\"" + name + "\", \"" + viewOn + "\",");
                        out.println("  List.of(");
                        List pipeline = options.getList((Object)"pipeline", Document.class);
                        for (int i = 0; i < pipeline.size(); ++i) {
                            Document document = (Document)pipeline.get(i);
                            out.println("    " + this.outputNewDocument(document) + (i == pipeline.size() - 1 ? "" : ","));
                        }
                        out.println("  )");
                        out.println(");");
                    }
                }
                out.println();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Problem exporting", e);
        }
    }

    private String outputNewDocument(Document document) {
        StringBuilder sb = new StringBuilder();
        ArrayList parts = new ArrayList();
        document.forEach((key, value) -> {
            if (value instanceof String) {
                parts.add("\"" + key + "\", \"" + String.valueOf(value) + "\"");
            } else if (value instanceof Document) {
                Document subDocument = (Document)value;
                parts.add("\"" + key + "\", " + this.outputNewDocument(subDocument));
            } else {
                parts.add("\"" + key + "\", " + String.valueOf(value));
            }
        });
        sb.append("new Document(");
        sb.append((String)parts.getFirst());
        if (parts.size() > 1) {
            this.logger.warn("More than one part is not supported for {}", (Object)document);
        }
        sb.append(")");
        return sb.toString();
    }

    protected void dropCollection(String collectionName) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        this.logger.info("Drop collection {}", (Object)collectionName);
        MongoCollection collection = mongoDatabase.getCollection(collectionName);
        collection.drop();
    }

    protected void dropIndex(String collectionName, String indexName) {
        block2: {
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            this.logger.info("Drop index {} from collection {}", (Object)indexName, (Object)collectionName);
            MongoCollection collection = mongoDatabase.getCollection(collectionName);
            try {
                collection.dropIndex(indexName);
            }
            catch (MongoCommandException e) {
                if (e.getErrorCode() == 27) break block2;
                throw e;
            }
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public String useTracker() {
        return "mongodb";
    }
}

