/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.mongodb.spring.cache;

import com.foilen.smalltools.mongodb.distributed.MongoDbReentrantLock;
import com.foilen.smalltools.mongodb.distributed.MongoDbSortedMapStringObject;
import com.foilen.smalltools.mongodb.spring.cache.internal.ValueAndType;
import com.foilen.smalltools.tools.ExecutorsTools;
import com.foilen.smalltools.tools.JsonTools;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.bson.Document;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class MongoDbCache
implements Cache {
    private final String cacheName;
    private final MongoDbSortedMapStringObject<ValueAndType> sortedMap;
    private final MongoDbReentrantLock lock;

    public MongoDbCache(String cacheName, MongoClient mongoClient, MongoCollection<Document> mongoCollection, MongoDbReentrantLock lock, long maxDurationInSec) {
        this.cacheName = cacheName;
        this.lock = lock;
        this.sortedMap = new MongoDbSortedMapStringObject(ValueAndType.class, mongoClient, mongoCollection, Long.valueOf(maxDurationInSec));
    }

    public String getName() {
        return this.cacheName;
    }

    public Object getNativeCache() {
        return this.sortedMap;
    }

    public Cache.ValueWrapper get(Object key) {
        ValueAndType valueAndType = (ValueAndType)((Object)this.sortedMap.get((Object)key.toString()));
        if (valueAndType == null) {
            return null;
        }
        return new SimpleValueWrapper(valueAndType.toValue());
    }

    public <T> T get(Object key, Class<T> type) {
        ValueAndType valueAndType = (ValueAndType)((Object)this.sortedMap.get((Object)key.toString()));
        if (valueAndType == null) {
            return null;
        }
        return (T)JsonTools.readFromString((String)valueAndType.getJsonValue(), type);
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        ValueAndType valueAndType = (ValueAndType)((Object)this.sortedMap.get((Object)key.toString()));
        if (valueAndType == null) {
            if (this.lock == null) {
                T value = null;
                try {
                    value = valueLoader.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.put(key, value);
                return value;
            }
            String lockName = this.cacheName + "-" + String.valueOf(key);
            try {
                this.lock.lock(lockName);
                valueAndType = (ValueAndType)((Object)this.sortedMap.get((Object)key.toString()));
                if (valueAndType == null) {
                    T value = valueLoader.call();
                    this.put(key, value);
                    T t = value;
                    return t;
                }
                Object value = valueAndType.toValue();
                return (T)value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock(lockName);
            }
        }
        return (T)valueAndType.toValue();
    }

    public void put(Object key, Object value) {
        if (value == null) {
            this.sortedMap.put(key.toString(), (Object)new ValueAndType().setJsonValue(JsonTools.compactPrint((Object)value)));
        } else {
            this.sortedMap.put(key.toString(), (Object)new ValueAndType().setJsonValue(JsonTools.compactPrint((Object)value)).setType(value.getClass().getName()));
        }
    }

    public void evict(Object key) {
        this.sortedMap.remove((Object)key.toString());
    }

    public void clear() {
        this.sortedMap.clear();
    }

    public CompletableFuture<?> retrieve(Object key) {
        CompletableFuture completableFuture = new CompletableFuture();
        ExecutorsTools.getCachedDaemonThreadPool().execute(() -> {
            Cache.ValueWrapper valueWrapper = this.get(key);
            completableFuture.complete(valueWrapper);
        });
        return completableFuture;
    }

    public <T> CompletableFuture<T> retrieve(Object key, Supplier<CompletableFuture<T>> valueLoader) {
        CompletableFuture completableFuture = new CompletableFuture();
        ExecutorsTools.getCachedDaemonThreadPool().execute(() -> {
            Object value = this.get(key, () -> MongoDbCache.lambda$retrieve$1((Supplier)valueLoader));
            completableFuture.complete(value);
        });
        return completableFuture;
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        ValueAndType previous = (ValueAndType)((Object)this.sortedMap.putIfAbsent((Object)key.toString(), (Object)new ValueAndType().setJsonValue(JsonTools.compactPrint((Object)value)).setType(value.getClass().getName())));
        if (previous == null) {
            return new SimpleValueWrapper(value);
        }
        return new SimpleValueWrapper(previous.toValue());
    }

    public boolean evictIfPresent(Object key) {
        return this.sortedMap.remove((Object)key.toString()) != null;
    }

    public boolean invalidate() {
        return this.sortedMap.clearAndTellIfWasEmpty();
    }

    private static /* synthetic */ Object lambda$retrieve$1(Supplier valueLoader) throws Exception {
        return ((CompletableFuture)valueLoader.get()).join();
    }
}

