/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.upgrader.trackers;

import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.tools.JsonTools;
import com.foilen.smalltools.upgrader.trackers.UpgraderTracker;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class JsonFileUpgraderTracker
implements UpgraderTracker {
    private String fileName;
    private Set<String> successfulTasks = new HashSet<String>();

    public JsonFileUpgraderTracker(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void executionBegin(String taskSimpleName) {
    }

    @Override
    public void executionEnd(String taskSimpleName, boolean isSuccessful) {
        if (isSuccessful) {
            this.successfulTasks.add(taskSimpleName);
            this.save();
        }
    }

    private void save() {
        String tmpFile = this.fileName + ".tmp";
        JsonTools.writeToFile(tmpFile, this.successfulTasks);
        AssertTools.assertTrue(new File(tmpFile).renameTo(new File(this.fileName)), "Could not move the temporary file");
    }

    @Override
    public void trackerBegin() {
        if (!FileTools.exists(this.fileName)) {
            this.save();
        }
        this.successfulTasks = JsonTools.readFromFile(this.fileName, Set.class);
    }

    @Override
    public void trackerEnd() {
        this.save();
    }

    @Override
    public boolean wasExecutedSuccessfully(String taskSimpleName) {
        return this.successfulTasks.contains(taskSimpleName);
    }
}

