/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.trigger;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.trigger.SmoothTriggerRunnable;

public class SmoothTrigger {
    private long delayAfterLastTriggerMs;
    private long maxDelayAfterFirstRequestMs;
    private boolean isFirstPassThrough;
    private Runnable action;
    private Object internalUpdateLock = new Object();
    private SmoothTriggerRunnable smoothTriggerRunnable;
    private Thread smoothTriggerThread;

    public SmoothTrigger(long delayAfterLastTriggerMs, long maxDelayAfterFirstRequestMs, boolean isFirstPassThrough, Runnable action) {
        this.delayAfterLastTriggerMs = delayAfterLastTriggerMs;
        this.maxDelayAfterFirstRequestMs = maxDelayAfterFirstRequestMs;
        this.isFirstPassThrough = isFirstPassThrough;
        this.action = action;
    }

    public SmoothTrigger(Runnable action) {
        this.delayAfterLastTriggerMs = 1000L;
        this.maxDelayAfterFirstRequestMs = 10000L;
        this.isFirstPassThrough = false;
        this.action = action;
    }

    public void cancelPending() {
        AssertTools.assertNotNull(this.smoothTriggerRunnable, "Not running");
        this.smoothTriggerRunnable.cancelPending();
        this.smoothTriggerThread.interrupt();
    }

    public Runnable getAction() {
        return this.action;
    }

    public long getDelayAfterLastTriggerMs() {
        return this.delayAfterLastTriggerMs;
    }

    public long getMaxDelayAfterFirstRequestMs() {
        return this.maxDelayAfterFirstRequestMs;
    }

    public boolean isFirstPassThrough() {
        return this.isFirstPassThrough;
    }

    public void request() {
        AssertTools.assertNotNull(this.smoothTriggerRunnable, "Not running");
        this.smoothTriggerRunnable.request();
        this.smoothTriggerThread.interrupt();
    }

    public SmoothTrigger setAction(Runnable action) {
        AssertTools.assertNull(this.smoothTriggerRunnable, "Cannot change while running");
        this.action = action;
        return this;
    }

    public SmoothTrigger setDelayAfterLastTriggerMs(long delayAfterLastTriggerMs) {
        AssertTools.assertNull(this.smoothTriggerRunnable, "Cannot change while running");
        this.delayAfterLastTriggerMs = delayAfterLastTriggerMs;
        return this;
    }

    public SmoothTrigger setFirstPassThrough(boolean isFirstPassThrough) {
        AssertTools.assertNull(this.smoothTriggerRunnable, "Cannot change while running");
        this.isFirstPassThrough = isFirstPassThrough;
        return this;
    }

    public SmoothTrigger setMaxDelayAfterFirstRequestMs(long maxDelayAfterFirstRequestMs) {
        AssertTools.assertNull(this.smoothTriggerRunnable, "Cannot change while running");
        this.maxDelayAfterFirstRequestMs = maxDelayAfterFirstRequestMs;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmoothTrigger start() {
        Object object = this.internalUpdateLock;
        synchronized (object) {
            AssertTools.assertNotNull(this.action, "No action given");
            AssertTools.assertTrue(this.delayAfterLastTriggerMs >= 0L, "delayAfterLastTriggerMs must be 0 or bigger");
            AssertTools.assertTrue(this.maxDelayAfterFirstRequestMs >= this.delayAfterLastTriggerMs, "maxDelayAfterFirstRequestMs must be greater or equals to delayAfterLastTriggerMs");
            AssertTools.assertNull(this.smoothTriggerRunnable, "Already started");
            this.smoothTriggerRunnable = new SmoothTriggerRunnable(this);
            this.smoothTriggerThread = new Thread((Runnable)this.smoothTriggerRunnable, "SmoothTrigger");
            this.smoothTriggerThread.setDaemon(true);
            this.smoothTriggerThread.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean executeActionIfPending) {
        Object object = this.internalUpdateLock;
        synchronized (object) {
            AssertTools.assertNotNull(this.smoothTriggerRunnable, "Not running");
            this.smoothTriggerRunnable.requestStop();
            this.smoothTriggerThread.interrupt();
            try {
                this.smoothTriggerThread.join();
            }
            catch (InterruptedException e) {
                throw new SmallToolsException("Interrupted while waiting for the Thread to stop", e);
            }
            if (executeActionIfPending) {
                this.smoothTriggerRunnable.executeActionIfPending(true);
            }
            this.smoothTriggerRunnable = null;
            this.smoothTriggerThread = null;
        }
    }
}

