/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools.sync;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.sync.SyncConfigurationCheckUpdate;
import com.foilen.smalltools.tools.sync.SyncConfigurationRetrieveSlice;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SyncConfiguration<I, E, P> {
    private long maxSliceSize = 1000L;
    private Function<E, I> idFromEntity = a -> {
        throw new SmallToolsException("idFromEntity not provided");
    };
    private Function<P, I> idFromPartial = a -> {
        throw new SmallToolsException("idFromPartial not provided");
    };
    private BiFunction<I, I, Integer> compareId = (a, b) -> {
        throw new SmallToolsException("compareId not provided");
    };
    private SyncConfigurationRetrieveSlice<I, E> sourceSlice = (a, b) -> {
        throw new SmallToolsException("sourceSlice not provided");
    };
    private SyncConfigurationRetrieveSlice<I, P> destinationSlice = (a, b) -> {
        throw new SmallToolsException("destinationSlice not provided");
    };
    private SyncConfigurationCheckUpdate<E, P> needsUpdate = (a, b) -> false;
    private Consumer<List<E>> addHandler = a -> {
        throw new SmallToolsException("addHandler not provided");
    };
    private Consumer<List<E>> updateHandler = entities -> {
        this.getDeleteHandler().accept(entities.stream().map(this.getIdFromEntity()).collect(Collectors.toList()));
        this.getAddHandler().accept((List<E>)entities);
    };
    private Consumer<List<I>> deleteHandler = a -> {
        throw new SmallToolsException("deleteHandler not provided");
    };

    public Consumer<List<E>> getAddHandler() {
        return this.addHandler;
    }

    public BiFunction<I, I, Integer> getCompareId() {
        return this.compareId;
    }

    public Consumer<List<I>> getDeleteHandler() {
        return this.deleteHandler;
    }

    public SyncConfigurationRetrieveSlice<I, P> getDestinationSlice() {
        return this.destinationSlice;
    }

    public Function<E, I> getIdFromEntity() {
        return this.idFromEntity;
    }

    public Function<P, I> getIdFromPartial() {
        return this.idFromPartial;
    }

    public long getMaxSliceSize() {
        return this.maxSliceSize;
    }

    public SyncConfigurationCheckUpdate<E, P> getNeedsUpdate() {
        return this.needsUpdate;
    }

    public SyncConfigurationRetrieveSlice<I, E> getSourceSlice() {
        return this.sourceSlice;
    }

    public Consumer<List<E>> getUpdateHandler() {
        return this.updateHandler;
    }

    public SyncConfiguration<I, E, P> setAddHandler(Consumer<List<E>> addHandler) {
        this.addHandler = addHandler;
        return this;
    }

    public SyncConfiguration<I, E, P> setCompareId(BiFunction<I, I, Integer> compareId) {
        this.compareId = compareId;
        return this;
    }

    public SyncConfiguration<I, E, P> setDeleteHandler(Consumer<List<I>> deleteHandler) {
        this.deleteHandler = deleteHandler;
        return this;
    }

    public SyncConfiguration<I, E, P> setDestinationSlice(SyncConfigurationRetrieveSlice<I, P> destinationSlice) {
        this.destinationSlice = destinationSlice;
        return this;
    }

    public SyncConfiguration<I, E, P> setIdFromEntity(Function<E, I> idFromEntity) {
        this.idFromEntity = idFromEntity;
        return this;
    }

    public SyncConfiguration<I, E, P> setIdFromPartial(Function<P, I> idFromPartial) {
        this.idFromPartial = idFromPartial;
        return this;
    }

    public SyncConfiguration<I, E, P> setMaxSliceSize(long maxSliceSize) {
        this.maxSliceSize = maxSliceSize;
        return this;
    }

    public SyncConfiguration<I, E, P> setNeedsUpdate(SyncConfigurationCheckUpdate<E, P> needsUpdate) {
        this.needsUpdate = needsUpdate;
        return this;
    }

    public SyncConfiguration<I, E, P> setSourceSlice(SyncConfigurationRetrieveSlice<I, E> sourceSlice) {
        this.sourceSlice = sourceSlice;
        return this;
    }

    public SyncConfiguration<I, E, P> setUpdateHandler(Consumer<List<E>> updateHandler) {
        this.updateHandler = updateHandler;
        return this;
    }
}

