/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools.internal;

import com.foilen.smalltools.event.EventList;
import com.foilen.smalltools.tools.CloseableTools;
import com.foilen.smalltools.tools.SocketTools;
import com.foilen.smalltools.tools.StreamsTools;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowStreamThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(FlowStreamThread.class);
    private InputStream source;
    private OutputStream destination;
    private boolean closeAtEnd;
    private EventList<String> completedEventList = new EventList();
    private CompletableFuture<Void> future = new CompletableFuture();

    public FlowStreamThread(InputStream source, OutputStream destination, boolean closeAtEnd) {
        this.source = source;
        this.destination = destination;
        this.closeAtEnd = closeAtEnd;
    }

    public EventList<String> getCompletedEventList() {
        return this.completedEventList;
    }

    public Future<Void> getFuture() {
        return this.future;
    }

    @Override
    public void run() {
        try {
            StreamsTools.flowStream(this.source, this.destination);
            this.completedEventList.dispatch("success");
        }
        catch (Exception e) {
            if (SocketTools.isADisconnectionException(e)) {
                logger.debug("Disconnected");
                this.completedEventList.dispatch("disconnected");
            } else {
                this.completedEventList.dispatch("error");
                logger.error("Problem while streaming", (Throwable)e);
            }
        }
        finally {
            if (this.closeAtEnd) {
                CloseableTools.close(this.source);
                CloseableTools.close(this.destination);
            }
            this.future.complete(null);
        }
    }

    public void setCompletedEventList(EventList<String> completedEventList) {
        this.completedEventList = completedEventList;
    }
}

