/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.tools.DateTools;
import com.foilen.smalltools.tools.JsonTools;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ThreadNameStateTool {
    private List<String> previousName = new ArrayList<String>();
    private List<String> currentName;
    private List<String> nextName;
    private String separator = "";

    public ThreadNameStateTool() {
        this.previousName.add(Thread.currentThread().getName());
        this.currentName = new ArrayList<String>();
        this.currentName.add(Thread.currentThread().getName());
        this.nextName = new ArrayList<String>();
        this.nextName.add(Thread.currentThread().getName());
    }

    public ThreadNameStateTool appendDate() {
        this.appendDate(new Date());
        return this;
    }

    public ThreadNameStateTool appendDate(Date date) {
        if (date == null) {
            this.nextName.add("null");
        } else {
            this.nextName.add(DateTools.formatFull(date));
        }
        return this;
    }

    public ThreadNameStateTool appendJson(Object object) {
        if (object == null) {
            this.nextName.add("null");
        } else {
            this.nextName.add(JsonTools.compactPrint(object));
        }
        return this;
    }

    public ThreadNameStateTool appendObjectClass(Object object) {
        if (object == null) {
            this.nextName.add("null");
        } else {
            this.nextName.add(object.getClass().getName());
        }
        return this;
    }

    public ThreadNameStateTool appendObjectClassSimple(Object object) {
        if (object == null) {
            this.nextName.add("null");
        } else {
            this.nextName.add(object.getClass().getSimpleName());
        }
        return this;
    }

    public ThreadNameStateTool appendObjectText(Object object) {
        if (object == null) {
            this.nextName.add("null");
        } else {
            this.nextName.add(object.toString());
        }
        return this;
    }

    public ThreadNameStateTool appendText(String text) {
        this.nextName.add(text);
        return this;
    }

    public ThreadNameStateTool change() {
        this.previousName.clear();
        this.previousName.addAll(this.currentName);
        this.currentName.clear();
        this.currentName.addAll(this.nextName);
        Thread.currentThread().setName(Joiner.on((String)this.separator).join(this.nextName));
        return this;
    }

    public ThreadNameStateTool clear() {
        this.nextName = new ArrayList<String>();
        return this;
    }

    public ThreadNameStateTool pop() {
        if (!this.nextName.isEmpty()) {
            this.nextName.remove(this.nextName.size() - 1);
        }
        return this;
    }

    public ThreadNameStateTool revert() {
        this.nextName.clear();
        this.nextName.addAll(this.previousName);
        this.change();
        return this;
    }

    public ThreadNameStateTool setSeparator(String separator) {
        this.separator = separator;
        return this;
    }
}

