/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.tools.AbstractBasics;
import java.util.Optional;

public class SearchingAvailabilityTools<T extends Comparable<T>>
extends AbstractBasics {
    private T min;
    private T max;
    private long range;
    private CheckAvailability<T> checkAvailability;
    private T cursor;

    public SearchingAvailabilityTools(T min, T max, long range, CheckAvailability<T> checkAvailability) {
        this.min = min;
        this.max = max;
        this.range = range;
        this.checkAvailability = checkAvailability;
        this.cursor = min;
    }

    public synchronized Optional<T> getNext() {
        this.logger.debug("Search: min={}, cursor={}, max={}, range={}", new Object[]{this.min, this.cursor, this.max, this.range});
        T initialCursor = this.cursor;
        boolean didLoop = false;
        while (!didLoop || this.cursor.compareTo(initialCursor) < 0) {
            Comparable to = (Comparable)this.checkAvailability.increment(this.cursor, this.range);
            Comparable stepTo = this.min(to, this.max);
            this.logger.debug("Next Available: cursor={}, stepTo={}", this.cursor, (Object)stepTo);
            Optional<Comparable> next = this.checkAvailability.nextAvailable((Comparable)this.cursor, stepTo);
            this.logger.debug("Found: {}", next);
            if (next.isPresent()) {
                this.cursor = this.checkAvailability.increment(next.get(), 1L);
                if (this.cursor.compareTo(this.max) > 0) {
                    this.cursor = this.min;
                }
                return next;
            }
            this.cursor = this.checkAvailability.increment(stepTo, 1L);
            if (this.cursor.compareTo(this.max) <= 0) continue;
            this.cursor = this.min;
            didLoop = true;
        }
        return Optional.empty();
    }

    private T min(T a, T b) {
        if (a.compareTo(b) < 0) {
            return a;
        }
        return b;
    }

    public static interface CheckAvailability<T> {
        public T increment(T var1, long var2);

        public Optional<T> nextAvailable(T var1, T var2);
    }
}

