/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.iterable.FileLinesIterable;
import com.foilen.smalltools.tools.StreamsTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;

public final class ResourceTools {
    public static void copyToFile(String resource, Class<?> context, File destinationFile) {
        try {
            FileOutputStream fos = new FileOutputStream(destinationFile);
            StreamsTools.flowStream(context.getResourceAsStream(resource), fos);
            fos.close();
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public static void copyToFile(String resource, File destinationFile) {
        ResourceTools.copyToFile(resource, ResourceTools.class, destinationFile);
    }

    public static byte[] getResourceAsBytes(String resource) {
        return ResourceTools.getResourceAsBytes(resource, ResourceTools.class);
    }

    public static byte[] getResourceAsBytes(String resource, Class<?> context) {
        return StreamsTools.consumeAsBytes(context.getResourceAsStream(resource));
    }

    public static InputStream getResourceAsStream(String resource) {
        return ResourceTools.getResourceAsStream(resource, ResourceTools.class);
    }

    public static InputStream getResourceAsStream(String resource, Class<?> context) {
        return context.getResourceAsStream(resource);
    }

    public static String getResourceAsString(String resource) {
        return ResourceTools.getResourceAsString(resource, ResourceTools.class);
    }

    public static String getResourceAsString(String resource, Class<?> context) {
        return StreamsTools.consumeAsString(context.getResourceAsStream(resource));
    }

    public static String getResourceDir(Class<?> classType) {
        String className = classType.getSimpleName();
        return ResourceTools.getResourceDir(className + ".class", classType);
    }

    public static String getResourceDir(String resource, Class<?> context) {
        URL url = context.getResource(resource);
        String resourcePath = url.toExternalForm();
        int pos = (resourcePath = resourcePath.substring(6)).lastIndexOf(47);
        if (pos != -1) {
            resourcePath = resourcePath.substring(0, pos + 1);
        }
        return resourcePath;
    }

    public static FileLinesIterable readResourceLinesIteration(String resource) {
        return ResourceTools.readResourceLinesIteration(resource, ResourceTools.class);
    }

    public static FileLinesIterable readResourceLinesIteration(String resource, Class<?> context) {
        FileLinesIterable fileLinesIterable = new FileLinesIterable();
        fileLinesIterable.openStream(ResourceTools.getResourceAsStream(resource, context));
        return fileLinesIterable;
    }

    private ResourceTools() {
    }
}

