/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

public class JdbcUriTools {
    private String schema;
    private String username;
    private String password;
    private String server;
    private String database;
    private Map<String, String> options = new TreeMap<String, String>();

    public JdbcUriTools(String uriText) {
        if (!uriText.startsWith("jdbc:")) {
            throw new SmallToolsException("JDBC URI must start with 'jdbc:'");
        }
        uriText = uriText.substring(5);
        try {
            String query;
            URI uri = new URI(uriText);
            this.schema = uri.getScheme();
            String uriAuthority = uri.getAuthority();
            String[] authServer = uriAuthority.split("@");
            if (authServer.length == 1) {
                this.server = authServer[0];
            } else {
                int serverPos = uriAuthority.lastIndexOf("@");
                String userAndPass = uriAuthority.substring(0, serverPos);
                String[] userAndPassParts = userAndPass.split("\\:");
                this.username = userAndPassParts[0];
                if (userAndPassParts.length > 1) {
                    this.password = userAndPassParts[1];
                }
                this.server = uriAuthority.substring(serverPos + 1);
            }
            String uriPath = uri.getPath();
            if (uriPath.length() > 1) {
                this.database = uriPath.substring(1);
            }
            if ((query = uri.getQuery()) != null) {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(Joiner.on((char)'\n').join((Object[])query.split("\\&")).getBytes()));
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.options.put(key.toString(), value.toString())));
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Bad uri", e);
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toUri() {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:").append(this.schema).append("://");
        if (this.username != null) {
            sb.append(URLEncoder.encode(this.username, StandardCharsets.UTF_8));
            if (this.password != null) {
                sb.append(":");
                sb.append(URLEncoder.encode(this.password, StandardCharsets.UTF_8));
            }
            sb.append("@");
        }
        sb.append(this.server);
        if (this.database != null || !this.options.isEmpty()) {
            sb.append("/");
        }
        if (this.database != null) {
            sb.append(this.database);
        }
        if (!this.options.isEmpty()) {
            sb.append("?");
            AtomicBoolean first = new AtomicBoolean(true);
            this.options.forEach((name, value) -> {
                if (first.get()) {
                    first.set(false);
                } else {
                    sb.append("&");
                }
                sb.append((String)name).append("=").append((String)value);
            });
        }
        return sb.toString();
    }
}

