/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTools {
    private static final Logger logger = LoggerFactory.getLogger(ImageTools.class);

    public static File scale(File inputFile, float scale, String outputFormatName) {
        try {
            BufferedImage inputImage = ImageIO.read(inputFile);
            int scaledWitdh = (int)((float)inputImage.getWidth() * scale);
            int scaledHeight = (int)((float)inputImage.getHeight() * scale);
            Image scaledImage = inputImage.getScaledInstance(scaledWitdh, scaledHeight, 4);
            BufferedImage outputImage = new BufferedImage(scaledWitdh, scaledHeight, 1);
            Graphics2D graphics = outputImage.createGraphics();
            graphics.drawImage(scaledImage, 0, 0, null);
            graphics.dispose();
            File outputFile = File.createTempFile("scaledImage", "." + outputFormatName);
            ImageIO.write((RenderedImage)outputImage, outputFormatName, outputFile);
            return outputFile;
        }
        catch (Exception e) {
            logger.error("Problem scaling", (Throwable)e);
            return null;
        }
    }

    public static void scale(InputStream inputStream, float scale, String outputFormatName, OutputStream outputStream) {
        try {
            BufferedImage inputImage = ImageIO.read(inputStream);
            int scaledWitdh = (int)((float)inputImage.getWidth() * scale);
            int scaledHeight = (int)((float)inputImage.getHeight() * scale);
            Image scaledImage = inputImage.getScaledInstance(scaledWitdh, scaledHeight, 4);
            BufferedImage outputImage = new BufferedImage(scaledWitdh, scaledHeight, 1);
            Graphics2D graphics = outputImage.createGraphics();
            graphics.drawImage(scaledImage, 0, 0, null);
            graphics.dispose();
            ImageIO.write((RenderedImage)outputImage, outputFormatName, outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem scaling", e);
        }
    }
}

