/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

public class FrequencyConverterTools {
    public static long K = 1000L;
    public static long M = 1000L * K;
    public static long G = 1000L * M;
    public static long T = 1000L * G;

    public static String convertToBiggestHzUnit(Long hertz) {
        if (hertz == null) {
            return null;
        }
        String unit = "Hz";
        double main = hertz.longValue();
        if (hertz >= T) {
            unit = "Thz";
            main /= (double)T;
        } else if (hertz >= G) {
            unit = "Ghz";
            main /= (double)G;
        } else if (hertz >= M) {
            unit = "Mhz";
            main /= (double)M;
        } else if (hertz >= K) {
            unit = "Khz";
            main /= (double)K;
        }
        main *= 100.0;
        main = (double)Math.round(main) / 100.0;
        String text = String.valueOf(main);
        int dotPos = text.indexOf(46);
        if (dotPos != -1) {
            int maxDecimalPos = Math.min(text.length(), dotPos + 3);
            while ((text.charAt(maxDecimalPos - 1) == '.' || text.charAt(maxDecimalPos - 1) == '0') && text.charAt(--maxDecimalPos) != '.') {
            }
            text = text.substring(0, maxDecimalPos);
        }
        return text + unit;
    }
}

