/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.reflection;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.reflection.VisitField;
import com.foilen.smalltools.tools.AssertTools;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ReflectionTools {
    public static List<Field> allFields(Class<?> clazz) {
        AssertTools.assertNotNull(clazz, "The class cannot be null");
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> currentType : ReflectionTools.allTypes(clazz)) {
            for (Field field : currentType.getDeclaredFields()) {
                result.add(field);
            }
        }
        return result;
    }

    public static List<Field> allFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        AssertTools.assertNotNull(annotationClass, "The annotation cannot be null");
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : ReflectionTools.allFields(clazz)) {
            if (field.getAnnotation(annotationClass) == null) continue;
            result.add(field);
        }
        return result;
    }

    public static List<Method> allMethods(Class<?> clazz) {
        AssertTools.assertNotNull(clazz, "The class cannot be null");
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> currentType : ReflectionTools.allTypes(clazz)) {
            for (Method method : currentType.getDeclaredMethods()) {
                result.add(method);
            }
        }
        return result;
    }

    public static List<Method> allMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        AssertTools.assertNotNull(annotationClass, "The annotation cannot be null");
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : ReflectionTools.allMethods(clazz)) {
            if (method.getAnnotation(annotationClass) == null) continue;
            result.add(method);
        }
        return result;
    }

    public static List<Class<?>> allTypes(Class<?> clazz) {
        AssertTools.assertNotNull(clazz, "The class cannot be null");
        ArrayList result = new ArrayList();
        ReflectionTools.allTypes(result, clazz);
        return result;
    }

    private static void allTypes(List<Class<?>> classes, Class<?> clazz) {
        AssertTools.assertNotNull(clazz, "The class cannot be null");
        classes.add(clazz);
        for (Class<?> superClass : clazz.getInterfaces()) {
            ReflectionTools.allTypes(classes, superClass);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionTools.allTypes(classes, superClass);
        }
    }

    public static void copyAllProperties(Object from, Object to) {
        AssertTools.assertNotNull(from, "The from cannot be null");
        AssertTools.assertNotNull(to, "The to cannot be null");
        try {
            BeanInfo fromBeanInfo = Introspector.getBeanInfo(from.getClass());
            BeanInfo toBeanInfo = Introspector.getBeanInfo(to.getClass());
            PropertyDescriptor[] fromPropertyDescriptors = fromBeanInfo.getPropertyDescriptors();
            PropertyDescriptor[] toPropertyDescriptors = toBeanInfo.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> toPropertyDescriptorByName = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor toPropertyDescriptor : toPropertyDescriptors) {
                if (toPropertyDescriptor.getWriteMethod() == null) continue;
                toPropertyDescriptorByName.put(toPropertyDescriptor.getName(), toPropertyDescriptor);
            }
            for (PropertyDescriptor fromPropertyDescriptor : fromPropertyDescriptors) {
                PropertyDescriptor toPropertyDescriptor = (PropertyDescriptor)toPropertyDescriptorByName.get(fromPropertyDescriptor.getName());
                if (toPropertyDescriptor == null) continue;
                Class<?> fromType = fromPropertyDescriptor.getPropertyType();
                Class<?> toType = toPropertyDescriptor.getPropertyType();
                if (!toType.isAssignableFrom(fromType)) continue;
                Method writeMethod = toPropertyDescriptor.getWriteMethod();
                Method readMethod = fromPropertyDescriptor.getReadMethod();
                if (writeMethod == null || readMethod == null) continue;
                writeMethod.invoke(to, readMethod.invoke(from, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem copying properties", e);
        }
    }

    public static <T extends Annotation> T findAnnotationByFieldNameAndAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        for (Class<?> oneClass : ReflectionTools.allTypes(clazz)) {
            Field field;
            try {
                field = oneClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                continue;
            }
            T annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static <T> T instantiate(Class<T> clazz, Object ... contructorParams) {
        ArrayList contructorParamTypes = new ArrayList(contructorParams.length);
        for (Object contructorParam : contructorParams) {
            if (contructorParam == null) {
                contructorParamTypes.add(null);
                continue;
            }
            contructorParamTypes.add(contructorParam.getClass());
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            try {
                return (T)constructors[0].newInstance(contructorParams);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new SmallToolsException("Could not instanciate the class " + clazz.getName(), e);
            }
        }
        for (Constructor<?> constructor : constructors) {
            Class<?>[] currentTypes = constructor.getParameterTypes();
            if (currentTypes.length != contructorParamTypes.size()) continue;
            boolean allRightTypes = true;
            for (int i = 0; i < currentTypes.length; ++i) {
                Class contructorParamType = (Class)contructorParamTypes.get(i);
                if (contructorParamType == null || currentTypes[i].equals(contructorParamType) || currentTypes[i].isAssignableFrom(contructorParamType)) continue;
                allRightTypes = false;
                break;
            }
            if (!allRightTypes) continue;
            try {
                return (T)constructor.newInstance(contructorParams);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new SmallToolsException("Could not instanciate the class " + clazz.getName(), e);
            }
        }
        throw new SmallToolsException("Could not instanciate the class " + clazz.getName() + " since couldn't find the right constructor");
    }

    public static Class<?> safelyGetClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static void visitAllFields(Object object, VisitField visitField) {
        AssertTools.assertNotNull(object, "You must set an object");
        AssertTools.assertNotNull(visitField, "You must have a visitor");
        for (Field field : ReflectionTools.allFields(object.getClass())) {
            visitField.visitField(field, object);
        }
    }

    public static void visitAllFields(Object[] objects, VisitField visitField) {
        AssertTools.assertNotNull(objects, "You must set an objects array");
        AssertTools.assertNotNull(visitField, "You must have a visitor");
        for (Object object : objects) {
            ReflectionTools.visitAllFields(object, visitField);
        }
    }

    private ReflectionTools() {
    }
}

