/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.listscomparator;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.listscomparator.ListComparatorHandler;
import com.foilen.smalltools.listscomparator.ListsComparator;
import com.foilen.smalltools.listscomparator.ListsComparatorDifference;
import com.foilen.smalltools.tools.AbstractBasics;
import com.foilen.smalltools.tools.ExecutorsTools;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class SpliteratorComparatorDifference<T extends Comparable<T>>
extends AbstractBasics
implements Spliterator<ListsComparatorDifference<T>>,
Runnable {
    private BlockingQueue<ListsComparatorDifference<T>> queue = new ArrayBlockingQueue<ListsComparatorDifference<T>>(50);
    private volatile boolean completed = false;
    private Semaphore semaphore = new Semaphore(0);
    private volatile SmallToolsException exception;
    private Stream<T> lefts;
    private Stream<T> rights;

    public SpliteratorComparatorDifference(Stream<T> lefts, Stream<T> rights) {
        this.lefts = lefts;
        this.rights = rights;
        ExecutorsTools.getCachedDaemonThreadPool().execute(this);
    }

    @Override
    public int characteristics() {
        return 1028;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public Comparator<? super ListsComparatorDifference<T>> getComparator() {
        return (a, b) -> ((Comparable)a.getObject()).compareTo((Comparable)b.getObject());
    }

    @Override
    public void run() {
        try {
            ListsComparator.compareStreams(this.lefts, this.rights, new ListComparatorHandler<T, T>(){

                @Override
                public void both(T left, T right) {
                }

                @Override
                public void leftOnly(T left) {
                    try {
                        SpliteratorComparatorDifference.this.queue.put(new ListsComparatorDifference(left, -1));
                        SpliteratorComparatorDifference.this.semaphore.release();
                    }
                    catch (InterruptedException e) {
                        throw new SmallToolsException(e);
                    }
                }

                @Override
                public void rightOnly(T right) {
                    try {
                        SpliteratorComparatorDifference.this.queue.put(new ListsComparatorDifference(right, 1));
                        SpliteratorComparatorDifference.this.semaphore.release();
                    }
                    catch (InterruptedException e) {
                        throw new SmallToolsException(e);
                    }
                }
            });
            this.completed = true;
        }
        catch (SmallToolsException e) {
            this.exception = e;
        }
        catch (Throwable e) {
            this.exception = new SmallToolsException(e);
        }
        this.semaphore.release();
    }

    @Override
    public boolean tryAdvance(Consumer<? super ListsComparatorDifference<T>> action) {
        try {
            this.semaphore.acquire();
            ListsComparatorDifference difference = (ListsComparatorDifference)this.queue.poll();
            if (difference != null) {
                action.accept(difference);
                return true;
            }
            if (this.completed) {
                return false;
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        catch (InterruptedException e) {
            throw new SmallToolsException(e);
        }
        throw new SmallToolsException("Unexpected state");
    }

    @Override
    public Spliterator<ListsComparatorDifference<T>> trySplit() {
        return null;
    }
}

