/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.consolerunner;

import com.foilen.smalltools.TimeoutHandler;
import com.foilen.smalltools.consolerunner.ConsoleRunner;
import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.CloseableTools;
import com.foilen.smalltools.tools.StreamsTools;
import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsoleTimeoutHandlerRunnable
implements TimeoutHandler.TimeoutHandlerRunnable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleTimeoutHandlerRunnable.class);
    private static final AtomicLong nextRunnerId = new AtomicLong();
    private ConsoleRunner consoleRunner;
    private Process process;
    private int statusCode;
    private RuntimeException exceptionThrown;

    public ConsoleTimeoutHandlerRunnable(ConsoleRunner consoleUtils) {
        this.consoleRunner = consoleUtils;
    }

    @Override
    public Integer result() {
        if (this.exceptionThrown != null) {
            throw this.exceptionThrown;
        }
        return this.statusCode;
    }

    @Override
    public void run() {
        long runnerId = nextRunnerId.getAndIncrement();
        String command = this.consoleRunner.getCommand();
        String workingDirectory = this.consoleRunner.getWorkingDirectory();
        List<String> arguments = this.consoleRunner.getArguments();
        InputStream consoleInput = this.consoleRunner.getConsoleInput();
        OutputStream consoleOutput = this.consoleRunner.getConsoleOutput();
        OutputStream consoleError = this.consoleRunner.getConsoleError();
        boolean closeConsoleOutput = this.consoleRunner.isCloseConsoleOutput();
        boolean closeConsoleError = this.consoleRunner.isCloseConsoleError();
        Map<String, String> environments = this.consoleRunner.getEnvironments();
        boolean overrideEnvironment = this.consoleRunner.isOverrideEnvironment();
        boolean redirectErrorStream = this.consoleRunner.isRedirectErrorStream();
        if (Strings.isNullOrEmpty((String)command)) {
            throw new SmallToolsException("No command is set");
        }
        ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add(command);
        if (arguments != null) {
            fullCommand.addAll(arguments);
        }
        try {
            try {
                logger.debug("[{}] Command to run: {}", (Object)runnerId, fullCommand);
                ProcessBuilder processBuilder = new ProcessBuilder(fullCommand);
                if (!Strings.isNullOrEmpty((String)workingDirectory)) {
                    processBuilder.directory(new File(workingDirectory));
                }
                Map<String, String> subProcEnv = processBuilder.environment();
                if (overrideEnvironment) {
                    subProcEnv.clear();
                }
                subProcEnv.putAll(environments);
                this.process = processBuilder.start();
                ArrayList<Future<Void>> streamFutures = new ArrayList<Future<Void>>();
                processBuilder.redirectErrorStream(redirectErrorStream);
                if (consoleInput == null) {
                    CloseableTools.close(this.process.getOutputStream());
                } else {
                    streamFutures.add(StreamsTools.flowStreamNonBlocking(consoleInput, this.process.getOutputStream(), true, "stdin-" + runnerId).getFuture());
                }
                if (consoleOutput == null) {
                    CloseableTools.close(this.process.getInputStream());
                } else {
                    streamFutures.add(StreamsTools.flowStreamNonBlocking(this.process.getInputStream(), consoleOutput, false, "stdout-" + runnerId).getFuture());
                }
                if (consoleError == null) {
                    CloseableTools.close(this.process.getErrorStream());
                } else if (!redirectErrorStream) {
                    streamFutures.add(StreamsTools.flowStreamNonBlocking(this.process.getErrorStream(), consoleError, false, "stderr-" + runnerId).getFuture());
                }
                this.process.waitFor();
                streamFutures.forEach(f -> {
                    try {
                        f.get();
                    }
                    catch (Exception e) {
                        throw new SmallToolsException("Got an exception while waiting for the completion of the streams", e);
                    }
                });
                if (closeConsoleOutput) {
                    CloseableTools.close(consoleOutput);
                }
                if (closeConsoleError) {
                    CloseableTools.close(consoleError);
                }
                this.statusCode = this.process.exitValue();
                if (this.statusCode == 0) {
                    logger.debug("[{}] Command {} succeeded", (Object)runnerId, fullCommand);
                } else {
                    logger.debug("[{}] Command {} failed. Exit code: {}", new Object[]{runnerId, fullCommand, this.statusCode});
                }
            }
            catch (Exception e) {
                logger.debug("[{}] Command {} failed.", new Object[]{runnerId, fullCommand, e});
                throw new SmallToolsException(e);
            }
        }
        catch (RuntimeException e) {
            this.exceptionThrown = e;
        }
    }

    @Override
    public void stopRequested() {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

