/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.consolerunner;

import com.foilen.smalltools.TimeoutHandler;
import com.foilen.smalltools.consolerunner.ConsoleKilledException;
import com.foilen.smalltools.consolerunner.ConsoleTimedoutException;
import com.foilen.smalltools.consolerunner.ConsoleTimeoutHandlerRunnable;
import com.foilen.smalltools.iterable.FileLinesIterable;
import com.foilen.smalltools.tools.StreamsTools;
import com.foilen.smalltools.tuple.Tuple2;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ConsoleRunner {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleRunner.class);
    private Long timeoutInMilliseconds = null;
    private String command;
    private String workingDirectory;
    private List<String> arguments = new ArrayList<String>();
    private Map<String, String> environments = new HashMap<String, String>();
    private boolean overrideEnvironment = false;
    private InputStream consoleInput;
    private OutputStream consoleOutput = System.out;
    private OutputStream consoleError = System.err;
    private boolean redirectErrorStream = false;
    private boolean closeConsoleOutput = false;
    private boolean closeConsoleError = false;
    private int statusCode;
    private ConsoleTimeoutHandlerRunnable consoleTimeoutHandlerRunnable;
    private volatile boolean cancelled;

    public ConsoleRunner addArguments(List<String> arguments) {
        this.arguments.addAll(arguments);
        return this;
    }

    public ConsoleRunner addArguments(String ... arguments) {
        for (String argument : arguments) {
            this.arguments.add(argument);
        }
        return this;
    }

    public ConsoleRunner addEnvironment(String name, String value) {
        this.environments.put(name, value);
        return this;
    }

    public int execute() {
        this.cancelled = false;
        this.consoleTimeoutHandlerRunnable = new ConsoleTimeoutHandlerRunnable(this);
        if (this.timeoutInMilliseconds == null) {
            this.consoleTimeoutHandlerRunnable.run();
            this.statusCode = this.consoleTimeoutHandlerRunnable.result();
        } else {
            TimeoutHandler<Integer> handler = new TimeoutHandler<Integer>(this.timeoutInMilliseconds, this.consoleTimeoutHandlerRunnable);
            try {
                this.statusCode = handler.call();
            }
            catch (InterruptedException e) {
                logger.debug("The console timed out");
                throw new ConsoleTimedoutException();
            }
        }
        if (this.cancelled) {
            throw new ConsoleKilledException();
        }
        return this.statusCode;
    }

    public FileLinesIterable executeForLineIterator() {
        String output = this.executeForString();
        FileLinesIterable fileLinesIterable = new FileLinesIterable();
        fileLinesIterable.openString(output);
        return fileLinesIterable;
    }

    public String executeForString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.consoleOutput = byteArrayOutputStream;
        this.execute();
        return byteArrayOutputStream.toString();
    }

    public Tuple2<String, String> executeForStrings() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.consoleOutput = byteArrayOutputStream;
        ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
        this.consoleError = byteArrayErrorStream;
        this.redirectErrorStream = false;
        this.execute();
        return new Tuple2<String, String>(byteArrayOutputStream.toString(), byteArrayErrorStream.toString());
    }

    public int executeWithLogger(Logger outputLogger, Level level) {
        this.consoleOutput = StreamsTools.createLoggerOutputStream(outputLogger, level);
        this.closeConsoleOutput = true;
        return this.execute();
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getCommand() {
        return this.command;
    }

    public OutputStream getConsoleError() {
        return this.consoleError;
    }

    public InputStream getConsoleInput() {
        return this.consoleInput;
    }

    public OutputStream getConsoleOutput() {
        return this.consoleOutput;
    }

    public Map<String, String> getEnvironments() {
        return this.environments;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isCloseConsoleError() {
        return this.closeConsoleError;
    }

    public boolean isCloseConsoleOutput() {
        return this.closeConsoleOutput;
    }

    public boolean isOverrideEnvironment() {
        return this.overrideEnvironment;
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public ConsoleRunner setArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public ConsoleRunner setCloseConsoleError(boolean closeConsoleError) {
        this.closeConsoleError = closeConsoleError;
        return this;
    }

    public ConsoleRunner setCloseConsoleOutput(boolean closeConsoleOutput) {
        this.closeConsoleOutput = closeConsoleOutput;
        return this;
    }

    public ConsoleRunner setCommand(String command) {
        this.command = command;
        return this;
    }

    public ConsoleRunner setConsoleError(OutputStream consoleError) {
        this.consoleError = consoleError;
        return this;
    }

    public ConsoleRunner setConsoleInput(InputStream consoleInput) {
        this.consoleInput = consoleInput;
        return this;
    }

    public ConsoleRunner setConsoleOutput(OutputStream consoleOutput) {
        this.consoleOutput = consoleOutput;
        return this;
    }

    public ConsoleRunner setEnvironments(Map<String, String> environments) {
        this.environments = environments;
        return this;
    }

    public ConsoleRunner setOverrideEnvironment(boolean overrideEnvironment) {
        this.overrideEnvironment = overrideEnvironment;
        return this;
    }

    public ConsoleRunner setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public ConsoleRunner setTimeoutInMilliseconds(Long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        return this;
    }

    public ConsoleRunner setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public void stopRequested() {
        if (this.consoleTimeoutHandlerRunnable != null) {
            this.cancelled = true;
            this.consoleTimeoutHandlerRunnable.stopRequested();
        }
    }
}

