/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.compress;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.tools.DirectoryTools;
import com.foilen.smalltools.tools.StreamsTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipFiles {
    private ZipInputStream zis;
    private boolean ignoreFirstSubpath = false;

    public UnzipFiles(File zipFile) {
        try {
            this.zis = new ZipInputStream(new FileInputStream(zipFile));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException("The zip file does not exists", e);
        }
    }

    public UnzipFiles(InputStream inputStream) {
        this.zis = new ZipInputStream(inputStream);
    }

    private String cleanZipName(String name) {
        int firstPathPos;
        if (this.ignoreFirstSubpath && (firstPathPos = name.indexOf("/")) != -1) {
            name = name.substring(firstPathPos + 1);
        }
        return name;
    }

    public void extractTo(File destinationDirectory) {
        AssertTools.assertTrue(destinationDirectory.isDirectory(), "The destination is not a directory");
        try {
            ZipEntry zipEntry = this.zis.getNextEntry();
            while (zipEntry != null) {
                String fullPath = destinationDirectory.getAbsolutePath() + File.separatorChar + this.cleanZipName(zipEntry.getName());
                if (!DirectoryTools.createPathToFile(fullPath)) {
                    throw new SmallToolsException("Could not create the directories to " + fullPath);
                }
                if (zipEntry.isDirectory()) {
                    DirectoryTools.createPath(fullPath);
                } else {
                    FileOutputStream fout = new FileOutputStream(fullPath);
                    StreamsTools.flowStream(this.zis, fout, false);
                    this.zis.closeEntry();
                    fout.close();
                }
                zipEntry = this.zis.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem reading the zip", e);
        }
        finally {
            try {
                this.zis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void extractTo(String destinationDirectory) {
        this.extractTo(new File(destinationDirectory));
    }

    public boolean isIgnoreFirstSubpath() {
        return this.ignoreFirstSubpath;
    }

    public void setIgnoreFirstSubpath(boolean ignoreFirstSubpath) {
        this.ignoreFirstSubpath = ignoreFirstSubpath;
    }
}

