/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools;

public class TimeoutHandler<T> {
    private long timeoutInMilliseconds;
    private TimeoutHandlerRunnable<T> runnable;

    public TimeoutHandler(long timeoutInMilliseconds, TimeoutHandlerRunnable<T> runnable) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.runnable = runnable;
    }

    public T call() throws InterruptedException {
        Thread callThread = new Thread(this.runnable, "TimeoutHandler");
        callThread.start();
        callThread.join(this.timeoutInMilliseconds);
        if (callThread.isAlive()) {
            this.runnable.stopRequested();
            callThread.interrupt();
            throw new InterruptedException("The call is still running and the timeout passed");
        }
        return this.runnable.result();
    }

    public static interface TimeoutHandlerRunnable<T>
    extends Runnable {
        public T result();

        public void stopRequested();
    }
}

