/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

public class JavaEnvironmentValues {
    public static String getComputerName() {
        return System.getenv("COMPUTERNAME");
    }

    public static String getHomeDirectory() {
        return System.getProperty("user.home");
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return JavaEnvironmentValues.getComputerName();
        }
    }

    public static int getJavaClassVersion() {
        return Float.valueOf(System.getProperty("java.class.version")).intValue();
    }

    public static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    public static String getTemporaryDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        System.out.println("----[ Environment ]----");
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            System.out.println(entry.getKey() + " => " + entry.getValue());
        }
        System.out.println("----[ Properties ]----");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            System.out.println(entry.getKey() + " => " + entry.getValue());
        }
    }
}

