package com.flybits.android.push.models

/**
 * The [PushCategory] indicates which entity category the push notification effects. Below is the
 * the complete list of entity categories.
 *
 *  [PushCategory.CONTEXT]
 *  [PushCategory.KERNEL]
 *  [PushCategory.CUSTOM]
 *
 * @param key the String value representing each [PushCategory] option.
 *
 */
@Deprecated("Deprecated in version 1.19.0, will be removed in version 3.0.0")
enum class PushCategory(val key: String) {

    /**
     * Indicates that the entity associated to this notification belongs to the `CONTEXT`
     * category.
     */
    @Deprecated("Deprecated in version 1.19.0, will be removed in version 3.0.0")
    CONTEXT("context"),

    /**
     * Indicates that the entity associated to this notification belongs to the `CUSTOM`
     * category.
     */
    @Deprecated("Deprecated in version 1.19.0, will be removed in version 3.0.0")
    CUSTOM("custom"),

    /**
     * Indicates that the entity associated to this notification belongs to the `KERNEL`
     * category.
     */
    @Deprecated("Deprecated in version 1.19.0, will be removed in version 3.0.0")
    KERNEL("kernel"),

    /**
     * Indicates that a unknown category was received with the specified entity.
     */
    @Deprecated("Deprecated in version 1.19.0, will be removed in version 3.0.0")
    UNKNOWN("");

    companion object {

        /**
         * Get the `PushCategory` enum value corresponding to an String representation.
         *
         * @param key the String representation of the `PushCategory` enum.
         *
         * @return The `PushCategory` enum for the String representation.
         */
        @JvmStatic
        @Deprecated("Deprecated in version 1.19.0, will be removed in version 3.0.0")
        fun fromKey(key: String?): PushCategory {
            if (key == null) {
                return UNKNOWN
            }

            for (type in values()) {
                if (type.key.equals(key, ignoreCase = true)) {
                    return type
                }
            }
            return UNKNOWN
        }
    }
}